/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 * owindlg.c
 *
 */

#include <windows.h>
#include <stdlib.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "ngraph.h"
#include "object.h"
#include "nstring.h"
#include "jnstring.h"
#include "ioutil.h"

#define NAME "dialog"
#define PARENT "object"
#define VERSION  "1.00.00"
#define TRUE  1
#define FALSE 0

extern HINSTANCE hInstance;
extern int globallock;

#define ERRNODLGINST 100

#define ERRNUM 1

char *dlgerrorlist[ERRNUM]={
  "no instance for dialog",
};

int dlginit(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  if (_exeparent(obj,(char *)argv[1],inst,rval,argc,argv)) return 1;
  return 0;
}


int dlgdone(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  if (_exeparent(obj,(char *)argv[1],inst,rval,argc,argv)) return 1;
  return 0;
}

char *inputbuf;

BOOL CALLBACK dlgInputProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{

  int len;

  HWND hwndOwner;

  RECT rc,rcDlg,rcOwner;



  switch (uMsg) {

  case WM_INITDIALOG:

    if ((hwndOwner=GetParent(hwndDlg))==NULL) hwndOwner=GetDesktopWindow();

    GetWindowRect(hwndOwner,&rcOwner);

    GetWindowRect(hwndDlg,&rcDlg);

    CopyRect(&rc,&rcOwner);

    OffsetRect(&rcDlg,-rcDlg.left,-rcDlg.top);

    OffsetRect(&rc,-rc.left,-rc.top);

    OffsetRect(&rc,-rcDlg.right,-rcDlg.bottom);

    SetWindowPos(hwndDlg,

            HWND_TOP,

            rcOwner.left+(rc.right/2),

            rcOwner.top+(rc.bottom/2),

            0,0,SWP_NOSIZE);

    return TRUE;

  case WM_COMMAND:

    switch (LOWORD(wParam)) {

    case IDOK:

      len=SendDlgItemMessage(hwndDlg,200,WM_GETTEXTLENGTH,0,0);

      if ((inputbuf=memalloc(len+1))!=NULL) {
        GetDlgItemText(hwndDlg,200,inputbuf,len+1);
      }
    case IDCANCEL:

      EndDialog(hwndDlg,wParam);

      return TRUE;

    }

    return FALSE;

  default:

    return FALSE;

  }

}


LRESULT dlginputs(char *title,char *mes)

{

  int memsize,ctl,len,lenm;
  HGLOBAL hgbl;
  LPDLGTEMPLATE lpdt;

  LPDLGITEMTEMPLATE lpdit;

  LPWORD lpw;

  LPWSTR lpwsz;

  LRESULT ret;



  if (mes==NULL) mes="";

  memsize=sizeof(DLGTEMPLATE)+4+(strlen(title)+2)*2+1+(4+20*2);

  memsize+=(sizeof(DLGITEMTEMPLATE)+6+16)*3;

  lenm=strlen(mes);

  memsize+=(sizeof(DLGITEMTEMPLATE)+6+(lenm+2)*2);

  ctl=4;

  hgbl=GlobalAlloc(GMEM_ZEROINIT,memsize);

  if (!hgbl) return -1;

  lpdt=(LPDLGTEMPLATE)GlobalLock(hgbl);

  if (lenm<20) lenm=20;



  lpdt->style=WS_POPUP|WS_BORDER|WS_SYSMENU|DS_MODALFRAME|WS_CAPTION|DS_3DLOOK|DS_SETFONT;

  lpdt->cdit=ctl;

  lpdt->x=0;

  lpdt->y=0;

  lpdt->cx=12+lenm*6;

  lpdt->cy=60;

  lpw=(LPWORD)(lpdt+1);

  *lpw++=0;

  *lpw++=0;

  lpwsz=(LPWSTR)lpw;

  len=MultiByteToWideChar(CP_OEMCP,MB_COMPOSITE,title,-1,lpwsz,0);

  MultiByteToWideChar(CP_OEMCP,MB_COMPOSITE,title,-1,lpwsz,len);

  lpw=(LPWORD)(lpwsz+len);

  *lpw++=9;

  lpwsz=(LPWSTR)lpw;

#ifdef ENGLISH

  len=MultiByteToWideChar(CP_OEMCP,MB_COMPOSITE,"Arial",-1,lpwsz,0);

  MultiByteToWideChar(CP_OEMCP,MB_COMPOSITE,"Arial",-1,lpwsz,len);

#else

  len=MultiByteToWideChar(CP_OEMCP,MB_COMPOSITE,"lr oSVbN",-1,lpwsz,0);

  MultiByteToWideChar(CP_OEMCP,MB_COMPOSITE,"lr oSVbN",-1,lpwsz,len);

#endif */

  lpw=(LPWORD)(lpwsz+len);

  if (((int)lpw) % 4) lpw++;



  lpdit=(LPDLGITEMTEMPLATE)lpw;

  lpdit->x=6;

  lpdit->y=36;

  lpdit->cx=30;

  lpdit->cy=18;

  lpdit->id=IDOK;

  lpdit->style=WS_CHILD|WS_VISIBLE|BS_DEFPUSHBUTTON|WS_TABSTOP;

  lpw=(LPWORD)(lpdit + 1);

  *lpw++=0xFFFF;

  *lpw++=0x0080;

  lpwsz=(LPWSTR)lpw;

  len=MultiByteToWideChar(CP_OEMCP,MB_COMPOSITE,"OK",-1,lpwsz,0);

  MultiByteToWideChar(CP_OEMCP,MB_COMPOSITE,"OK",-1,lpwsz,len);

  lpw=(LPWORD)(lpwsz+len);

  *lpw++=0;

  if (((int)lpw) % 4) lpw++;



  lpdit=(LPDLGITEMTEMPLATE)lpw;

  lpdit->x=42;

  lpdit->y=36;

  lpdit->cx=30;

  lpdit->cy=18;

  lpdit->id=IDCANCEL;

  lpdit->style=WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON|WS_TABSTOP;

  lpw=(LPWORD)(lpdit+1);

  *lpw++=0xFFFF;

  *lpw++=0x0080;

  lpwsz=(LPWSTR)lpw;

  len=MultiByteToWideChar(CP_OEMCP,MB_COMPOSITE,"Cancel",-1,lpwsz,0);

  MultiByteToWideChar(CP_OEMCP,MB_COMPOSITE,"Cancel",-1,lpwsz,len);

  lpw=(LPWORD)(lpwsz+len);

  *lpw++=0;

  if (((int)lpw) % 4) lpw++;



  lpdit=(LPDLGITEMTEMPLATE)lpw;

  lpdit->x=6;

  lpdit->y=6;

  lpdit->cx=lenm*6;

  lpdit->cy=12;

  lpdit->style=WS_CHILD|WS_VISIBLE|WS_GROUP;

  lpw=(LPWORD)(lpdit+1);

  *lpw++=0xFFFF;

  *lpw++=0x0082;                        /* static class */

  lpwsz=(LPWSTR)lpw;

  len=MultiByteToWideChar(CP_OEMCP,MB_COMPOSITE,mes,-1,lpwsz,0);

  MultiByteToWideChar(CP_OEMCP,MB_COMPOSITE,mes,-1,lpwsz,len);

  lpw=(LPWORD)(lpwsz+len);

  *lpw++=0;                             /* no creation data */

  if (((int)lpw) % 4) lpw++;



  lpdit=(LPDLGITEMTEMPLATE)lpw;

  lpdit->x=6;

  lpdit->y=18;

  lpdit->cx=lenm*6;

  lpdit->cy=12;

  lpdit->id=200;

  lpdit->style=WS_CHILD|WS_VISIBLE|WS_BORDER|WS_TABSTOP|WS_GROUP

              |ES_AUTOHSCROLL;

  lpw=(LPWORD)(lpdit+1);

  *lpw++=0xFFFF;

  *lpw++=0x0081;

  *lpw++=0;

  *lpw++=0;                             /* no creation data */

  if (((int)lpw) % 4) lpw++;



  GlobalUnlock(hgbl);

  ret=DialogBoxIndirectParam(hInstance,(LPDLGTEMPLATE)hgbl,

      HWND_DESKTOP,(DLGPROC)dlgInputProc,NULL);

  GlobalFree(hgbl);

  return ret;

}


int dlgconfirm(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  char *mes;
  int rcode,locksave;

  mes=(char *)argv[2];
  locksave=globallock;
  globallock=TRUE;
  if (mes==NULL) mes="";
  rcode=MessageBox(NULL,mes,"Select",MB_YESNO|MB_ICONQUESTION);
  globallock=locksave;
  if (rcode==IDYES) *(int *)rval=1;
  else *(int *)rval=0;
  return (rcode==IDYES)?0:1;
}

int dlgmessage(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  char *mes;
  int rcode,locksave;

  mes=(char *)argv[2];
  locksave=globallock;
  globallock=TRUE;
  if (mes==NULL) mes="";
  rcode=MessageBox(NULL,mes,"Confirm",MB_OK|MB_ICONEXCLAMATION);
  globallock=locksave;
  return 0;
}

int dlginput(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  char *mes;
  int locksave;

  locksave=globallock;
  globallock=TRUE;
  mes=(char *)argv[2];
  memfree(*(char **)rval);
  *(char **)rval=NULL;
  inputbuf=NULL;
  if ((dlginputs("Input",mes)==IDOK) && (inputbuf!=NULL)) {
    *(char **)rval=inputbuf;
  } else {
    memfree(inputbuf);
    globallock=locksave;
    return 1;
  }
  globallock=locksave;
  return 0;
}

int dlgbeep(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  int locksave;

  locksave=globallock;
  globallock=TRUE;
  MessageBeep(MB_ICONEXCLAMATION);
  globallock=locksave;
  return 0;
}

char openfilebuf[1024];

int dlggetopenfile(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  struct narray *array;
  char **data;
  int anum,len,filteridx;
  char *filter,*s;
  int locksave;
  int i,ret;
  OPENFILENAME ofn;



  locksave=globallock;
  globallock=TRUE;
  memfree(*(char **)rval);
  *(char **)rval=NULL;
  array=(struct narray *)argv[2];
  data=arraydata(array);
  anum=arraynum(array)/2;
  len=0;
  for (i=0;i<anum;i++) {
    if (data[2*i]!=NULL) len+=strlen(data[2*i])+1;
    if (data[2*i+1]!=NULL) len+=strlen(data[2*i+1])+1;
  }
  len++;
  if ((filter=memalloc(len))==NULL) filteridx=0;
  else {
    filteridx=1;
    s=filter;
    for (i=0;i<anum;i++) {
      if (data[2*i]!=NULL) {
        strcpy(s,data[2*i]);
        s+=strlen(data[2*i])+1;
      }
      if (data[2*i+1]!=NULL) {
        strcpy(s,data[2*i+1]);
        s+=strlen(data[2*i+1])+1;
      }
    }
    s[0]='\0';
  }
  openfilebuf[0]='\0';
  ofn.lStructSize=sizeof(OPENFILENAME);
  ofn.hwndOwner=NULL;

  ofn.hInstance=hInstance;

  ofn.lpstrFilter=filter;

  ofn.nFilterIndex=filteridx;

  ofn.lpstrCustomFilter=NULL;

  ofn.nMaxCustFilter=0L;

  ofn.lpstrFile=openfilebuf;

  ofn.nMaxFile=1024;

  ofn.lpstrFileTitle=NULL;

  ofn.nMaxFileTitle=0L;

  ofn.lpstrInitialDir=NULL;

  ofn.lpstrTitle=NULL;

  ofn.Flags=OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_LONGNAMES |OFN_NOCHANGEDIR

           |OFN_FILEMUSTEXIST| OFN_EXPLORER;

  ofn.nFileOffset=0;

  ofn.nFileExtension=0;

  ofn.lpstrDefExt=NULL;

  ofn.lCustData=0;

  ofn.lpfnHook=NULL;

  ofn.lpTemplateName=NULL;

  ret=GetOpenFileName(&ofn);

  memfree(filter);

  if (ret==IDOK) {

    changefilename(openfilebuf);

    if ((*(char **)rval=memalloc(strlen(openfilebuf)+1))!=NULL) {

      strcpy(*(char **)rval,openfilebuf);

      globallock=locksave;

      return 0;

    }

  }

  globallock=locksave;

  return 1;

}


int dlggetopenfiles(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  struct narray *array;
  char **data;
  int anum,len,filteridx;
  char *filter,*s;
  int locksave;
  int i,ret;
  OPENFILENAME ofn;

  char *s2,*dir,*name;

  int dirlen;

  struct narray *farray;



  locksave=globallock;
  globallock=TRUE;
  arrayfree2(*(struct narray **)rval);
  *(char **)rval=NULL;
  array=(struct narray *)argv[2];
  data=arraydata(array);
  anum=arraynum(array)/2;
  len=0;
  for (i=0;i<anum;i++) {
    if (data[2*i]!=NULL) len+=strlen(data[2*i])+1;
    if (data[2*i+1]!=NULL) len+=strlen(data[2*i+1])+1;
  }
  len++;
  if ((filter=memalloc(len))==NULL) filteridx=0;
  else {
    filteridx=1;
    s=filter;
    for (i=0;i<anum;i++) {
      if (data[2*i]!=NULL) {
        strcpy(s,data[2*i]);
        s+=strlen(data[2*i])+1;
      }
      if (data[2*i+1]!=NULL) {
        strcpy(s,data[2*i+1]);
        s+=strlen(data[2*i+1])+1;
      }
    }
    s[0]='\0';
  }
  openfilebuf[0]='\0';
  ofn.lStructSize=sizeof(OPENFILENAME);
  ofn.hwndOwner=NULL;

  ofn.hInstance=hInstance;

  ofn.lpstrFilter=filter;

  ofn.nFilterIndex=filteridx;

  ofn.lpstrCustomFilter=NULL;

  ofn.nMaxCustFilter=0L;

  ofn.lpstrFile=openfilebuf;

  ofn.nMaxFile=1024;

  ofn.lpstrFileTitle=NULL;

  ofn.nMaxFileTitle=0L;

  ofn.lpstrInitialDir=NULL;

  ofn.lpstrTitle=NULL;

  ofn.Flags=OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_LONGNAMES |OFN_NOCHANGEDIR

           |OFN_FILEMUSTEXIST| OFN_ALLOWMULTISELECT | OFN_EXPLORER;

  ofn.nFileOffset=0;

  ofn.nFileExtension=0;

  ofn.lpstrDefExt=NULL;

  ofn.lCustData=0;

  ofn.lpfnHook=NULL;

  ofn.lpTemplateName=NULL;

  ret=GetOpenFileName(&ofn);

  memfree(filter);

  if (ret==IDOK) {

    farray=arraynew(sizeof(char *));

    s2=openfilebuf;

    dir=s2;
    dirlen=strlen(dir);
    s2=s2+strlen(s2)+1;
    if (s2[0]=='\0') {
      if ((name=(char *)memalloc(dirlen+1))!=NULL) {
        strcpy(name,dir);
        changefilename(name);
        arrayadd(farray,&name);
      }
    } else {

      while (s2[0]!='\0') {
        len=strlen(s2);
        if ((name=(char *)memalloc(dirlen+len+2))!=NULL) {
          strcpy(name,dir);
          if ((dirlen!=0) && (name[dirlen-1]!='\\')) {
            name[dirlen]='\\';
            name[dirlen+1]='\0';
          }
          strcat(name,s2);
          changefilename(name);
          arrayadd(farray,&name);
        }
        s2+=strlen(s2)+1;
      }
    }
    *(struct narray **)rval=farray;

    globallock=locksave;

    return 0;

  }

  globallock=locksave;

  return 1;

}


int dlggetsavefile(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  struct narray *array;
  char **data;
  int anum,len,filteridx;
  char *filter,*s;
  int locksave;
  int i,ret;
  OPENFILENAME ofn;



  locksave=globallock;
  globallock=TRUE;
  memfree(*(char **)rval);
  *(char **)rval=NULL;
  array=(struct narray *)argv[2];
  data=arraydata(array);
  anum=arraynum(array)/2;
  len=0;
  for (i=0;i<anum;i++) {
    if (data[2*i]!=NULL) len+=strlen(data[2*i])+1;
    if (data[2*i+1]!=NULL) len+=strlen(data[2*i+1])+1;
  }
  len++;
  if ((filter=memalloc(len))==NULL) filteridx=0;
  else {
    filteridx=1;
    s=filter;
    for (i=0;i<anum;i++) {
      if (data[2*i]!=NULL) {
        strcpy(s,data[2*i]);
        s+=strlen(data[2*i])+1;
      }
      if (data[2*i+1]!=NULL) {
        strcpy(s,data[2*i+1]);
        s+=strlen(data[2*i+1])+1;
      }
    }
    s[0]='\0';
  }
  openfilebuf[0]='\0';
  ofn.lStructSize=sizeof(OPENFILENAME);
  ofn.hwndOwner=NULL;

  ofn.hInstance=hInstance;

  ofn.lpstrFilter=filter;

  ofn.nFilterIndex=filteridx;

  ofn.lpstrCustomFilter=NULL;

  ofn.nMaxCustFilter=0L;

  ofn.lpstrFile=openfilebuf;

  ofn.nMaxFile=1024;

  ofn.lpstrFileTitle=NULL;

  ofn.nMaxFileTitle=0L;

  ofn.lpstrInitialDir=NULL;

  ofn.lpstrTitle=NULL;

  ofn.Flags=OFN_HIDEREADONLY | OFN_LONGNAMES |OFN_NOCHANGEDIR

           |OFN_EXPLORER|OFN_OVERWRITEPROMPT;

  ofn.nFileOffset=0;

  ofn.nFileExtension=0;

  ofn.lpstrDefExt=NULL;

  ofn.lCustData=0;

  ofn.lpfnHook=NULL;

  ofn.lpTemplateName=NULL;

  ret=GetSaveFileName(&ofn);

  memfree(filter);

  if (ret==IDOK) {

    changefilename(openfilebuf);

    if ((*(char **)rval=memalloc(strlen(openfilebuf)+1))!=NULL) {

      strcpy(*(char **)rval,openfilebuf);

      globallock=locksave;

      return 0;

    }

  }

  globallock=locksave;

  return 1;

}



#define TBLNUM 10

struct objtable dialog[TBLNUM] = {
  {"init",NVFUNC,NEXEC,dlginit,NULL,0},
  {"done",NVFUNC,NEXEC,dlgdone,NULL,0},
  {"next",NPOINTER,0,NULL,NULL,0},
  {"yesno",NIFUNC,NREAD|NEXEC,dlgconfirm,"s",0},
  {"message",NVFUNC,NREAD|NEXEC,dlgmessage,"s",0},
  {"input",NSFUNC,NREAD|NEXEC,dlginput,"s",0},
  {"beep",NVFUNC,NREAD|NEXEC,dlgbeep,NULL,0},
  {"get_open_file",NSFUNC,NREAD|NEXEC,dlggetopenfile,"sa",0},
  {"get_open_files",NSAFUNC,NREAD|NEXEC,dlggetopenfiles,"sa",0},
  {"get_save_file",NSFUNC,NREAD|NEXEC,dlggetsavefile,"sa",0},
};

void *adddialog()
{
  return addobject(NAME,NULL,PARENT,VERSION,TBLNUM,dialog,ERRNUM,dlgerrorlist,NULL,NULL);
}

