/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 * owinmenu.cpp
 *
 */

#include <owl\pch.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <math.h>
#include <time.h>

extern "C" {
#include "ngraph.h"
#include "object.h"
#include "ioutil.h"
#include "shell.h"
#include "nstring.h"
#include "config.h"
#include "mathfn.h"
#include "gra.h"
#include "spline.h"
#include "owinmenu.h"
}

#include "winmenu.h"

#define NAME "menu"
#define ALIAS "winmenu:x11menu"
#define PARENT "gra2"
#define VERSION  "1.00.00"
#define MWINCONF "[winmenu]"
#define G2WINCONF "[gra2win]"
#define TRUE  1
#define FALSE 0
#define LINETOLIMIT 500

#define ERRRUN 100

#define ERRNUM 1

#define ANSI2_CHARSET -1

char *menuerrorlist[ERRNUM]={
  "already running.",
};

struct menulocal menulocal;
struct mwlocal *mwlocal;
struct savedstdio winiosave;

extern "C" int mwinloadconfig()
{
  FILE *fp;
  char *tok,*str,*s2;
  char *f1,*f2,*f3,*f4,*f5;
  int val;
  char *endptr;
  int len,i;
  struct fontmap *fcur,*fnew;
  struct extprinter *pcur,*pnew;
  struct script *scur,*snew;

  if ((fp=openconfig(MWINCONF))==NULL) return 0;
  fcur=mwlocal->fontmaproot;
  pcur=menulocal.extprinterroot;
  scur=menulocal.scriptroot;
  while ((tok=getconfig(fp,&str))!=NULL) {
    s2=str;
    if (strcmp(tok,"window_font")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      for (;(s2[0]!='\0') && (strchr(" \x09,",s2[0])!=NULL);s2++);
      f2=getitok2(&s2,&len,"");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL)) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') {
          memfree(menulocal.fontname);
          menulocal.fontname=f2;
          menulocal.fontsize=val;
          if (strcmp(f4,"roman")==0) menulocal.fontitalic=FONT_ROMAN;
          else if (strcmp(f4,"italic")==0) menulocal.fontitalic=FONT_ITALIC;
          else if (strcmp(f4,"bold")==0) menulocal.fontitalic=FONT_BOLD;
          else if (strcmp(f4,"bold_italic")==0) menulocal.fontitalic=FONT_BOLDITALIC;
          else menulocal.fontitalic=FONT_UNKNOWN;
          if (strcmp(f3,"shiftjis")==0) menulocal.fontcharset=SHIFTJIS_CHARSET;
          else if (strcmp(f3,"symbol")==0) menulocal.fontcharset=SYMBOL_CHARSET;
          else if (strcmp(f3,"ansi")==0) menulocal.fontcharset=ANSI_CHARSET;
          else if (strcmp(f3,"oem")==0) menulocal.fontcharset=OEM_CHARSET;
          else if (strcmp(f3,"hangeul")==0) menulocal.fontcharset=HANGEUL_CHARSET;
          else if (strcmp(f3,"chinesebig5")==0) menulocal.fontcharset=CHINESEBIG5_CHARSET;
          else menulocal.fontcharset=DEFAULT_CHARSET;
        } else memfree(f2);
      } else memfree(f2);
      memfree(f1);
      memfree(f3);
      memfree(f4);
    } else if (strcmp(tok,"script_console")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.scriptconsole=val;
      }
      memfree(f1);
    } else if (strcmp(tok,"addin_console")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.addinconsole=val;
      }
      memfree(f1);
    } else if (strcmp(tok,"save_path")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.savepath=val;
      }
      memfree(f1);
    } else if (strcmp(tok,"save_with_data")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.savewithdata=val;
      }
      memfree(f1);
    } else if (strcmp(tok,"save_with_merge")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.savewithmerge=val;
      }
      memfree(f1);
    } else if (strcmp(tok,"change_directory")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.changedirectory=val;
      }
      memfree(f1);
    } else if (strcmp(tok,"save_history")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.savehistory=val;
      }
      memfree(f1);
    } else if (strcmp(tok,"expand_dir")==0) {
      f1=getitok2(&s2,&len,"");
      if (f1!=NULL) {
        memfree(menulocal.expanddir);
        menulocal.expanddir=f1;
      }
    } else if (strcmp(tok,"expand")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.expand=val;
      }
      memfree(f1);
    } else if (strcmp(tok,"ignore_path")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.ignorepath=val;
      }
      memfree(f1);
    } else if (strcmp(tok,"expand_to_fullpath")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.expandtofullpath=val;
      }
      memfree(f1);
    } else if (strcmp(tok,"ngp_history")==0) {
      for (;(s2[0]!='\0') && (strchr(" \x09,",s2[0])!=NULL);s2++);
      f1=getitok2(&s2,&len,"");
      if (f1!=NULL) arrayadd(menulocal.ngpfilelist,&f1);
    } else if (strcmp(tok,"ngp_dir_history")==0) {
      for (;(s2[0]!='\0') && (strchr(" \x09,",s2[0])!=NULL);s2++);
      f1=getitok2(&s2,&len,"");
      if (f1!=NULL) arrayadd(menulocal.ngpdirlist,&f1);
    } else if (strcmp(tok,"data_history")==0) {
      for (;(s2[0]!='\0') && (strchr(" \x09,",s2[0])!=NULL);s2++);
      f1=getitok2(&s2,&len,"");
      if (f1!=NULL) arrayadd(menulocal.datafilelist,&f1);
    } else if (strcmp(tok,"status_bar")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.statusb=val;
      }
      memfree(f1);
    } else if (strcmp(tok,"tool_bar1")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if ((endptr[0]=='\0') && (val!=0)) menulocal.controlb1f=val;
      }
      memfree(f1);
    } else if (strcmp(tok,"tool_bar2")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if ((endptr[0]=='\0') && (val!=0)) menulocal.controlb2f=val;
      }
      memfree(f1);
    } else if (strcmp(tok,"menu_win")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f2=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL)) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.menux=val;
        val=strtol(f2,&endptr,10);
        if (endptr[0]=='\0') menulocal.menuy=val;
        val=strtol(f3,&endptr,10);
        if (endptr[0]=='\0') menulocal.menuwidth=val;
        val=strtol(f4,&endptr,10);
        if (endptr[0]=='\0') menulocal.menuheight=val;
      }
      memfree(f1);
      memfree(f2);
      memfree(f3);
      memfree(f4);
    } else if (strcmp(tok,"file_win")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f2=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      f5=getitok2(&s2,&len," \x09,");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL) && (f5!=NULL)) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.filex=val;
        val=strtol(f2,&endptr,10);
        if (endptr[0]=='\0') menulocal.filey=val;
        val=strtol(f3,&endptr,10);
        if (endptr[0]=='\0') menulocal.filewidth=val;
        val=strtol(f4,&endptr,10);
        if (endptr[0]=='\0') menulocal.fileheight=val;
        val=strtol(f5,&endptr,10);
        if (endptr[0]=='\0') menulocal.fileopen=val;
      }
      memfree(f1);
      memfree(f2);
      memfree(f3);
      memfree(f4);
      memfree(f5);
    } else if (strcmp(tok,"axis_win")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f2=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      f5=getitok2(&s2,&len," \x09,");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL) && (f5!=NULL)) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.axisx=val;
        val=strtol(f2,&endptr,10);
        if (endptr[0]=='\0') menulocal.axisy=val;
        val=strtol(f3,&endptr,10);
        if (endptr[0]=='\0') menulocal.axiswidth=val;
        val=strtol(f4,&endptr,10);
        if (endptr[0]=='\0') menulocal.axisheight=val;
        val=strtol(f5,&endptr,10);
        if (endptr[0]=='\0') menulocal.axisopen=val;
      }
      memfree(f1);
      memfree(f2);
      memfree(f3);
      memfree(f4);
      memfree(f5);
    } else if (strcmp(tok,"legend_win")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f2=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      f5=getitok2(&s2,&len," \x09,");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL) && (f5!=NULL)) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.legendx=val;
        val=strtol(f2,&endptr,10);
        if (endptr[0]=='\0') menulocal.legendy=val;
        val=strtol(f3,&endptr,10);
        if (endptr[0]=='\0') menulocal.legendwidth=val;
        val=strtol(f4,&endptr,10);
        if (endptr[0]=='\0') menulocal.legendheight=val;
        val=strtol(f5,&endptr,10);
        if (endptr[0]=='\0') menulocal.legendopen=val;
      }
      memfree(f1);
      memfree(f2);
      memfree(f3);
      memfree(f4);
      memfree(f5);
    } else if (strcmp(tok,"merge_win")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f2=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      f5=getitok2(&s2,&len," \x09,");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL) && (f5!=NULL)) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.mergex=val;
        val=strtol(f2,&endptr,10);
        if (endptr[0]=='\0') menulocal.mergey=val;
        val=strtol(f3,&endptr,10);
        if (endptr[0]=='\0') menulocal.mergewidth=val;
        val=strtol(f4,&endptr,10);
        if (endptr[0]=='\0') menulocal.mergeheight=val;
        val=strtol(f5,&endptr,10);
        if (endptr[0]=='\0') menulocal.mergeopen=val;
      }
      memfree(f1);
      memfree(f2);
      memfree(f3);
      memfree(f4);
      memfree(f5);
    } else if (strcmp(tok,"information_win")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f2=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      f5=getitok2(&s2,&len," \x09,");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL) && (f5!=NULL)) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.dialogx=val;
        val=strtol(f2,&endptr,10);
        if (endptr[0]=='\0') menulocal.dialogy=val;
        val=strtol(f3,&endptr,10);
        if (endptr[0]=='\0') menulocal.dialogwidth=val;
        val=strtol(f4,&endptr,10);
        if (endptr[0]=='\0') menulocal.dialogheight=val;
        val=strtol(f5,&endptr,10);
        if (endptr[0]=='\0') menulocal.dialogopen=val;
      }
      memfree(f1);
      memfree(f2);
      memfree(f3);
      memfree(f4);
      memfree(f5);
    } else if (strcmp(tok,"coordinate_win")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f2=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      f5=getitok2(&s2,&len," \x09,");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL) && (f5!=NULL)) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.coordx=val;
        val=strtol(f2,&endptr,10);
        if (endptr[0]=='\0') menulocal.coordy=val;
        val=strtol(f3,&endptr,10);
        if (endptr[0]=='\0') menulocal.coordwidth=val;
        val=strtol(f4,&endptr,10);
        if (endptr[0]=='\0') menulocal.coordheight=val;
        val=strtol(f5,&endptr,10);
        if (endptr[0]=='\0') menulocal.coordopen=val;
      }
      memfree(f1);
      memfree(f2);
      memfree(f3);
      memfree(f4);
      memfree(f5);
    } else if (strcmp(tok,"move_child_window")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.movechild=val;
      }
      memfree(f1);
    } else if (strcmp(tok,"editor")==0) {
      memfree(menulocal.editor);
      f1=getitok2(&s2,&len,"");
      menulocal.editor=f1;
    } else if (strcmp(tok,"ext_driver")==0) {
      f1=getitok2(&s2,&len,",");
      f2=getitok2(&s2,&len,",");
      if (s2[1]==',') f3=NULL;
      else f3=getitok2(&s2,&len,",");
      for (;(s2[0]!='\0') && (strchr(" \x09,",s2[0])!=NULL);s2++);
      f4=getitok2(&s2,&len,"");
      if ((f1!=NULL) && (f2!=NULL)) {
        if ((pnew=(struct extprinter *)memalloc(sizeof(struct extprinter)))==NULL) {
          memfree(tok);
          memfree(f1);
          memfree(f2);
          memfree(f3);
          memfree(f4);
          closeconfig(fp);
          return 1;
        }
        if (pcur==NULL) menulocal.extprinterroot=pnew;
        else pcur->next=pnew;
        pcur=pnew;
        pcur->next=NULL;
        pcur->name=f1;
        pcur->driver=f2;
        pcur->ext=f3;
        pcur->option=f4;
      } else {
        memfree(f1);
        memfree(f2);
        memfree(f3);
        memfree(f4);
      }
    } else if (strcmp(tok,"script")==0) {
      f1=getitok2(&s2,&len,",");
      f2=getitok2(&s2,&len,",");
      for (;(s2[0]!='\0') && (strchr(" \x09,",s2[0])!=NULL);s2++);
      f3=getitok2(&s2,&len,"");
      if ((f1!=NULL) && (f2!=NULL)) {
        if ((snew=(struct script *)memalloc(sizeof(struct script)))==NULL) {
          memfree(tok);
          memfree(f1);
          memfree(f2);
          memfree(f3);
          closeconfig(fp);
          return 1;
        }
        if (scur==NULL) menulocal.scriptroot=snew;
        else scur->next=snew;
        scur=snew;
        scur->next=NULL;
        scur->name=f1;
        scur->script=f2;
        scur->option=f3;
      } else {
        memfree(f1);
        memfree(f2);
        memfree(f3);
      }
    } else if (strcmp(tok,"custom_color")==0) {
      for (i=0;i<16;i++) {
        f1=getitok2(&s2,&len," \x09,");
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.customcolor[i]=val;
        memfree(f1);
      }
    } else if (strcmp(tok,"clipboard_emf")==0) {
      f1=getitok2(&s2,&len," \x09,");
      val=strtol(f1,&endptr,10);
      if (endptr[0]=='\0') menulocal.clipboardEMF=val;
      memfree(f1);
    } else if (strcmp(tok,"clipboard_dpi")==0) {
      f1=getitok2(&s2,&len," \x09,");
      val=strtol(f1,&endptr,10);
      if (endptr[0]=='\0') menulocal.clipboardDPI=val;
      memfree(f1);
    } else if (strcmp(tok,"font_map")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      for (;(s2[0]!='\0') && (strchr(" \x09,",s2[0])!=NULL);s2++);
      f2=getitok2(&s2,&len,"");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL)) {
        if ((fnew=(struct fontmap *)memalloc(sizeof(struct fontmap)))==NULL) {
          memfree(tok);
          memfree(f1);
          memfree(f2);
          memfree(f3);
          memfree(f4);
          closeconfig(fp);
          return 1;
        }
        if (fcur==NULL) mwlocal->fontmaproot=fnew;
        else fcur->next=fnew;
        fcur=fnew;
        fcur->next=NULL;
        fcur->fontalias=f1;
        fcur->fontname=f2;
        if (strcmp(f4,"roman")==0) fcur->italic=FONT_ROMAN;
        else if (strcmp(f4,"italic")==0) fcur->italic=FONT_ITALIC;
        else if (strcmp(f4,"bold")==0) fcur->italic=FONT_BOLD;
        else if (strcmp(f4,"bold_italic")==0) fcur->italic=FONT_BOLDITALIC;
        else fcur->italic=FONT_UNKNOWN;
        if (strcmp(f3,"shiftjis")==0) fcur->charset=SHIFTJIS_CHARSET;
        else if (strcmp(f3,"symbol")==0) fcur->charset=SYMBOL_CHARSET;
        else if (strcmp(f3,"ansi")==0) fcur->charset=ANSI_CHARSET;
        else if (strcmp(f3,"ansi2")==0) fcur->charset=ANSI2_CHARSET;
        else if (strcmp(f3,"oem")==0) fcur->charset=OEM_CHARSET;
        else if (strcmp(f3,"hangeul")==0) fcur->charset=HANGEUL_CHARSET;
        else if (strcmp(f3,"chinesebig5")==0) fcur->charset=CHINESEBIG5_CHARSET;
        else fcur->charset=DEFAULT_CHARSET;
        memfree(f3);
        memfree(f4);
      } else {
        memfree(f1);
        memfree(f2);
        memfree(f3);
        memfree(f4);
      }
    } else if (strcmp(tok,"viewer_dpi")==0) {
      f1=getitok2(&s2,&len," \x09,");
      val=strtol(f1,&endptr,10);
      if (endptr[0]=='\0') mwlocal->windpi=val;
      memfree(f1);
    } else if (strcmp(tok,"viewer_auto_redraw")==0) {
      f1=getitok2(&s2,&len," \x09,");
      val=strtol(f1,&endptr,10);
      if (endptr[0]=='\0') {
        if (val==0) mwlocal->autoredraw=FALSE;
        else mwlocal->autoredraw=TRUE;
      }
      memfree(f1);
    } else if (strcmp(tok,"viewer_load_file_on_redraw")==0) {
      f1=getitok2(&s2,&len," \x09,");
      val=strtol(f1,&endptr,10);
      if (endptr[0]=='\0') {
        if (val==0) mwlocal->redrawf=FALSE;
        else mwlocal->redrawf=TRUE;
      }
      memfree(f1);
    } else if (strcmp(tok,"viewer_show_ruler")==0) {
      f1=getitok2(&s2,&len," \x09,");
      val=strtol(f1,&endptr,10);
      if (endptr[0]=='\0') {
        if (val==0) mwlocal->ruler=FALSE;
        else mwlocal->ruler=TRUE;
      }
      memfree(f1);
    } else if (strcmp(tok,"viewer_grid")==0) {
      f1=getitok2(&s2,&len," \x09,");
      val=strtol(f1,&endptr,10);
      if (endptr[0]=='\0') mwlocal->grid=val;
      memfree(f1);
    } else if (strcmp(tok,"backgroundR")==0) {
      f1=getitok2(&s2,&len," \x09,");
      val=strtol(f1,&endptr,10);
      if (endptr[0]=='\0') mwlocal->bgR=val;
      memfree(f1);
    } else if (strcmp(tok,"backgroundG")==0) {
      f1=getitok2(&s2,&len," \x09,");
      val=strtol(f1,&endptr,10);
      if (endptr[0]=='\0') mwlocal->bgG=val;
      memfree(f1);
    } else if (strcmp(tok,"backgroundB")==0) {
      f1=getitok2(&s2,&len," \x09,");
      val=strtol(f1,&endptr,10);
      if (endptr[0]=='\0') mwlocal->bgB=val;
      memfree(f1);
    } else if (strcmp(tok,"minus_hyphen")==0) {
      f1=getitok2(&s2,&len," \x09,");
      if (f1!=NULL) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') mwlocal->minus_hyphen=val;
      }
      memfree(f1);
    }
    memfree(tok);
    memfree(str);
  }
  closeconfig(fp);
  return 0;
}

extern "C" void initwindowconfig()
{
  menulocal.fileopen=menulocal.axisopen=menulocal.legendopen=menulocal.mergeopen
                    =menulocal.dialogopen=menulocal.coordopen=FALSE;
  menulocal.filex=menulocal.filey=menulocal.fileheight=menulocal.filewidth=CW_USEDEFAULT;
  menulocal.axisx=menulocal.axisy=menulocal.axisheight=menulocal.axiswidth=CW_USEDEFAULT;
  menulocal.legendx=menulocal.legendy=menulocal.legendheight=menulocal.legendwidth=CW_USEDEFAULT;
  menulocal.mergex=menulocal.mergey=menulocal.mergeheight=menulocal.mergewidth=CW_USEDEFAULT;
  menulocal.dialogx=menulocal.dialogy=menulocal.dialogheight=menulocal.dialogwidth=CW_USEDEFAULT;
  menulocal.coordx=menulocal.coordy=menulocal.coordheight=menulocal.coordwidth=CW_USEDEFAULT;
}

extern "C" int mwinwindowconfig()
{
  FILE *fp;
  char *tok,*str,*s2;
  char *f1,*f2,*f3,*f4,*f5;
  int val;
  char *endptr;
  int len;

  if ((fp=openconfig(MWINCONF))==NULL) return 0;
  while ((tok=getconfig(fp,&str))!=NULL) {
    s2=str;
    if (strcmp(tok,"file_win")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f2=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      f5=getitok2(&s2,&len," \x09,");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL) && (f5!=NULL)) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.filex=val;
        val=strtol(f2,&endptr,10);
        if (endptr[0]=='\0') menulocal.filey=val;
        val=strtol(f3,&endptr,10);
        if (endptr[0]=='\0') menulocal.filewidth=val;
        val=strtol(f4,&endptr,10);
        if (endptr[0]=='\0') menulocal.fileheight=val;
        val=strtol(f5,&endptr,10);
        if (endptr[0]=='\0') menulocal.fileopen=val;
      }
      memfree(f1);
      memfree(f2);
      memfree(f3);
      memfree(f4);
      memfree(f5);
    } else if (strcmp(tok,"axis_win")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f2=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      f5=getitok2(&s2,&len," \x09,");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL) && (f5!=NULL)) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.axisx=val;
        val=strtol(f2,&endptr,10);
        if (endptr[0]=='\0') menulocal.axisy=val;
        val=strtol(f3,&endptr,10);
        if (endptr[0]=='\0') menulocal.axiswidth=val;
        val=strtol(f4,&endptr,10);
        if (endptr[0]=='\0') menulocal.axisheight=val;
        val=strtol(f5,&endptr,10);
        if (endptr[0]=='\0') menulocal.axisopen=val;
      }
      memfree(f1);
      memfree(f2);
      memfree(f3);
      memfree(f4);
      memfree(f5);
    } else if (strcmp(tok,"legend_win")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f2=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      f5=getitok2(&s2,&len," \x09,");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL) && (f5!=NULL)) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.legendx=val;
        val=strtol(f2,&endptr,10);
        if (endptr[0]=='\0') menulocal.legendy=val;
        val=strtol(f3,&endptr,10);
        if (endptr[0]=='\0') menulocal.legendwidth=val;
        val=strtol(f4,&endptr,10);
        if (endptr[0]=='\0') menulocal.legendheight=val;
        val=strtol(f5,&endptr,10);
        if (endptr[0]=='\0') menulocal.legendopen=val;
      }
      memfree(f1);
      memfree(f2);
      memfree(f3);
      memfree(f4);
      memfree(f5);
    } else if (strcmp(tok,"merge_win")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f2=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      f5=getitok2(&s2,&len," \x09,");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL) && (f5!=NULL)) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.mergex=val;
        val=strtol(f2,&endptr,10);
        if (endptr[0]=='\0') menulocal.mergey=val;
        val=strtol(f3,&endptr,10);
        if (endptr[0]=='\0') menulocal.mergewidth=val;
        val=strtol(f4,&endptr,10);
        if (endptr[0]=='\0') menulocal.mergeheight=val;
        val=strtol(f5,&endptr,10);
        if (endptr[0]=='\0') menulocal.mergeopen=val;
      }
      memfree(f1);
      memfree(f2);
      memfree(f3);
      memfree(f4);
      memfree(f5);
    } else if (strcmp(tok,"information_win")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f2=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      f5=getitok2(&s2,&len," \x09,");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL) && (f5!=NULL)) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.dialogx=val;
        val=strtol(f2,&endptr,10);
        if (endptr[0]=='\0') menulocal.dialogy=val;
        val=strtol(f3,&endptr,10);
        if (endptr[0]=='\0') menulocal.dialogwidth=val;
        val=strtol(f4,&endptr,10);
        if (endptr[0]=='\0') menulocal.dialogheight=val;
        val=strtol(f5,&endptr,10);
        if (endptr[0]=='\0') menulocal.dialogopen=val;
      }
      memfree(f1);
      memfree(f2);
      memfree(f3);
      memfree(f4);
      memfree(f5);
    } else if (strcmp(tok,"coordinate_win")==0) {
      f1=getitok2(&s2,&len," \x09,");
      f2=getitok2(&s2,&len," \x09,");
      f3=getitok2(&s2,&len," \x09,");
      f4=getitok2(&s2,&len," \x09,");
      f5=getitok2(&s2,&len," \x09,");
      if ((f1!=NULL) && (f2!=NULL) && (f3!=NULL) && (f4!=NULL) && (f5!=NULL)) {
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') menulocal.coordx=val;
        val=strtol(f2,&endptr,10);
        if (endptr[0]=='\0') menulocal.coordy=val;
        val=strtol(f3,&endptr,10);
        if (endptr[0]=='\0') menulocal.coordwidth=val;
        val=strtol(f4,&endptr,10);
        if (endptr[0]=='\0') menulocal.coordheight=val;
        val=strtol(f5,&endptr,10);
        if (endptr[0]=='\0') menulocal.coordopen=val;
      }
      memfree(f1);
      memfree(f2);
      memfree(f3);
      memfree(f4);
      memfree(f5);
    }
    memfree(tok);
    memfree(str);
  }
  closeconfig(fp);
  return 0;
}

extern "C" int exwinloadconfig()
{
  FILE *fp;
  char *tok,*str,*s2;
  char *f1;
  int val;
  char *endptr;
  int len;

  if ((fp=openconfig(G2WINCONF))==NULL) return 0;
  while ((tok=getconfig(fp,&str))!=NULL) {
    s2=str;
    if (strcmp(tok,"win_dpi")==0) {
      f1=getitok2(&s2,&len," \x09,");
      val=strtol(f1,&endptr,10);
      if (endptr[0]=='\0') menulocal.exwindpi=val;
      memfree(f1);
    } else if (strcmp(tok,"win_width")==0) {
      f1=getitok2(&s2,&len," \x09,");
      val=strtol(f1,&endptr,10);
      if (endptr[0]=='\0') menulocal.exwinwidth=val;
      memfree(f1);
    } else if (strcmp(tok,"win_height")==0) {
      f1=getitok2(&s2,&len," \x09,");
      val=strtol(f1,&endptr,10);
      if (endptr[0]=='\0') menulocal.exwinheight=val;
      memfree(f1);
	} else if (strcmp(tok,"store_in_memory")==0) {
      f1=getitok2(&s2,&len," \x09,");
      val=strtol(f1,&endptr,10);
      if (endptr[0]=='\0') {
        if (val==0) menulocal.exwinmemory=FALSE;
        else menulocal.exwinmemory=TRUE;
	  }
      memfree(f1);
    }
    memfree(tok);
    memfree(str);
  }
  closeconfig(fp);
  return 0;
}

extern "C" void menuadddrawrable(struct objlist *parent,struct narray *drawrable)
{
  struct objlist *ocur;
  char *name;

  ocur=chkobjroot();
  while (ocur!=NULL) {
    if (chkobjparent(ocur)==parent) {
      if ((chkobjperm(ocur,"init") & NEXEC)!=0) {
        name=chkobjectname(ocur);
        arrayadd2(drawrable,&name);
      }
      menuadddrawrable(ocur,drawrable);
    }
    ocur=ocur->next;
  }
}

extern "C" int menuinit(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  struct objlist *robj;
  struct fontmap *fcur,*fdel;
  struct extprinter *pcur,*pdel;
  struct script *scur,*sdel;
  int i,numf,numd;
  char *dum;

  if (_exeparent(obj,(char *)argv[1],inst,rval,argc,argv)) return 1;
  if ((mwlocal=(struct mwlocal *)memalloc(sizeof(struct mwlocal)))==NULL)
    return 1;
  menulocal.name=NULL;
  menulocal.id=NULL;
  menulocal.menufont=NULL;
  menulocal.fontname=NULL;
  menulocal.fontitalic=FONT_ROMAN;
  menulocal.fontsize=0;
  menulocal.menux=menulocal.menuy=menulocal.menuheight=menulocal.menuwidth=CW_USEDEFAULT;
  initwindowconfig();
  menulocal.controlb1f=menulocal.controlb2f=1;
  menulocal.statusb=1;
  menulocal.movechild=0;
  menulocal.scriptconsole=FALSE;
  menulocal.addinconsole=TRUE;
  menulocal.changedirectory=1;
  menulocal.editor=NULL;
  menulocal.PaperWidth=21000;
  menulocal.PaperHeight=29700;
  menulocal.LeftMargin=0;
  menulocal.TopMargin=0;
  menulocal.PaperZoom=10000;
  menulocal.exwindpi=70;
  menulocal.exwinwidth=0;
  menulocal.exwinheight=0;
  menulocal.exwinmemory=TRUE;
  menulocal.fileopendir=NULL;
  menulocal.graphloaddir=NULL;
  menulocal.expand=1;
  menulocal.expanddir=(char *)memalloc(3);
  strcpy(menulocal.expanddir,".\\");
  menulocal.ignorepath=0;
  menulocal.expandtofullpath=TRUE;
  menulocal.savepath=0;
  menulocal.savewithdata=0;
  menulocal.savewithmerge=0;
  menulocal.mathlist=arraynew(sizeof(char *));
  menulocal.ngpfilelist=arraynew(sizeof(char *));
  menulocal.ngpdirlist=arraynew(sizeof(char *));
  menulocal.datafilelist=arraynew(sizeof(char *));
  menulocal.extprinterroot=NULL;
  menulocal.scriptroot=NULL;
  menulocal.GRAobj=chkobject("gra");
  menulocal.clipboardEMF=TRUE;
  menulocal.clipboardDPI=576;
  for (i=0;i<16;i++) menulocal.customcolor[i]=RGB(255,255,255);
  arrayinit(&(menulocal.drawrable),sizeof(char *));
  menuadddrawrable(chkobject("draw"),&(menulocal.drawrable));
  mwlocal->fontmaproot=NULL;
  mwlocal->windpi=70;
  mwlocal->autoredraw=TRUE;
  mwlocal->redrawf=TRUE;
  mwlocal->ruler=TRUE;
  mwlocal->grid=200;
  mwlocal->bgR=GetSysColor(COLOR_WINDOW) & 255;
  mwlocal->bgG=(GetSysColor(COLOR_WINDOW) >> 8) & 255;
  mwlocal->bgB=(GetSysColor(COLOR_WINDOW) >> 16) & 255;
  mwlocal->minus_hyphen=TRUE;
  if (_putobj(obj,"_local",inst,mwlocal)) goto errexit;

  if (mwinloadconfig()) goto errexit;
  if (exwinloadconfig()) goto errexit;

  numf=arraynum(menulocal.ngpfilelist);
  numd=arraynum(menulocal.ngpdirlist);
  dum=NULL;
  if (numd>numf)
    for (i=numf;i<numd;i++) arrayndel2(menulocal.ngpdirlist,i);
  else if (numd<numf)
    for (i=numd;i<numf;i++) arrayadd(menulocal.ngpdirlist,&dum);
  if (menulocal.menuwidth<1) menulocal.menuwidth=CW_USEDEFAULT;
  if (menulocal.menuwidth>10000) menulocal.menuwidth=CW_USEDEFAULT;
  if (menulocal.menuheight<1) menulocal.menuheight=CW_USEDEFAULT;
  if (menulocal.menuheight>10000) menulocal.menuheight=CW_USEDEFAULT;
  if (menulocal.exwindpi<1) menulocal.exwindpi=70;
  if (menulocal.exwindpi>2540) menulocal.exwindpi=2540;
  if (menulocal.clipboardDPI<96) menulocal.clipboardDPI=96;
  if (menulocal.clipboardDPI>2540) menulocal.clipboardDPI=2540;
  if (mwlocal->windpi<1) mwlocal->windpi=70;
  if (mwlocal->windpi>2540) mwlocal->windpi=2540;
  if (_putobj(obj,"dpi",inst,&(mwlocal->windpi))) goto errexit;
  if (_putobj(obj,"auto_redraw",inst,&(mwlocal->autoredraw))) goto errexit;
  if (_putobj(obj,"redraw_flag",inst,&(mwlocal->redrawf))) goto errexit;
  if (!chkobjfield(obj,"_output")) {
    if ((menulocal.output=getobjtblpos(obj,"_output",&robj))==-1) goto errexit;
    menulocal.outputobj=robj;
  } else menulocal.output=-1;
  menulocal.obj=obj;
  menulocal.inst=inst;
  mwlocal->hWnd=NULL;
  mwlocal->DC=NULL;
  mwlocal->lock=0;
  return 0;

errexit:
  DeleteObject(menulocal.menufont);
  memfree(menulocal.editor);
  pcur=menulocal.extprinterroot;
  while (pcur!=NULL) {
    pdel=pcur;
    pcur=pcur->next;
    memfree(pdel->name);
    memfree(pdel->driver);
    memfree(pdel->ext);
    memfree(pdel->option);
    memfree(pdel);
  }
  scur=menulocal.scriptroot;
  while (scur!=NULL) {
    sdel=scur;
    scur=scur->next;
    memfree(sdel->name);
    memfree(sdel->script);
    memfree(sdel->option);
    memfree(sdel);
  }
  fcur=mwlocal->fontmaproot;
  while (fcur!=NULL) {
    fdel=fcur;
    fcur=fcur->next;
    memfree(fdel->fontalias);
    memfree(fdel->fontname);
    memfree(fdel);
  }
  memfree(mwlocal);
  return 1;
}

extern "C" int menudone(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  struct fontmap *fcur,*fdel;
  struct extprinter *pcur,*pdel;
  struct script *scur,*sdel;

  if (_exeparent(obj,(char *)argv[1],inst,rval,argc,argv)) return 1;
  DeleteObject(menulocal.menufont);
  arraydel2(&(menulocal.drawrable));
  arrayfree2(menulocal.mathlist);
  arrayfree2(menulocal.ngpfilelist);
  arrayfree2(menulocal.ngpdirlist);
  arrayfree2(menulocal.datafilelist);
  memfree(menulocal.name);
  memfree(menulocal.id);
  memfree(menulocal.fontname);
  memfree(menulocal.editor);
  free(menulocal.fileopendir);
  free(menulocal.graphloaddir);
  memfree(menulocal.expanddir);
  pcur=menulocal.extprinterroot;
  while (pcur!=NULL) {
    pdel=pcur;
    pcur=pcur->next;
    memfree(pdel->name);
    memfree(pdel->driver);
    memfree(pdel->ext);
    memfree(pdel->option);
    memfree(pdel);
  }
  scur=menulocal.scriptroot;
  while (scur!=NULL) {
    sdel=scur;
    scur=scur->next;
    memfree(sdel->name);
    memfree(sdel->script);
    memfree(sdel->option);
    memfree(sdel);
  }
  fcur=mwlocal->fontmaproot;
  while (fcur!=NULL) {
    fdel=fcur;
    fcur=fcur->next;
    memfree(fdel->fontname);
    memfree(fdel->fontalias);
    memfree(fdel);
  }
  return 0;
}

extern "C" void mwindisplaydialog(char *str)
{
  NgraphApp->DisplayDialog(str);
}

extern "C" void mwindisplaystatus(char *str)
{
  NgraphApp->DisplayStatus(str);
}

extern "C" int mwinputstderr(char *s)
{
  return NgraphApp->PutStderr(s);
}

extern "C" int mwinprintfstderr(char *fmt,...)
{
  int len;
  char buf[1024];
  va_list ap;

  va_start(ap,fmt);
  len=vsprintf(buf,fmt,ap);
  va_end(ap);
  NgraphApp->PutStderr(buf);
  return len;
}

extern "C" int mwinterrupt()
{
  return NgraphApp->ChkInterrupt();
}

extern "C" int mwinputyn(char *mes)
{
  return NgraphApp->InputYN(mes);
}

extern "C" int menumenu(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  char *file;

  if (_exeparent(obj,(char *)argv[1],inst,rval,argc,argv)) return 1;
  if (mwlocal->lock) {
    error(obj,ERRRUN);
    return 1;
  }
  mwlocal->lock=1;

  savestdio(&winiosave);

  putstderr=mwinputstderr;
  printfstderr=mwinprintfstderr;
  ndisplaydialog=mwindisplaydialog;
  ndisplaystatus=mwindisplaystatus;
  ninterrupt=mwinterrupt;
  inputyn=mwinputyn;

  file=(char *)argv[2];

  TMyApp(file).Run();

  loadstdio(&winiosave);
  mwlocal->lock=0;
  return 0;
}

extern "C" int mw_evloop(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  MSG msg;

  if (PeekMessage(&msg,NULL,0,0,PM_NOREMOVE)) {
    GetMessage(&msg,NULL,0,0);
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  return 0;
}

extern "C" int mwredrawflag(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  mwlocal->redrawf=*(int *)argv[2];
  return 0;
}

extern "C" void mw_flush(struct objlist *obj,char *inst)
{
  if (mwlocal->linetonum!=0) {
    if (mwlocal->MetaFile!=1) {
      EndPath(mwlocal->DC);
      StrokePath(mwlocal->DC);
    }
    mwlocal->linetonum=0;
  }
}


extern "C" int mwflush(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  mw_flush(obj,inst);
  return 0;
}

extern "C" void mw_redraw(struct objlist *obj,char *inst)
{
  GRAredraw(obj,inst,TRUE,mwlocal->redrawf);
  mw_flush(obj,inst);
}

extern "C" void mw_inslist(struct objlist *obj,char *inst,
                struct objlist *aobj,char *ainst,char *afield,int addn)
{
  int GC;

  _getobj(obj,"_GC",inst,&GC);
  GRAinslist(GC,aobj,ainst,chkobjectname(aobj),afield,addn);
}

extern "C" void mw_dellist(struct objlist *obj,char *inst,int deln)
{
  int GC;

  _getobj(obj,"_GC",inst,&GC);
  GRAdellist(GC,deln);
}

extern "C" int mwredraw(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  mw_redraw(obj,inst);
  return 0;
}

extern "C" int mwautoredraw(struct objlist *obj,char *inst,char *rval,
                 int argc,char **argv)
{
  if (!(mwlocal->autoredraw) && (*(int *)argv[2]))
    mw_redraw(obj,inst);
  mwlocal->autoredraw=*(int *)argv[2];
  return 0;
}

extern "C" int mwdpi(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  int dpi;

  dpi=abs(*(int *)argv[2]);
  if (dpi<1) dpi=1;
  if (dpi>2540) dpi=2540;
  mwlocal->windpi=dpi;
  mwlocal->pixel_dot=dpi/2540.0;
  *(int *)argv[2]=dpi;
  if (mwlocal->hWnd!=NULL) InvalidateRect(mwlocal->hWnd,NULL,TRUE);
  return 0;
}

extern "C" int mwclear(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  if (_exeparent(obj,(char *)argv[1],inst,rval,argc,argv)) return 1;
  if (mwlocal->linetonum!=0) {
    if (mwlocal->MetaFile!=1) {
      EndPath(mwlocal->DC);
      StrokePath(mwlocal->DC);
    }
    mwlocal->linetonum=0;
  }
  if (mwlocal->hWnd!=NULL) {
    InvalidateRect(mwlocal->hWnd,NULL,TRUE);
    UpdateWindow(mwlocal->hWnd);
  }
  return 0;
}

extern "C" void mwsaveDC(HDC dc,HWND hWnd,int scrollx,int scrolly,
                         struct mwlocal *mwsave,
                         int dpi,int MetaFile,HRGN region)
{
  LOGBRUSH lBrush;

  memcpy(mwsave,mwlocal,sizeof(struct mwlocal));
  mwlocal->DC=dc;
  mwlocal->hWnd=hWnd;
  mwlocal->MetaFile=MetaFile;
  mwlocal->region=region;
  mwlocal->scrollx=scrollx;
  mwlocal->scrolly=scrolly;
  mwlocal->style=PS_SOLID;
  mwlocal->width=1;
  mwlocal->Col=RGB(0,0,0);
  mwlocal->dashlist=NULL;
  mwlocal->dashn=0;
  mwlocal->dashlen=0;
  mwlocal->dashi=0;
  mwlocal->dotf=TRUE;
  mwlocal->x0=0;
  mwlocal->y0=0;
  mwlocal->offsetx=0;
  mwlocal->offsety=0;
  mwlocal->cpx=0;
  mwlocal->cpy=0;
  mwlocal->fontalias=NULL;
  mwlocal->loadfontf=FALSE;
  mwlocal->linetonum=0;
  if (!MetaFile) {
    mwlocal->saveDC=SaveDC(dc);
    mwlocal->ThePen=(HPEN)GetStockObject(BLACK_PEN);
    mwlocal->TheBrush=(HBRUSH)GetStockObject(BLACK_BRUSH);
    mwlocal->TheFont=(HFONT)GetStockObject(SYSTEM_FONT);
    mwlocal->OrgPen=(HPEN)SelectObject(dc,mwlocal->ThePen);
    mwlocal->OrgBrush=(HBRUSH)SelectObject(dc,mwlocal->TheBrush);
    mwlocal->OrgFont=(HFONT)SelectObject(dc,mwlocal->TheFont);
  } else {
    mwlocal->ThePen=NULL;
    mwlocal->TheBrush=NULL;
    mwlocal->TheFont=NULL;
    mwlocal->OrgPen=CreatePen(PS_NULL,0,RGB(0,0,0));
    lBrush.lbStyle=BS_NULL;
    mwlocal->OrgBrush=CreateBrushIndirect(&lBrush);
    mwlocal->OrgFont=NULL;
    SelectObject(dc,mwlocal->OrgPen);
    SelectObject(dc,mwlocal->OrgBrush);
  }
  if (dpi!=-1) {
    mwlocal->windpi=dpi;
    mwlocal->pixel_dot=mwlocal->windpi/2540.0;
  } else {
    mwlocal->windpi=mwsave->windpi;
    mwlocal->pixel_dot=mwsave->pixel_dot;
  }
}

extern "C" void mwrestoreDC(struct mwlocal *mwsave)
{
  if (mwlocal->linetonum!=0) {
    if (mwlocal->MetaFile!=1) {
      EndPath(mwlocal->DC);
      StrokePath(mwlocal->DC);
      mwlocal->linetonum=0;
    }
  }
  if (!mwlocal->MetaFile) {
    SelectObject(mwlocal->DC,mwlocal->OrgPen);
    SelectObject(mwlocal->DC,mwlocal->OrgBrush);
    SelectObject(mwlocal->DC,mwlocal->OrgFont);
    RestoreDC(mwlocal->DC,mwlocal->saveDC);
    DeleteObject(mwlocal->ThePen);
    DeleteObject(mwlocal->TheBrush);
    DeleteObject(mwlocal->TheFont);
  } else {
    SelectObject(mwlocal->DC,(HPEN)GetStockObject(BLACK_PEN));
    SelectObject(mwlocal->DC,(HBRUSH)GetStockObject(BLACK_BRUSH));
    SelectObject(mwlocal->DC,(HFONT)GetStockObject(SYSTEM_FONT));
    DeleteObject(mwlocal->ThePen);
    DeleteObject(mwlocal->TheBrush);
    DeleteObject(mwlocal->TheFont);
    DeleteObject(mwlocal->OrgPen);
    DeleteObject(mwlocal->OrgBrush);
  }
  memfree(mwlocal->dashlist);
  memfree(mwlocal->fontalias);
  memcpy(mwlocal,mwsave,sizeof(struct mwlocal));
}

extern "C" void mw_moveto(int x0,int y0)
{
  mwlocal->dashlen=0;
  mwlocal->dashi=0;
  mwlocal->dotf=TRUE;
  mwlocal->x0=x0;
  mwlocal->y0=y0;
  MoveToEx(mwlocal->DC,x0,y0,NULL);
}

extern "C" void mw_lineto(int x,int y)
{
  double dd,len,len2;
  double dx,dy;
  int gx,gy,gx1,gy1,gx2,gy2;

  gx1=mwlocal->x0;
  gy1=mwlocal->y0;
  gx2=x;
  gy2=y;
  if (mwlocal->dashn==0) LineTo(mwlocal->DC,gx2,gy2);
  else {
    dx=(gx2-gx1);
    dy=(gy2-gy1);
    len2=len=sqrt(dx*dx+dy*dy);
    while (len2>((mwlocal->dashlist)[mwlocal->dashi]-mwlocal->dashlen)) {
      dd=(len-len2+(mwlocal->dashlist)[mwlocal->dashi]-mwlocal->dashlen)/len;
      gx=gx1+nround(dx*dd);
      gy=gy1+nround(dy*dd);
      if (mwlocal->dotf) LineTo(mwlocal->DC,gx,gy);
      else MoveToEx(mwlocal->DC,gx,gy,NULL);
      mwlocal->dotf=mwlocal->dotf ? FALSE : TRUE;
      len2-=((mwlocal->dashlist)[mwlocal->dashi]-mwlocal->dashlen);
      mwlocal->dashlen=0;
      mwlocal->dashi++;
      if (mwlocal->dashi>=mwlocal->dashn) {
        mwlocal->dashi=0;
        mwlocal->dotf=TRUE;
      }
    }
    if (mwlocal->dotf) LineTo(mwlocal->DC,gx2,gy2);
    mwlocal->dashlen+=len2;
  }
  mwlocal->x0=x;
  mwlocal->y0=y;
}

extern "C" int mwd2p(int r)
{
  return nround(r*mwlocal->pixel_dot);
}

extern "C" int mwd2px(int x)
{
  return nround(x*mwlocal->pixel_dot+mwlocal->offsetx-mwlocal->scrollx);
}

extern "C" int mwd2py(int y)
{
  return nround(y*mwlocal->pixel_dot+mwlocal->offsety-mwlocal->scrolly);
}

extern "C" int mwp2d(int r)
{
  return nround(r/mwlocal->pixel_dot);
}


extern "C" int mw_output(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  char code;
  int *cpar;
  char *cstr,ch[1],*s,*sw;
  HPEN TmpPen;
  HBRUSH TmpBrush;
  HFONT TmpFont;
  HRGN hClip;
  unsigned int style,cap,join;
  int i,R,G,B;
  double Theta1,Theta2;
  POINT *Points;
  LOGBRUSH lBrush;
  SIZE lpsize;
  HDC DC;
  HDC refDC;
  int charset;
  int italic;
  double fontsize,fontspace,fontdir;
  char *fontname;
  struct fontmap *fcur;
  double x0,y0,fontwidth;
  RECT rect;
  OSVERSIONINFO VersionInformation;

  code=*(char *)(argv[3]);
  cpar=(int *)argv[4];
  cstr=(char *)argv[5];
  DC=mwlocal->DC;
  if (DC==NULL) return 0;
  if (mwlocal->linetonum!=0) {
    if ((code!='T') || (mwlocal->linetonum>=LINETOLIMIT)) {
      if (mwlocal->MetaFile!=1) {
        EndPath(DC);
        StrokePath(DC);
      }
      mwlocal->linetonum=0;
    }
  }
  switch (code) {
  case 'I':
    break;
  case 'E': case '%': case 'X':
    break;
  case 'V':
    mwlocal->offsetx=mwd2p(cpar[1]);
    mwlocal->offsety=mwd2p(cpar[2]);
    mwlocal->cpx=0;
    mwlocal->cpy=0;
    if (!mwlocal->MetaFile) {
      if (cpar[5]==1) {
        hClip=CreateRectRgn(mwd2p(cpar[1])-mwlocal->scrollx,
                            mwd2p(cpar[2])-mwlocal->scrolly,
                            mwd2p(cpar[3])-mwlocal->scrollx,
                            mwd2p(cpar[4])-mwlocal->scrolly);
        if (mwlocal->region!=NULL)
          CombineRgn(hClip,hClip,mwlocal->region,RGN_AND);
        SelectClipRgn(DC,hClip);
        DeleteObject(hClip);
      } else {
        if (mwlocal->region!=NULL) SelectClipRgn(DC,mwlocal->region);
        else SelectClipRgn(DC,NULL);
      }
    }
    break;
  case 'A':
    if (cpar[1]==0) {
      style=PS_SOLID;
      mwlocal->dashn=0;
      memfree(mwlocal->dashlist);
      mwlocal->dashlist=NULL;
    } else {
      memfree(mwlocal->dashlist);
      style=PS_USERSTYLE;
      if ((mwlocal->dashlist=
          (unsigned long *)memalloc(sizeof(int)*cpar[1]))==NULL) break;
      for (i=0;i<cpar[1];i++)
       if ((mwlocal->dashlist[i]=mwd2p(cpar[6+i]))<=0)
         mwlocal->dashlist[i]=1;
      mwlocal->dashn=cpar[1];
    }
    mwlocal->width=mwd2p(cpar[2]);
    if (cpar[3]==2) cap=PS_ENDCAP_SQUARE;
    else if (cpar[3]==1) cap=PS_ENDCAP_ROUND;
    else cap=PS_ENDCAP_FLAT;
    if (cpar[4]==2) join=PS_JOIN_BEVEL;
    else if (cpar[4]==1) join=PS_JOIN_ROUND;
    else join=PS_JOIN_MITER;
    mwlocal->style= PS_GEOMETRIC | style | cap | join;
    if (mwlocal->MetaFile!=1) {
      lBrush.lbStyle=BS_SOLID;
      lBrush.lbColor=mwlocal->Col;
      VersionInformation.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
      GetVersionEx(&VersionInformation);
      if (VersionInformation.dwPlatformId==VER_PLATFORM_WIN32_NT) {
        TmpPen=ExtCreatePen(mwlocal->style,
                            mwlocal->width,&lBrush,
                            mwlocal->dashn,mwlocal->dashlist);
      } else {
        style=PS_SOLID;
        mwlocal->style= PS_GEOMETRIC | style | cap | join;
        TmpPen=ExtCreatePen(mwlocal->style,mwlocal->width,&lBrush,0,NULL);
      }
    } else {
      style=PS_SOLID;
      mwlocal->style=style;
      TmpPen=CreatePen(mwlocal->style,mwlocal->width,mwlocal->Col);
    }
    SelectObject(DC,TmpPen);
    DeleteObject(mwlocal->ThePen);
    mwlocal->ThePen=TmpPen;
    SetMiterLimit(DC,cpar[5]/100,NULL);
    break;
  case 'G':
    R=cpar[1];
    if (R>255) R=255;
    else if (R<0) R=0;
    G=cpar[2];
    if (G>255) G=255;
    else if (G<0) G=0;
    B=cpar[3];
    if (B>255) B=255;
    else if (B<0) B=0;
    mwlocal->Col=RGB(R,G,B);
    if (mwlocal->MetaFile!=1) {
      lBrush.lbStyle=BS_SOLID;
      lBrush.lbColor=mwlocal->Col;
      if (mwlocal->style & PS_USERSTYLE) {
        TmpPen=ExtCreatePen(mwlocal->style,
                            mwlocal->width,&lBrush,
                            mwlocal->dashn,mwlocal->dashlist);
      } else {
        TmpPen=ExtCreatePen(mwlocal->style,
                            mwlocal->width,&lBrush,0,NULL);
      }
    } else {
      TmpPen=CreatePen(mwlocal->style,mwlocal->width,mwlocal->Col);
    }
    SelectObject(DC,TmpPen);
    DeleteObject(mwlocal->ThePen);
    mwlocal->ThePen=TmpPen;
    TmpBrush=CreateSolidBrush(mwlocal->Col);
    SelectObject(DC,TmpBrush);
    DeleteObject(mwlocal->TheBrush);
    SetTextColor(DC,mwlocal->Col);
    mwlocal->TheBrush=TmpBrush;
    break;
  case 'M':
    mwlocal->cpx=cpar[1];
    mwlocal->cpy=cpar[2];
    break;
  case 'N':
    mwlocal->cpx+=cpar[1];
    mwlocal->cpy+=cpar[2];
    break;
  case 'L':
    if (mwlocal->MetaFile!=1) BeginPath(DC);
    if ((mwlocal->dashn!=0) && ((mwlocal->style & PS_USERSTYLE)==0)) {
      mw_moveto(mwd2px(cpar[1]),mwd2py(cpar[2]));
      mw_lineto(mwd2px(cpar[3]),mwd2py(cpar[4]));
    } else {
      MoveToEx(DC,mwd2px(cpar[1]),mwd2py(cpar[2]),NULL);
      LineTo(DC,mwd2px(cpar[3]),mwd2py(cpar[4]));
    }
    if (mwlocal->MetaFile!=1) {
      EndPath(DC);
      StrokePath(DC);
    }
    break;
  case 'T':
    if (mwlocal->linetonum==0) {
      if (mwlocal->MetaFile!=1) BeginPath(DC);
      if ((mwlocal->dashn!=0) && ((mwlocal->style & PS_USERSTYLE)==0))
        mw_moveto(mwd2px(mwlocal->cpx),mwd2py(mwlocal->cpy));
      else
        MoveToEx(DC,mwd2px(mwlocal->cpx),mwd2py(mwlocal->cpy),NULL);
    }
    if ((mwlocal->dashn!=0) && ((mwlocal->style & PS_USERSTYLE)==0))
      mw_lineto(mwd2px(cpar[1]),mwd2py(cpar[2]));
    else
      LineTo(DC,mwd2px(cpar[1]),mwd2py(cpar[2]));
    mwlocal->linetonum++;
    mwlocal->cpx=cpar[1];
    mwlocal->cpy=cpar[2];
    break;
  case 'C':
    if (cpar[6]==36000) {
      if (cpar[7]==0) {
        if (mwlocal->MetaFile!=1) TmpBrush=(HBRUSH)GetStockObject(NULL_BRUSH);
        else TmpBrush=mwlocal->OrgBrush;
        SelectObject(DC,TmpBrush);
        Ellipse(DC,
              mwd2px(cpar[1]-cpar[3]),
              mwd2py(cpar[2]-cpar[4]),
              mwd2px(cpar[1]+cpar[3]),
              mwd2py(cpar[2]+cpar[4]));
        SelectObject(DC,mwlocal->TheBrush);
        if (mwlocal->MetaFile!=1) DeleteObject(TmpBrush);
      } else {
        if (mwlocal->MetaFile!=1) TmpPen=(HPEN)GetStockObject(NULL_PEN);
        else TmpPen=mwlocal->OrgPen;
        SelectObject(DC,TmpPen);
        Ellipse(DC,
              mwd2px(cpar[1]-cpar[3]),
              mwd2py(cpar[2]-cpar[4]),
              mwd2px(cpar[1]+cpar[3]),
              mwd2py(cpar[2]+cpar[4]));
        SelectObject(DC,mwlocal->ThePen);
        if (mwlocal->MetaFile!=1) DeleteObject(TmpPen);
      }
    } else {
      Theta1=cpar[5]*MPI/18000.0;
      Theta2=Theta1+cpar[6]*MPI/18000.0;
      if (cpar[7]==0) {
        Arc(DC,
              mwd2px(cpar[1]-cpar[3]),
              mwd2py(cpar[2]-cpar[4]),
              mwd2px(cpar[1]+cpar[3]),
              mwd2py(cpar[2]+cpar[4]),
              mwd2px(cpar[1]+nround(cpar[3]*cos(Theta1)))-1,
              mwd2py(cpar[2]-nround(cpar[4]*sin(Theta1)))-1,
              mwd2px(cpar[1]+nround(cpar[3]*cos(Theta2)))-1,
              mwd2py(cpar[2]-nround(cpar[4]*sin(Theta2)))-1);
      } else {
        if (mwlocal->MetaFile!=1) TmpPen=(HPEN)GetStockObject(NULL_PEN);
        else TmpPen=mwlocal->OrgPen;
        SelectObject(DC,TmpPen);
        if (cpar[7]==1) {
          if ((mwd2p(cpar[3])<2) && (mwd2p(cpar[4])<2)) {
            SetPixel(DC,mwd2px(cpar[1]),mwd2py(cpar[2]),mwlocal->Col);
          }
          Pie(DC,
              mwd2px(cpar[1]-cpar[3]),
              mwd2py(cpar[2]-cpar[4]),
              mwd2px(cpar[1]+cpar[3]),
              mwd2py(cpar[2]+cpar[4]),
              mwd2px(cpar[1]+nround(cpar[3]*cos(Theta1)))-1,
              mwd2py(cpar[2]-nround(cpar[4]*sin(Theta1)))-1,
              mwd2px(cpar[1]+nround(cpar[3]*cos(Theta2)))-1,
              mwd2py(cpar[2]-nround(cpar[4]*sin(Theta2)))-1);
        } else {
          Chord(DC,
              mwd2px(cpar[1]-cpar[3]),
              mwd2py(cpar[2]-cpar[4]),
              mwd2px(cpar[1]+cpar[3]),
              mwd2py(cpar[2]+cpar[4]),
              mwd2px(cpar[1]+nround(cpar[3]*cos(Theta1)))-1,
              mwd2py(cpar[2]-nround(cpar[4]*sin(Theta1)))-1,
              mwd2px(cpar[1]+nround(cpar[3]*cos(Theta2)))-1,
              mwd2py(cpar[2]-nround(cpar[4]*sin(Theta2)))-1);
        }
        SelectObject(DC,mwlocal->ThePen);
        if (mwlocal->MetaFile!=1) DeleteObject(TmpPen);
      }
    }
    break;
  case 'B':
    if (cpar[5]==0) {
      if (mwlocal->MetaFile!=1) TmpBrush=(HBRUSH)GetStockObject(NULL_BRUSH);
      else TmpBrush=mwlocal->OrgBrush;
      SelectObject(DC,TmpBrush);
      Rectangle(DC,mwd2px(cpar[1]),mwd2py(cpar[2]),
                   mwd2px(cpar[3]),mwd2py(cpar[4]));
      SelectObject(DC,mwlocal->TheBrush);
      if (mwlocal->MetaFile!=1) DeleteObject(TmpBrush);
    } else {
      rect.left=mwd2px(cpar[1]);
      rect.top=mwd2py(cpar[2]);
      rect.right=mwd2px(cpar[3]);
      rect.bottom=mwd2py(cpar[4]);
      FillRect(DC,&rect,mwlocal->TheBrush);
    }
    break;
  case 'P':
	SetPixel(DC,mwd2px(cpar[1]),mwd2py(cpar[2]),mwlocal->Col);
	break;
  case 'R':
    if (cpar[1]==0) break;
    if (mwlocal->MetaFile!=1) BeginPath(DC);
    MoveToEx(DC,mwd2px(cpar[2]),mwd2py(cpar[3]),NULL);
    for (i=1;i<cpar[1];i++) {
      LineTo(DC,mwd2px(cpar[i*2+2]),mwd2py(cpar[i*2+3]));
    }
    if (mwlocal->MetaFile!=1) {
      EndPath(DC);
      StrokePath(DC);
    }
    break;
  case 'D':
    if (cpar[1]==0) break;
    if ((Points=(tagPOINT *)memalloc(sizeof(POINT)*cpar[1]))==NULL) break;
    for (i=0;i<cpar[1];i++) {
      Points[i].x=mwd2px(cpar[i*2+3]);
      Points[i].y=mwd2py(cpar[i*2+4]);
    }
    if (cpar[2]==0) {
      if (mwlocal->MetaFile!=1) TmpBrush=(HBRUSH)GetStockObject(NULL_BRUSH);
      else TmpBrush=mwlocal->OrgBrush;
      SelectObject(DC,TmpBrush);
      if (mwlocal->MetaFile!=1) BeginPath(DC);
      Polygon(DC,Points,cpar[1]);
      if (mwlocal->MetaFile!=1) {
        CloseFigure(DC);
        EndPath(DC);
        StrokePath(DC);
      }
      SelectObject(DC,mwlocal->TheBrush);
      if (mwlocal->MetaFile!=1) DeleteObject(TmpBrush);
    } else {
      if (mwlocal->MetaFile!=1) TmpPen=(HPEN)GetStockObject(NULL_PEN);
      else TmpPen=mwlocal->OrgPen;
      SelectObject(DC,TmpPen);
      if (cpar[2]==1) {
        SetPolyFillMode(DC,ALTERNATE);
        if (mwlocal->MetaFile!=1) BeginPath(DC);
        Polygon(DC,Points,cpar[1]);
        if (mwlocal->MetaFile!=1) {
          CloseFigure(DC);
          EndPath(DC);
          FillPath(DC);
        }
      } else {
        SetPolyFillMode(DC,WINDING);
        if (mwlocal->MetaFile!=1) BeginPath(DC);
        Polygon(DC,Points,cpar[1]);
        if (mwlocal->MetaFile!=1) {
          CloseFigure(DC);
          EndPath(DC);
          FillPath(DC);
        }
      }
      SelectObject(DC,mwlocal->ThePen);
      if (mwlocal->MetaFile!=1) DeleteObject(TmpPen);
    }
    memfree(Points);
    break;
  case 'F':
    memfree(mwlocal->fontalias);
    if ((mwlocal->fontalias=(char *)memalloc(strlen(cstr)+1))==NULL) break;
    strcpy(mwlocal->fontalias,cstr);
    break;
  case 'H':
    mwlocal->loadfontf=FALSE;
    fontspace=cpar[2]/72.0*25.4;
    mwlocal->fontspace=fontspace;
    fontsize=cpar[1]/72.0*25.4;
    fontdir=cpar[3]/100.0;
    mwlocal->fontsin=sin(fontdir/180*MPI);
    mwlocal->fontcos=cos(fontdir/180*MPI);
    fcur=mwlocal->fontmaproot;
    fontname=NULL;
    while (fcur!=NULL) {
      if (strcmp(mwlocal->fontalias,fcur->fontalias)==0) {
        fontname=fcur->fontname;
        charset=fcur->charset;
        italic=fcur->italic;
        break;
      }
      fcur=fcur->next;
    }
    if (fontname==NULL) {
      mwlocal->loadfontf=FALSE;
      break;
    }
    mwlocal->IDFont.lfHeight=-mwd2p(fontsize);
    mwlocal->IDFont.lfWidth=0;
    mwlocal->IDFont.lfEscapement=mwlocal->IDFont.lfOrientation=nround(fontdir*10);
    mwlocal->IDFont.lfUnderline=0;
    mwlocal->IDFont.lfStrikeOut=0;
    mwlocal->IDFont.lfPitchAndFamily=0;
    if (charset==ANSI2_CHARSET) mwlocal->IDFont.lfCharSet=ANSI_CHARSET;
    else mwlocal->IDFont.lfCharSet=charset;

    mwlocal->IDFont.lfOutPrecision=0;
    mwlocal->IDFont.lfClipPrecision=0;
    mwlocal->IDFont.lfQuality=0;
    if (italic==FONT_ROMAN) {
      mwlocal->IDFont.lfWeight=400;
      mwlocal->IDFont.lfItalic=FALSE;
    } else if (italic==FONT_ITALIC) {
      mwlocal->IDFont.lfWeight=400;
      mwlocal->IDFont.lfItalic=TRUE;
    } else if (italic==FONT_BOLD) {
      mwlocal->IDFont.lfWeight=700;
      mwlocal->IDFont.lfItalic=FALSE;
    } else if (italic==FONT_BOLDITALIC) {
      mwlocal->IDFont.lfWeight=700;
      mwlocal->IDFont.lfItalic=TRUE;
    } else {
      mwlocal->IDFont.lfWeight=0;
      mwlocal->IDFont.lfItalic=0;
    }
    strcpy(mwlocal->IDFont.lfFaceName,fontname);
    if ((TmpFont=CreateFontIndirect(&(mwlocal->IDFont)))!=NULL) {
      SelectObject(DC,TmpFont);
      DeleteObject(mwlocal->TheFont);
      mwlocal->TheFont=TmpFont;
      SetTextAlign(DC,TA_BASELINE | TA_LEFT);
      SetTextCharacterExtra(DC,mwd2p(mwlocal->fontspace));
      SetBkMode(DC,TRANSPARENT);
      mwlocal->loadfontf=TRUE;
      mwlocal->charset=charset;
    }
    mwlocal->IDFont.lfEscapement=mwlocal->IDFont.lfOrientation=0;
    break;
  case 'S':
    if (!mwlocal->loadfontf) break;
    if ((s=nstrnew())==NULL) break;
    i=0;
    while (i<strlen(cstr)) {
      if (cstr[i]=='\\') {
        if (cstr[i+1]=='x') {
          if (toupper(cstr[i+2])>='A') ch[0]=toupper(cstr[i+2])-'A'+10;
          else ch[0]=cstr[i+2]-'0';
          if (toupper(cstr[i+3])>='A') ch[0]=ch[0]*16+toupper(cstr[i+3])-'A'+10;
          else ch[0]=ch[0]*16+cstr[i+3]-'0';
          i+=4;
        } else if (cstr[i+1]=='\\') {
          ch[0]=cstr[i+1];
          i+=2;
        } else {
          ch[0]='\0';
          i++;
        }
      } else {
        ch[0]=cstr[i];
        i++;
      }
      s=nstrccat(s,ch[0]);
    }
    if (s==NULL) break;
    x0=mwlocal->cpx;
    y0=mwlocal->cpy;
    if ((mwlocal->charset==ANSI_CHARSET) && (!mwlocal->minus_hyphen)
    && (mwlocal->MetaFile!=1)) {
      if ((sw=(char *)memalloc(strlen(s)*2))!=NULL) {
        for (i=0;i<strlen(s);i++) {
          if (s[i]=='-') {
            sw[2*i]='\x12';
            sw[2*i+1]='\x22';
          } else {
            sw[2*i]=s[i];
            sw[2*i+1]='\0';
          }
        }
        ExtTextOutW(DC,mwd2px(nround(x0)),mwd2py(nround(y0)),NULL,NULL,(wchar_t *)sw,strlen(s),NULL);
        refDC=GetDC(mwlocal->hWnd);
        TmpFont=CreateFontIndirect(&(mwlocal->IDFont));
        TmpFont=(HFONT)SelectObject(refDC,TmpFont);
        SetTextAlign(refDC,TA_BASELINE | TA_LEFT);
        SetTextCharacterExtra(refDC,mwd2p(mwlocal->fontspace));
        GetTextExtentPoint32W(refDC,(wchar_t *)sw,strlen(s),&lpsize);
        DeleteObject(SelectObject(refDC,TmpFont));
        ReleaseDC(mwlocal->hWnd,refDC);
      }
      memfree(sw);
    } else {
      if ((mwlocal->charset==ANSI_CHARSET) && (mwlocal->minus_hyphen)) {
        for (i=0;i<strlen(s);i++) {
          if (s[i]=='-') s[i]='\x96';
          else if (s[i]=='\x96') s[i]='-';
        }
      }
      ExtTextOut(DC,mwd2px(nround(x0)),mwd2py(nround(y0)),NULL,NULL,s,strlen(s),NULL);
      refDC=GetDC(mwlocal->hWnd);
      TmpFont=CreateFontIndirect(&(mwlocal->IDFont));
      TmpFont=(HFONT)SelectObject(refDC,TmpFont);
      SetTextAlign(refDC,TA_BASELINE | TA_LEFT);
      SetTextCharacterExtra(refDC,mwd2p(mwlocal->fontspace));
      GetTextExtentPoint32(refDC,s,strlen(s),&lpsize);
      DeleteObject(SelectObject(refDC,TmpFont));
      ReleaseDC(mwlocal->hWnd,refDC);
    }
    memfree(s);
    fontwidth=mwp2d(lpsize.cx);
    x0+=fontwidth*mwlocal->fontcos;
    y0-=fontwidth*mwlocal->fontsin;
    mwlocal->cpx=nround(x0);
    mwlocal->cpy=nround(y0);
    break;
  case 'K':
    if (!mwlocal->loadfontf) break;
    x0=mwlocal->cpx;
    y0=mwlocal->cpy;
    ExtTextOut(DC,mwd2px(nround(x0)),mwd2py(nround(y0)),NULL,NULL,cstr,strlen(cstr),NULL);
    refDC=GetDC(mwlocal->hWnd);
    TmpFont=CreateFontIndirect(&(mwlocal->IDFont));
    TmpFont=(HFONT)SelectObject(refDC,TmpFont);
    SetTextAlign(refDC,TA_BASELINE | TA_LEFT);
    SetTextCharacterExtra(refDC,mwd2p(mwlocal->fontspace));
    GetTextExtentPoint32(refDC,cstr,strlen(cstr),&lpsize);
    DeleteObject(SelectObject(refDC,TmpFont));
    ReleaseDC(mwlocal->hWnd,refDC);
    fontwidth=mwp2d(lpsize.cx);
    x0+=(fontwidth+mwlocal->fontspace)*mwlocal->fontcos;
    y0-=(fontwidth+mwlocal->fontspace)*mwlocal->fontsin;
    mwlocal->cpx=nround(x0);
    mwlocal->cpy=nround(y0);
    break;
  default: break;
  }
  return 0;
}

extern "C" int mw_charwidth(struct objlist *obj,char *inst,char *rval,
                    int argc,char **argv)
{
  char ch[3];
  char *font;
  double size;
  char *fontname;
  struct fontmap *fcur;
  HFONT TmpFont,OrgFont;
  LOGFONT IDFont;
  SIZE lpsize;
  HDC DC;
  int charset,italic;

  ch[0]=(*(unsigned int *)(argv[3]) & 0xff);
  ch[1]=(*(unsigned int *)(argv[3]) & 0xff00) >> 8;
  ch[2]='\0';
  size=(*(int *)(argv[4]))/72.0*25.4;
  font=(char *)(argv[5]);
  fcur=mwlocal->fontmaproot;
  fontname=NULL;
  while (fcur!=NULL) {
    if (strcmp(font,fcur->fontalias)==0) {
      fontname=fcur->fontname;
      charset=fcur->charset;
      italic=fcur->italic;
      break;
    }
    fcur=fcur->next;
  }
  if (fontname==NULL) {
    *(int *)rval=nround(size*0.600);
  } else {
    IDFont.lfHeight=-size;
    IDFont.lfWidth=0;
    IDFont.lfEscapement=0;
    IDFont.lfOrientation=0;
    IDFont.lfUnderline=0;
    IDFont.lfStrikeOut=0;
    IDFont.lfPitchAndFamily=0;
    if (charset==ANSI2_CHARSET) IDFont.lfCharSet=ANSI_CHARSET;
    else IDFont.lfCharSet=charset;

    IDFont.lfOutPrecision=0;
    IDFont.lfClipPrecision=0;
    IDFont.lfQuality=0;
    if (italic==FONT_ROMAN) {
      IDFont.lfWeight=400;
      IDFont.lfItalic=FALSE;
    } else if (italic==FONT_ITALIC) {
      IDFont.lfWeight=400;
      IDFont.lfItalic=TRUE;
    } else if (italic==FONT_BOLD) {
      IDFont.lfWeight=700;
      IDFont.lfItalic=FALSE;
    } else if (italic==FONT_BOLDITALIC) {
      IDFont.lfWeight=700;
      IDFont.lfItalic=TRUE;
    } else {
      IDFont.lfWeight=0;
      IDFont.lfItalic=0;
    }
    strcpy(IDFont.lfFaceName,fontname);
    if ((TmpFont=CreateFontIndirect(&IDFont))!=NULL) {
      DC=GetDC(HWND_DESKTOP);
      OrgFont=(HFONT)SelectObject(DC,TmpFont);
      SetTextAlign(DC,TA_BASELINE | TA_LEFT);
      if (IDFont.lfCharSet==SHIFTJIS_CHARSET)
        GetTextExtentPoint32(DC,ch,2,&lpsize);
      else if ((charset==ANSI_CHARSET) && (!mwlocal->minus_hyphen)) {
        if (ch[0]=='-') {
          ch[0]='\x12';
          ch[1]='\x22';
        } else ch[1]='\0';
        GetTextExtentPoint32W(DC,(wchar_t *)ch,1,&lpsize);
      } else {
         if (charset==ANSI_CHARSET) {
           if (ch[0]=='-') ch[0]='\x96';
           else if (ch[0]=='\x96') ch[0]='-';
         }
         GetTextExtentPoint32(DC,ch,1,&lpsize);
      }
      *(int *)rval=lpsize.cx;
      SelectObject(DC,OrgFont);
      DeleteObject(TmpFont);
      ReleaseDC(HWND_DESKTOP,DC);
    } else *(int *)rval=nround(size*0.600);
  }
  return 0;
}

extern "C" int mw_charheight(struct objlist *obj,char *inst,char *rval,
                     int argc,char **argv)
{
  char *font;
  double size;
  char *fontname;
  struct fontmap *fcur;
  HFONT TmpFont,OrgFont;
  LOGFONT IDFont;
  TEXTMETRIC tm;
  HDC DC;
  int charset,italic;
  char *func;
  int height;

  func=(char *)argv[1];
  if (strcmp0(func,"_charascent")==0) height=TRUE;
  else height=FALSE;
  size=(*(int *)(argv[3]))/72.0*25.4;
  font=(char *)(argv[4]);
  fcur=mwlocal->fontmaproot;
  fontname=NULL;
  while (fcur!=NULL) {
    if (strcmp(font,fcur->fontalias)==0) {
      fontname=fcur->fontname;
      charset=fcur->charset;
      italic=fcur->italic;
      break;
    }
    fcur=fcur->next;
  }
  if (fontname==NULL) {
    if (height) *(int *)rval=nround(size*0.562);
    else *(int *)rval=nround(size*0.250);
  } else {
    IDFont.lfHeight=-size;
    IDFont.lfWidth=0;
    IDFont.lfEscapement=0;
    IDFont.lfOrientation=0;
    IDFont.lfUnderline=0;
    IDFont.lfStrikeOut=0;
    IDFont.lfPitchAndFamily=0;
    if (charset==ANSI2_CHARSET) IDFont.lfCharSet=ANSI_CHARSET;
    else IDFont.lfCharSet=charset;

    IDFont.lfOutPrecision=0;
    IDFont.lfClipPrecision=0;
    IDFont.lfQuality=0;
    if (italic==FONT_ROMAN) {
      IDFont.lfWeight=400;
      IDFont.lfItalic=FALSE;
    } else if (italic==FONT_ITALIC) {
      IDFont.lfWeight=400;
      IDFont.lfItalic=TRUE;
    } else if (italic==FONT_BOLD) {
      IDFont.lfWeight=700;
      IDFont.lfItalic=FALSE;
    } else if (italic==FONT_BOLDITALIC) {
      IDFont.lfWeight=700;
      IDFont.lfItalic=TRUE;
    } else {
      IDFont.lfWeight=0;
      IDFont.lfItalic=0;
    }
    strcpy(IDFont.lfFaceName,fontname);
    if ((TmpFont=CreateFontIndirect(&IDFont))!=NULL) {
      DC=GetDC(HWND_DESKTOP);
      OrgFont=(HFONT)SelectObject(DC,TmpFont);
      GetTextMetrics(DC,&tm);
      if (height) *(int *)rval=tm.tmAscent;
      else *(int *)rval=tm.tmDescent;
      SelectObject(DC,OrgFont);
      DeleteObject(TmpFont);
      ReleaseDC(HWND_DESKTOP,DC);
    } else {
      if (height) *(int *)rval=nround(size*0.562);
      else *(int *)rval=nround(size*0.25);
    }
  }
  return 0;
}

extern "C" int mwfullpathngp(struct objlist *obj,char *inst,char *rval,int argc,char **argv)
{
  char *name,*ngp2;

  name=(char *)argv[2];
  if (name==NULL) ngp2=NULL;
  else ngp2=getbasename(name);
  putobj(menulocal.obj,"ngp",0,ngp2);
  return 0;
}


#define TBLNUM 17

struct objtable owlmenu[TBLNUM] = {
  {"init",NVFUNC,NEXEC,menuinit,NULL,0},
  {"done",NVFUNC,NEXEC,menudone,NULL,0},
  {"menu",NVFUNC,NREAD|NEXEC,menumenu,"s",0},
  {"ngp",NSTR,NREAD|NWRITE,NULL,NULL,0},
  {"fullpath_ngp",NSTR,NREAD|NWRITE,mwfullpathngp,NULL,0},
  {"dpi",NINT,NREAD|NWRITE,mwdpi,NULL,0},
  {"auto_redraw",NBOOL,NREAD|NWRITE,mwautoredraw,NULL,0},
  {"redraw_flag",NBOOL,NREAD|NWRITE,mwredrawflag,NULL,0},
  {"redraw",NVFUNC,NREAD|NEXEC,mwredraw,"",0},
  {"flush",NVFUNC,NREAD|NEXEC,mwflush,"",0},
  {"clear",NVFUNC,NREAD|NEXEC,mwclear,"",0},
  {"_output",NVFUNC,0,mw_output,NULL,0},
  {"_charwidth",NIFUNC,0,mw_charwidth,NULL,0},
  {"_charascent",NIFUNC,0,mw_charheight,NULL,0},
  {"_chardescent",NIFUNC,0,mw_charheight,NULL,0},
  {"_evloop",NVFUNC,0,mw_evloop,NULL,0},
  {"_local",NPOINTER,0,NULL,NULL,0},
};

extern "C" void *addmenu()
{
  return addobject(NAME,ALIAS,PARENT,VERSION,TBLNUM,owlmenu,ERRNUM,menuerrorlist,NULL,NULL);
}
