/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 *  owinmenu.h
 *
 */

extern int globallock;
extern struct savedstdio winiosave;

extern void mwindisplaydialog(char *str);
extern void mwindisplaystatus(char *str);
extern int mwinputstderr(char *s);
extern int mwinprintfstderr(char *fmt,...);
extern int mwinterrupt(void);
extern int mwinputyn(char *mes);

struct extprinter {
  char *name;
  char *driver;
  char *ext;
  char *option;
  struct extprinter *next;
};

struct script {
  char *name;
  char *script;
  char *option;
  struct script *next;
};

struct menulocal {
  HWND hWnd;
  HFONT menufont;
  char *fontname;
  int fontsize;
  int fontcharset;
  int fontitalic;
  char *editor;
  struct objlist *obj;
  char *inst;
  struct objlist *outputobj;
  int output;
  int GRAoid;
  char *GRAinst;
  int GC;
  struct objlist *GRAobj;
  int PaperWidth,PaperHeight;
  int LeftMargin,TopMargin;
  int PaperZoom;
  struct narray drawrable;
  struct extprinter *extprinterroot;
  struct script *scriptroot;
  int menuheight,menuwidth,menux,menuy;
  int fileheight,filewidth,filex,filey,fileopen;
  int axisheight,axiswidth,axisx,axisy,axisopen;
  int legendheight,legendwidth,legendx,legendy,legendopen;
  int mergeheight,mergewidth,mergex,mergey,mergeopen;
  int dialogheight,dialogwidth,dialogx,dialogy,dialogopen;
  int coordheight,coordwidth,coordx,coordy,coordopen;
  int controlb1f;
  int controlb2f;
  int statusb;
  int exwindpi,exwinwidth,exwinheight,exwinmemory;
  char *fileopendir;
  char *graphloaddir;
  char *expanddir;
  int expand;
  int ignorepath;
  int expandtofullpath;
  int changedirectory;
  int savehistory;
  struct narray *mathlist;
  struct narray *ngpfilelist;
  struct narray *ngpdirlist;
  struct narray *datafilelist;
  int scriptconsole,addinconsole;
  int savepath,savewithdata,savewithmerge;
  int movechild;
  char *name;
  char *id;
  int registered;
  int registry;
  int unregoid;
  int clipboardEMF;
  int clipboardDPI;
  COLORREF customcolor[16];
};

#define FONT_ROMAN 0
#define FONT_BOLD 1
#define FONT_ITALIC 2
#define FONT_BOLDITALIC 3
#define FONT_UNKNOWN 4

struct fontmap {
  char *fontalias;
  char *fontname;
  int charset;
  int italic;
  struct fontmap *next;
};

struct mwlocal {
  HWND hWnd;
  HRGN region;
  int scrollx,scrolly;
  int autoredraw,redrawf,ruler;
  int windpi;
  int grid;
  int MetaFile;
  HDC DC;
  HPEN ThePen,OrgPen;
  HBRUSH TheBrush,OrgBrush;
  LOGFONT IDFont;
  HFONT TheFont,OrgFont;
  COLORREF Col;
  int style,width,dashn;
  DWORD *dashlist;
  int x0,y0;
  int dashi,dotf;
  double dashlen;
  double pixel_dot;
  int offsetx,offsety;
  int cpx,cpy;
  struct fontmap *fontmaproot;
  int loadfontf;
  int charset;
  char *fontalias;
  double fontspace,fontcos,fontsin;
  int linetonum;
  int saveDC;
  int lock;
  int bgR,bgG,bgB;
  int minus_hyphen;
};

extern struct menulocal menulocal;
extern struct mwlocal *mwlocal;
extern int menulock;
struct fontmap;

void initwindowconfig();
int mwinwindowconfig();
int mwd2p(int r);
int mwd2px(int x);
int mwd2py(int y);
int mwp2d(int r);
void mwsaveDC(HDC dc,HWND hWnd,int scrollx,int scrolly,
              struct mwlocal *mwsave,int dpi,
              int MetaFile,HRGN region);
void mwrestoreDC(struct mwlocal *mwsave);
void mw_redraw(struct objlist *obj,char *inst);
void mw_flush(struct objlist *obj,char *inst);
void mw_inslist(struct objlist *obj,char *inst,
                struct objlist *aobj,char *ainst,char *afield,int addn);
void mw_dellist(struct objlist *obj,char *inst,int deln);
void menuadddrawrable(struct objlist *parent,struct narray *drawrable);

