/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 *  winaxis.h
 *
 */

char *AxisCB(struct objlist *obj,int id);
char *GridCB(struct objlist *obj,int id);


class AxisDialog  : public TMyDialog {
  public:
    AxisDialog(TWindow *parent,TResId resID,struct objlist *obj,int id,int candel);
    ~AxisDialog();
  protected:
    int CanDel;
    struct objlist *Obj;
    int Id;
    SelEdit *MinE,*MaxE,*IncE;
    AxisComboBox *Ref;
    void SetupWindow();
    void SetupItem(int id);
    void CopyClicked() {
      int sel;
      if ((sel=CopyClick(this,Obj,Id,AxisCB))!=-1) SetupItem(sel);
    }
    void CloseWindow(int retVal);
    void DeleteClicked() {CloseWindow(IDDELETE);}
    void BaseClicked();
    void GaugeClicked();
    void NumberClicked();
    void FontClicked();
    void PosClicked();
    void ClearClicked();
    void FileClicked();
    DECLARE_RESPONSE_TABLE(AxisDialog);
};

class GridDialog  : public TMyDialog {
  public:
    GridDialog(TWindow *parent,TResId resID,struct objlist *obj,int id,int candel);
    ~GridDialog();
  protected:
    int CanDel;
    struct objlist *Obj;
    int Id;
    ColorButton *Col,*ColB;
    AxisComboBox *AxisX,*AxisY;
    void SetupWindow();
    void SetupItem(int id);
    void CloseWindow(int retVal);
    void CopyClicked() {
      int sel;
      if ((sel=CopyClick(this,Obj,Id,GridCB))!=-1) SetupItem(sel);
    }
    void DeleteClicked() {CloseWindow(IDDELETE);}
    DECLARE_RESPONSE_TABLE(GridDialog);
};

class SectionDialog  : public TMyDialog {
  public:
    SectionDialog(TWindow *parent,TResId resID,int x,int y,int lenx,int leny,
                struct objlist *obj,int idx,int idy,int idu,int idr,
                struct objlist *obj2,int *idg,int section);
    ~SectionDialog();
  protected:
    int Section;
    int X,Y,LenX,LenY,X0,Y0,LenX0,LenY0;
    int IDX,IDY,IDU,IDR,*IDG;
    struct objlist *Obj,*Obj2;
    TStatic *OX,*OY,*OU,*OR,*OG;
    void SetupWindow() {
      TMyDialog::SetupWindow();
      SetupItem();
    }
    void SetupItem();
    void AxisXClicked();
    void AxisYClicked();
    void AxisUClicked();
    void AxisRClicked();
    void GridClicked();
    void CloseWindow(int retVal);
    void DeleteClicked() {CloseWindow(IDDELETE);}
    void EvHScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl);
    void EvVScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl);
    DECLARE_RESPONSE_TABLE(SectionDialog);
};

class CrossDialog  : public TMyDialog {
  public:
    CrossDialog(TWindow *parent,TResId resID,int x,int y,int lenx,int leny,
                struct objlist *obj,int idx,int idy);
    ~CrossDialog();
  protected:
    int X,Y,LenX,LenY,X0,Y0,LenX0,LenY0;
    int IDX,IDY;
    struct objlist *Obj;
    TStatic *OX,*OY;
    void SetupWindow() {
      TMyDialog::SetupWindow();
      SetupItem();
    }
    void SetupItem();
    void AxisXClicked();
    void AxisYClicked();
    void CloseWindow(int retVal);
    void DeleteClicked() {CloseWindow(IDDELETE);}
    void EvHScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl);
    void EvVScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl);
    DECLARE_RESPONSE_TABLE(CrossDialog);
};

class TAxisWindow : public TSubWindow {
  public:
    TAxisWindow(TWindow* parent=0);
    ~TAxisWindow();
    void SelectAxis(HDC dc,int sel);
    void Update(int clear);
    void ChangeAxisNum();
  protected:
    void SetupWindow();
    TPopupMenu PopupMenu;
    int select;
    int axisnum;
    COLORREF col1,col1h;
    COLORREF col2;
    HBRUSH brush1;
    HBRUSH brush2;
    HPEN pen1;
    HPEN pen2;
    struct objlist *obj;
    void EvPaint();
    void ScaleClear();
    void AxisDelete();
    void AxisCopy();
    void AxisTop();
    void AxisLast();
    void AxisUp();
    void AxisDown();
    void AxisUpdate();
    void AxisSelect();
    void AxisHidden();
    void EvSize(UINT sizeType, TSize& size);
    void EvLButtonDown(UINT,TPoint& size);
    void EvRButtonDown(UINT modKeys, TPoint& point);
    void EvLButtonDblClk(UINT,TPoint& size);
    void EvKeyDown(UINT key,UINT repeatCount,UINT flags);
    DECLARE_RESPONSE_TABLE(TAxisWindow);
};


