/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 * wincood.cpp
 *
 */

#include <owl\pch.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

extern "C" {
#include "ngraph.h"
#include "object.h"
#include "nstring.h"
#include "ioutil.h"
#include "owinmenu.h"
}

#include "bitmap.rh"
#include "winmenu.rh"
#include "winmenu.h"

DEFINE_RESPONSE_TABLE1(TCoordWindow, TSubWindow)
  EV_WM_PAINT,
  EV_WM_KEYDOWN,
END_RESPONSE_TABLE;

TCoordWindow::TCoordWindow(TWindow *parent):TSubWindow(parent)
{
  menulocal.coordopen=TRUE;
  str=NULL;
  col1=GetSysColor(COLOR_WINDOWTEXT);
  brush1=CreateSolidBrush(GetSysColor(COLOR_WINDOW));
}

void TCoordWindow::SetupWindow()
{
  TSubWindow::SetupWindow();
}

TCoordWindow::~TCoordWindow()
{
  menulocal.coordopen=FALSE;
  memfree(str);
  DeleteObject(brush1);
  NgraphApp->DeleteCoordWindow();
}

void TCoordWindow::SetCoord(int x,int y)
{
  struct objlist *obj;
  int i,j,num;
  double d;
  char *argv[3];
  TClientDC dc(Handle);
  RECT rect;
  char *name;

  memfree(str);
  obj=chkobject("axis");
  if (obj!=NULL) {
    num=chkobjlastinst(obj)+1;
    str=(char *)memalloc(45*(num+1));
    if (str!=NULL) {
      j=0;
      j+=sprintf(str+j,"(X:%d  Y:%d)\n",x,y);
      argv[0]=(char *)&x;
      argv[1]=(char *)&y;
      argv[2]=NULL;
      for (i=0;i<num;i++) {
        getobj(obj,"group",i,0,NULL,&name);
        if (getobj(obj,"coordinate",i,2,argv,&d)!=-1) {
          j+=sprintf(str+j,"%d %5s %+.7e\n",i,name,d);
        }
      }
    }
  }
  ::GetClientRect(Handle,&rect);
  ::FillRect(dc,&rect,brush1);
  DrawText(dc);
}

void TCoordWindow::Update(int clear)
{
  Invalidate();
}

void TCoordWindow::DrawText(HDC dc)
{
  int x,y,len,j,k;
  HFONT orgfont;

  if (str==NULL) return;
  orgfont=(HFONT)SelectObject(dc,menulocal.menufont);
  ::SetTextAlign(dc,TA_BOTTOM | TA_LEFT);
  ::SetTextColor(dc,col1);
  SetBkMode(dc,TRANSPARENT);
  x=NgraphApp->FWidth;
  y=NgraphApp->FHeight;
  len=0;
  j=k=0;
  while (TRUE) {
    if (str[j]=='\0') {
      TextOut(dc,x,y,str+k,len);
      k=j+1;
      len=0;
      break;
    } else if (str[j]=='\n') {
      TextOut(dc,x,y,str+k,len);
      k=j+1;
      len=0;
      y+=NgraphApp->FHeight;
    } else len++;
    j++;
  }
  SelectObject(dc,orgfont);
}

void TCoordWindow::EvPaint()
{
  PAINTSTRUCT ps;
  HDC dc;
  RECT rc;

  if (::GetUpdateRect(Handle,&rc,FALSE)) {
    dc=::BeginPaint(*this,&ps);
    DrawText(dc);
    ::EndPaint(Handle,&ps);
  }
}

void TCoordWindow::EvKeyDown(UINT key,UINT repeatCount,UINT flags)
{

  if (menulock || globallock) return;
  switch (key) {
  default:
    NgraphApp->EvKeyDown2(key,repeatCount,flags);
    break;
  }
  TWindow::EvKeyDown(key,repeatCount,flags);
}

void TMyWindow::CmWindowCoord()
{
  TCoordWindow *win;
  TRect rect;
  int x,y;

  if (menulock || globallock) return;
  if (pTCoordWindow==NULL) {
    win=(TCoordWindow *)pTCoordWindow=new TCoordWindow();
    win->Frame=new TSubFrameWindow(this,"Coordinate Window",win,
    &menulocal.coordx,&menulocal.coordy,&menulocal.coordwidth,&menulocal.coordheight);
    win->Frame->SetIcon(GetApplication(),ICON_8);
    NgraphApp->Frame->GetWindowRect(rect);
    x=rect.left;
    y=rect.top;
    if (menulocal.coordwidth==CW_USEDEFAULT) win->Frame->Attr.W=FWidth*25;
    else win->Frame->Attr.W=menulocal.coordwidth;
    if (menulocal.coordheight==CW_USEDEFAULT) win->Frame->Attr.H=FHeight*6;
    else win->Frame->Attr.H=menulocal.coordheight;
    if (menulocal.coordx==CW_USEDEFAULT) win->Frame->Attr.X=CW_USEDEFAULT;
    else {
      win->Frame->Attr.X=menulocal.coordx+x;
      if (win->Frame->Attr.X<0) win->Frame->Attr.X=0;
    }
    if (menulocal.coordy==CW_USEDEFAULT) win->Frame->Attr.X=CW_USEDEFAULT;
    else {
      win->Frame->Attr.Y=menulocal.coordy+y;
      if (win->Frame->Attr.Y<0) win->Frame->Attr.Y=0;
    }
	win->Frame->Create();
  } else {
    win=(TCoordWindow *)pTCoordWindow;
    win->CloseWindow();
  }
}

void TMyWindow::CeWindowCoord(TCommandEnabler& ce)
{
  if (pTCoordWindow==NULL) ce.SetCheck(TCommandEnabler::Unchecked);
  else ce.SetCheck(TCommandEnabler::Checked);
}


