/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 *  windialg.cpp
 *
 */
#include <owl\pch.h>

extern "C" {
#include "ngraph.h"
#include "object.h"
#include "odraw.h"
}

#include "winmenu.rh"
#include "owinmenu.h"
#include "winmenu.h"
#include "windialg.h"

char *fwlinestyle[CLINESTYLE]={"solid","dot","short dash","dash","dot dash",
                               "2-dot dash","dot 2-dash"};
char *fwnumstyle[CNUMSTYLE]={"auto","0","1","2","3","4","5","6","7","8","9"};
int fwlinestylelistn[CLINESTYLE]={0,2,2,2,4,6,6};
char *fwlinestylelist[CLINESTYLE]={"","100 100","150 150","450 150","450 150 150 150",
                                   "450 150 150 150 150 150","450 150 450 150 150 150"};
char *cblinewidth[CBLINEWIDTH]={"10","20","40","80","120"};
char *cbtextpt[CBTEXTPT]={"1200","1600","1800","2000","2400","3000"};
char *cbdirection[CBDIRECTION]={"0","9000","18000","27000"};
char *cbmarksize[CBMARKSIZE]={"100","200","300","400","500"};

TMyDialog::TMyDialog(TWindow *parent,TResId resID):TDialog(parent,resID)
{
  Parent=parent;
}

TMyDialog::~TMyDialog()
{
}

int TMyDialog::Execute()
{
  int ret;

  NgraphApp->EnableFrameWindow(Parent,false);
  ret=TDialog::Execute();
  NgraphApp->EnableFrameWindow(Parent,true);
  return ret;
}

PrmDialog::PrmDialog(TWindow *parent,TResId resID,struct objlist *obj,int id)
:TMyDialog(parent,resID)
{
  Obj=obj;
  Id=id;
}

void PrmDialog::SetupWindow()
{
  int a;

  TMyDialog::SetupWindow();
  getobj(Obj,"ignore_path",Id,0,NULL,&a);
  if (a) SendDlgItemMessage(IDPPATH,BM_SETCHECK,1,0);
  else SendDlgItemMessage(IDPPATH,BM_SETCHECK,0,0);
  getobj(Obj,"symbol_greek",Id,0,NULL,&a);
  if (a) SendDlgItemMessage(IDPGREEK,BM_SETCHECK,1,0);
  else SendDlgItemMessage(IDPGREEK,BM_SETCHECK,0,0);
}

void PrmDialog::CloseWindow(int retVal)
{
  int a;

  if (retVal!=IDOK) {
    TMyDialog::CloseWindow(retVal);
    return;
  }
  a=SendDlgItemMessage(IDPPATH,BM_GETCHECK,0,0);
  if (a!=2) {
    if (putobj(Obj,"ignore_path",Id,&a)==-1) return;
  }
  a=SendDlgItemMessage(IDPGREEK,BM_GETCHECK,0,0);
  if (a!=2) {
    if (putobj(Obj,"symbol_greek",Id,&a)==-1) return;
  }
  TMyDialog::CloseWindow(retVal);
}

void SaveDialog::SetupWindow()
{
  char **enumlist;
  int j;

  TMyDialog::SetupWindow();
  SendDlgItemMessage(IDSVPATH,CB_RESETCONTENT,0,0);
  enumlist=pathchar;
  for (j=0;enumlist[j]!=NULL;j++)
    SendDlgItemMessage(IDSVPATH,CB_INSERTSTRING,j,(LPARAM)enumlist[j]);
  SendDlgItemMessage(IDSVPATH,CB_SETCURSEL,menulocal.savepath,0);
  SendDlgItemMessage(IDSVDATA,BM_SETCHECK,menulocal.savewithdata,0);
  SendDlgItemMessage(IDSVMERGE,BM_SETCHECK,menulocal.savewithmerge,0);
}

void SaveDialog::CloseWindow(int retVal)
{
  Path=SendDlgItemMessage(IDSVPATH,CB_GETCURSEL,0,0);
  if (Path==CB_ERR) Path=0;
  *SaveData=SendDlgItemMessage(IDSVDATA,BM_GETCHECK,0,0);
  *SaveMerge=SendDlgItemMessage(IDSVMERGE,BM_GETCHECK,0,0);
  TMyDialog::CloseWindow(retVal);
}

DEFINE_RESPONSE_TABLE1(SelEdit,TEdit)
  EV_NOTIFY_AT_CHILD(EN_SETFOCUS,GetFocus),
END_RESPONSE_TABLE;

void SelEdit::GetFocus()
{
  SetSelection(0,-1);
}

DEFINE_RESPONSE_TABLE1(ColorButton,TButton)
  EV_NOTIFY_AT_CHILD(BN_CLICKED,BNClicked),
  EV_WM_DRAWITEM,
END_RESPONSE_TABLE;

void ColorButton::EvDrawItem(UINT ctrlId,DRAWITEMSTRUCT far& draw)
{
  int i,shift;
  HBRUSH brush;
  RECT rect;

  TButton::EvDrawItem(ctrlId,draw);
  brush=CreateSolidBrush(GetSysColor(COLOR_MENU));
  rect.left=draw.rcItem.left;
  rect.top=draw.rcItem.top;
  rect.right=draw.rcItem.right;
  rect.bottom=draw.rcItem.bottom;
  FillRect(draw.hDC,&rect,brush);
  DeleteObject(brush);
  if (draw.itemState & ODS_SELECTED) {
    brush=CreateSolidBrush(GetSysColor(COLOR_3DSHADOW));
    shift=1;
  } else {
    brush=CreateSolidBrush(GetSysColor(COLOR_3DHILIGHT));
    shift=0;
  }
  rect.left=draw.rcItem.left+1;
  rect.top=draw.rcItem.top+1;
  rect.right=draw.rcItem.left+2;
  rect.bottom=draw.rcItem.bottom;
  FillRect(draw.hDC,&rect,brush);
  rect.left=draw.rcItem.left+1;
  rect.top=draw.rcItem.top+1;
  rect.right=draw.rcItem.right;
  rect.bottom=draw.rcItem.top+2;
  FillRect(draw.hDC,&rect,brush);
  DeleteObject(brush);

  if (draw.itemState & ODS_DISABLED) {
    brush=CreateSolidBrush(GetSysColor(COLOR_GRAYTEXT));
  } else {
    brush=CreateSolidBrush(GetSysColor(COLOR_WINDOWTEXT));
  }
  rect.left=draw.rcItem.left+4+shift;
  rect.top=draw.rcItem.top+4+shift;
  rect.right=draw.rcItem.right-4+shift;
  rect.bottom=draw.rcItem.bottom-4+shift;
  FillRect(draw.hDC,&rect,brush);
  DeleteObject(brush);
  brush=CreateSolidBrush(RGB(R,G,B));
  rect.left=draw.rcItem.left+6+shift;
  rect.top=draw.rcItem.top+6+shift;
  rect.right=draw.rcItem.right-6+shift;
  rect.bottom=draw.rcItem.bottom-6+shift;
  FillRect(draw.hDC,&rect,brush);
  DeleteObject(brush);
  brush=CreateSolidBrush(GetSysColor(COLOR_3DSHADOW));
  for (i=1;i<3-shift;i++) {
    rect.left=draw.rcItem.right-i;
    rect.top=draw.rcItem.top+i;
    rect.right=draw.rcItem.right-i+1;
    rect.bottom=draw.rcItem.bottom;
    FillRect(draw.hDC,&rect,brush);
  }
  for (i=1;i<3-shift;i++) {
    rect.left=draw.rcItem.left+i;
    rect.top=draw.rcItem.bottom-i;
    rect.right=draw.rcItem.right;
    rect.bottom=draw.rcItem.bottom-i+1;
    FillRect(draw.hDC,&rect,brush);
  }
  DeleteObject(brush);
}

void ColorButton::BNClicked()
{
  TColor Color(RGB(R,G,B));

  TChooseColorDialog::TData choose;
  choose.Flags=CC_RGBINIT;
  choose.Color=Color;
  choose.CustColors=NgraphApp->custColors;
  if (TChooseColorDialog(this,choose).Execute()==IDOK) {
    R=choose.Color.Red();
    G=choose.Color.Green();
    B=choose.Color.Blue();
  }
}

void ColorButton::SetColor(int r,int g,int b)
{
  R=r;
  G=g;
  B=b;
}

void ColorButton::GetColor(int *r,int *g,int *b)
{
  *r=R;
  *g=G;
  *b=B;
}

DEFINE_RESPONSE_TABLE1(CopyDialog,TMyDialog)
  EV_LBN_DBLCLK(IDCLIST,CmOk),
END_RESPONSE_TABLE;

CopyDialog::CopyDialog(TWindow *parent,TResId resID,struct objlist *obj,int id,
                       char *(*callback)(struct objlist *obj,int id))
:TMyDialog(parent,resID)
{
  Obj=obj;
  Id=id;
  sel=id;
  cb=callback;
}

void CopyDialog::SetupWindow()
{
  int i;
  char *s;

  TMyDialog::SetupWindow();
  SendDlgItemMessage(IDCLIST,LB_RESETCONTENT,0,0);
  for (i=0;i<=chkobjlastinst(Obj);i++) {
    s=cb(Obj,i);
    if (s!=NULL) SendDlgItemMessage(IDCLIST,LB_INSERTSTRING,-1,(LPARAM)s);
    else SendDlgItemMessage(IDCLIST,LB_INSERTSTRING,-1,(LPARAM)"");
    memfree(s);
  }
  if (Id>=0) SendDlgItemMessage(IDCLIST,LB_SETCURSEL,Id,0);
}

void CopyDialog::CloseWindow(int retValue)
{
  sel=SendDlgItemMessage(IDCLIST,LB_GETCURSEL,0,0);
  TMyDialog::CloseWindow(retValue);
}

DEFINE_RESPONSE_TABLE1(SelectDialog,TMyDialog)
  EV_LBN_DBLCLK(IDCLIST,CmOk),
  EV_CHILD_NOTIFY(IDSALL,BN_CLICKED,SelectAll),
END_RESPONSE_TABLE;

SelectDialog::SelectDialog(TWindow *parent,TResId resID,
                         struct objlist *obj,
                         char *(*callback)(struct objlist *obj,int id),
                         struct narray *array,struct narray *iarray)
:TMyDialog(parent,resID)
{
  Obj=obj;
  cb=callback;
  arrayinit(array,sizeof(int));
  sel=array;
  isel=iarray;
}

void SelectDialog::SetupWindow()
{
  int i,*seldata,selnum;
  char *s;

  TMyDialog::SetupWindow();
  SendDlgItemMessage(IDCLIST,LB_RESETCONTENT,0,0);
  for (i=0;i<=chkobjlastinst(Obj);i++) {
    s=cb(Obj,i);
    if (s!=NULL) SendDlgItemMessage(IDCLIST,LB_INSERTSTRING,-1,(LPARAM)s);
    else SendDlgItemMessage(IDCLIST,LB_INSERTSTRING,-1,(LPARAM)"");
    memfree(s);
  }
  if (isel!=NULL) {
    seldata=(int *)arraydata(isel);
    selnum=arraynum(isel);
    for (i=0;i<selnum;i++)
      SendDlgItemMessage(IDCLIST,LB_SETSEL,TRUE,seldata[i]);
  }
}

void SelectDialog::CloseWindow(int retValue)
{
  int i;

  if ((retValue==IDOK) || (retValue==IDSALL)) {
    for (i=0;i<=chkobjlastinst(Obj);i++)
      if (SendDlgItemMessage(IDSLIST,LB_GETSEL,i,0)>0) arrayadd(sel,&i);
    retValue=IDOK;
  }
  TMyDialog::CloseWindow(retValue);
}

void SelectDialog::SelectAll()
{
  SendDlgItemMessage(IDSLIST,LB_SETSEL,TRUE,-1);
  CloseWindow(IDSALL);
}




int CopyClick(TWindow *parent,struct objlist *obj,int Id,
              char *(*callback)(struct objlist *obj,int id))
{
  CopyDialog *dlg;
  int sel;

  dlg=new CopyDialog(parent,DIALOG_COPY,obj,Id,callback);
  if (dlg->Execute()==IDOK) sel=dlg->sel;
  else sel=-1;
  delete dlg;
  return sel;
}

int SetObjFieldFromText(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field)
{
  int len;
  char *buf;

  len=SendDlgItemMessage(hWnd,idControl,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(hWnd,idControl,buf,len+1);
    if (sputobjfield(Obj,Id,field,buf)!=0) {
      memfree(buf);
      return -1;
    }
    memfree(buf);
  }
  return 0;
}

void SetTextFromObjField(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field)
{
  char *buf;

  sgetobjfield(Obj,Id,field,NULL,&buf,FALSE,FALSE,FALSE);
  SetDlgItemText(hWnd,idControl,buf);
  memfree(buf);
}

int SetObjFieldFromToggle(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field)
{
  int a;

  a=SendDlgItemMessage(hWnd,idControl,BM_GETCHECK,0,0);
  if (a!=2) {
    if (putobj(Obj,field,Id,&a)==-1) return -1;
  }
  return 0;
}

void SetToggleFromObjField(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field)
{
  int a;

  getobj(Obj,field,Id,0,NULL,&a);
  if (a) SendDlgItemMessage(hWnd,idControl,BM_SETCHECK,1,0);
  else SendDlgItemMessage(hWnd,idControl,BM_SETCHECK,0,0);
}

int SetObjFieldFromStyle(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field)
{
  int j,len;
  char *buf;

  len=SendDlgItemMessage(hWnd,idControl,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(hWnd,idControl,buf,len+1);
    for (j=0;j<CLINESTYLE;j++)
      if (strcmp(buf,fwlinestyle[j])==0) {
        if (sputobjfield(Obj,Id,field,fwlinestylelist[j])!=0) {
          memfree(buf);
          return -1;
        }
        break;
      }
    if (j==CLINESTYLE) {
      if (sputobjfield(Obj,Id,field,buf)!=0) {
        memfree(buf);
        return -1;
      }
    }
    memfree(buf);
  }
  return 0;
}

void SetStyleFromObjField(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field)
{
  int i,j;
  struct narray *array;
  int stylenum;
  int *style,a;
  char *s;

  SendDlgItemMessage(hWnd,idControl,CB_RESETCONTENT,0,0);
  for (j=0;j<CLINESTYLE;j++)
    SendDlgItemMessage(hWnd,idControl,CB_INSERTSTRING,j,(LPARAM)fwlinestyle[j]);
  getobj(Obj,field,Id,0,NULL,&array);
  stylenum=arraynum(array);
  style=(int *)arraydata(array);
  for (j=0;j<CLINESTYLE;j++) {
    if (stylenum==fwlinestylelistn[j]) {
      s=fwlinestylelist[j];
      for (i=0;i<fwlinestylelistn[j];i++) {
        a=strtol(s,&s,10);
        if (style[i]!=a) break;
      }
      if (i==fwlinestylelistn[j]) goto match;
    }
  }
  SetTextFromObjField(hWnd,idControl,Obj,Id,field);
  return;
match:
  SendDlgItemMessage(hWnd,idControl,CB_SETCURSEL,j,0);
}

int SetObjFieldFromList(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field)
{
  int a;

  a=SendDlgItemMessage(hWnd,idControl,CB_GETCURSEL,0,0);
  if (a!=CB_ERR) {
    if (putobj(Obj,field,Id,&a)==-1) return -1;
  }
  return 0;
}

void SetListFromObjField(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field)
{
  char **enumlist;
  int j,a;

  SendDlgItemMessage(hWnd,idControl,CB_RESETCONTENT,0,0);
  enumlist=(char **)chkobjarglist(Obj,field);
  for (j=0;enumlist[j]!=NULL;j++)
    SendDlgItemMessage(hWnd,idControl,CB_INSERTSTRING,j,(LPARAM)enumlist[j]);
  getobj(Obj,field,Id,0,NULL,&a);
  SendDlgItemMessage(hWnd,idControl,CB_SETCURSEL,a,0);
}

void SetComboList(HWND hWnd,int idControl,char **list,int num)
{
  int j;

  SendDlgItemMessage(hWnd,idControl,CB_RESETCONTENT,0,0);
  for (j=0;j<num;j++)
    SendDlgItemMessage(hWnd,idControl,CB_INSERTSTRING,j,(LPARAM)list[j]);
}
