/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 *  windialg.h
 *
 */

#define CLINESTYLE 7
#define CNUMSTYLE 11
extern char *fwlinestyle[CLINESTYLE];
extern char *fwnumstyle[CNUMSTYLE];
extern int fwlinestylelistn[CLINESTYLE];
extern char *fwlinestylelist[CLINESTYLE];
extern char fwbuf[100][10];
#define CBLINEWIDTH 5
extern char *cblinewidth[CBLINEWIDTH];
#define CBTEXTPT 6
extern char *cbtextpt[CBTEXTPT];
#define CBDIRECTION 4
extern char *cbdirection[CBDIRECTION];
#define CBMARKSIZE 5
extern char *cbmarksize[CBMARKSIZE];

int CopyClick(TWindow *parent,struct objlist *obj,int Id,
              char *(*callback)(struct objlist *obj,int id));
int SetObjFieldFromText(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field);
void SetTextFromObjField(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field);
int SetObjFieldFromToggle(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field);
void SetToggleFromObjField(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field);
int SetObjFieldFromStyle(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field);
void SetStyleFromObjField(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field);
int SetObjFieldFromList(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field);
void SetListFromObjField(HWND hWnd,int idControl,struct objlist *Obj,int Id,char *field);
void SetComboList(HWND hWnd,int idControl,char **list,int num);

class TMyDialog  : public TDialog {
  public:
    TMyDialog(TWindow *parent,TResId resID);
    ~TMyDialog();
    int Execute();
  protected:
    TWindow *Parent;
    DECLARE_RESPONSE_TABLE(TMyDialog);
};

class PrmDialog  : public TMyDialog {
  public:
    PrmDialog(TWindow *parent,TResId resID,struct objlist *obj,int id);
  protected:
    struct objlist *Obj;
    int Id;
    void SetupWindow();
    void CloseWindow(int retVal);
};

class SaveDialog  : public TMyDialog {
  public:
    SaveDialog(TWindow *parent,TResId resID,int *sdata,int *smerge):TMyDialog(parent,resID) {
      SaveData=sdata;
      SaveMerge=smerge;
    }
    int Path;
  protected:
    int *SaveData,*SaveMerge;
    void SetupWindow();
    void CloseWindow(int retVal);
};

class SelEdit : public TEdit {
  public:
    SelEdit(TWindow *parent,int resId) : TEdit(parent,resId) {}
  protected:
    void GetFocus();
    DECLARE_RESPONSE_TABLE(SelEdit);
};

class ColorButton : public TButton {
  public:
    ColorButton(TWindow *parent,int resId) : TButton(parent,resId) {}
    void SetColor(int r,int g,int b);
    void GetColor(int *r,int *g,int *b);
  protected:
    int R,G,B;
    void EvDrawItem(UINT ctrlId,DRAWITEMSTRUCT far& draw);
    void BNClicked();
    DECLARE_RESPONSE_TABLE(ColorButton);
};

class MarkComboBox : public TComboBox {
  public:
    MarkComboBox(TWindow *parent,int resId) : TComboBox(parent,resId) {}
  protected:
    void EvDrawItem(UINT ctrlId,DRAWITEMSTRUCT far& draw);
    DECLARE_RESPONSE_TABLE(MarkComboBox);
};

class AxisComboBox : public TComboBox {
  public:
    AxisComboBox(TWindow *parent,int resId) : TComboBox(parent,resId) {}
  protected:
    void EvDrawItem(UINT ctrlId,DRAWITEMSTRUCT far& draw);
    DECLARE_RESPONSE_TABLE(AxisComboBox);
};

class CopyDialog  : public TMyDialog {
  public:
    CopyDialog(TWindow *parent,TResId resID,struct objlist *obj,int id,
               char *(*callback)(struct objlist *obj,int id));
    int sel;
  protected:
    struct objlist *Obj;
    int Id;
    char *(*cb)(struct objlist *obj,int id);
    void SetupWindow();
    void CloseWindow(int retValue=IDCANCEL);
    DECLARE_RESPONSE_TABLE(CopyDialog);
};

class SelectDialog  : public TMyDialog {
  public:
    SelectDialog(TWindow *parent,TResId resID,
                 struct objlist *obj,
                 char *(*callback)(struct objlist *obj,int id),
                 struct narray *array,struct narray *iarray);
  protected:
    struct narray *sel,*isel;
    struct objlist *Obj;
    char *Field;
    char *(*cb)(struct objlist *obj,int id);
    void SetupWindow();
    void CloseWindow(int retValue=IDCANCEL);
    void SelectAll();
    DECLARE_RESPONSE_TABLE(SelectDialog);
};
