/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 *  winfile.h
 *
 */

struct evaltype {
  int id;
  int line;
  double x,y;
};

extern struct evaltype evallist[100];

class FileDialog  : public TMyDialog {
  public:
    FileDialog(TWindow *parent,TResId resID,struct objlist *obj,int id);
    ~FileDialog();
  protected:
    struct objlist *Obj;
    int Id;
    ColorButton *Col1,*Col2;
    MarkComboBox *Mark;
    AxisComboBox *AxisX,*AxisY;
    TStatic *Fit;
    void SetupWindow();
    void SetupItem(int file,int id);
    void CopyClicked() {
      int sel;
      if ((sel=CopyClick(this,Obj,Id,FileCB))!=-1) SetupItem(FALSE,sel);
    }
    void CopyAllClicked();
    void MathClicked();
    void LoadClicked();
    void EditClicked();
    void FitClicked();
    void CloseWindow(int retVal);
    void DeleteClicked();
    void ApplyClicked();
    void MaskClicked();
    void MoveClicked();
    void OptionClicked();
    void TypeChanged();
    DECLARE_RESPONSE_TABLE(FileDialog);
};

class FileDefDialog  : public TMyDialog {
  public:
    FileDefDialog(TWindow *parent,TResId resID,struct objlist *obj,int id);
    ~FileDefDialog();
  protected:
    struct objlist *Obj;
    int Id;
    ColorButton *Col1,*Col2;
    MarkComboBox *Mark;
    AxisComboBox *AxisX,*AxisY;
    void SetupWindow();
    void SetupItem(int id);
    void MathClicked();
    void LoadClicked();
    void CloseWindow(int retVal);
    DECLARE_RESPONSE_TABLE(FileDefDialog);
};

class TFileWindow : public TSubWindow {
  public:
    TFileWindow(TWindow* parent=0);
    ~TFileWindow();
    void SelectFile(HDC dc,int sel);
    void Update(int clear);
    void ChangeFileNum();
  protected:
    void SetupWindow();
    TPopupMenu PopupMenu;
    int select;
    int filenum;
    COLORREF col1,col1h,col1d;
    COLORREF col2;
    HBRUSH brush1;
    HBRUSH brush2;
    HPEN pen1;
    HPEN pen2;
    struct objlist *obj;
    void EvSize(UINT sizeType, TSize& size);
    void EvLButtonDown(UINT,TPoint& size);
    void EvRButtonDown(UINT modKeys, TPoint& point);
    void EvLButtonDblClk(UINT,TPoint& size);
    void EvKeyDown(UINT key,UINT repeatCount,UINT flags);
    void EvPaint();
    void FileOpen();
    void FileEdit();
    void FileDelete();
    void FileCopy();
    void FileCopy2();
    void FileUpdate();
    void FileUp();
    void FileDown();
    void FileDraw();
    void FileHidden();
    void FileTop();
    void FileLast();
    void FileFit();
	DECLARE_RESPONSE_TABLE(TFileWindow);
};
