/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 * winfopen.c
 *
 */

#include <windows.h>
#include <mem.h>

#include "winfopen.h"

extern HINSTANCE hInstance;
const char szmsgSHAREVIOLATION[] = SHAREVISTRING;  // string for sharing violation
const char szmsgFILEOK[]         = FILEOKSTRING;   // string for OK button
const char szCommdlgHelp[]       = HELPMSGSTRING;  // string for Help button
UINT cdmsgShareViolation = 0;  // identifier from RegisterWindowMessage
UINT cdmsgFileOK         = 0;  // identifier from RegisterWindowMessage
UINT cdmsgHelp           = 0;  // identifier from RegisterWindowMessage

struct nGetOpenFileData {
  int ChDir;
  int More;
} nGetOpenFileData;

BOOL NEAR PASCAL nGetOpenFileNotify(HWND hDlg, LPOFNOTIFY pofn)
{
  switch (pofn->hdr.code) {
    case CDN_HELP:
	break;
	case CDN_FILEOK:
	break;
	case CDN_SHAREVIOLATION:
	break;
  }
  return TRUE;
}

unsigned int CALLBACK nGetOpenFileProc(HWND hwndDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
  switch (uMsg) {
  case WM_INITDIALOG:
    nGetOpenFileData.More=FALSE;
    if (nGetOpenFileData.ChDir) SendDlgItemMessage(hwndDlg,1500,BM_SETCHECK,1,0);
    else SendDlgItemMessage(hwndDlg,1500,BM_SETCHECK,0,0);
    break;
  case WM_DESTROY:
    nGetOpenFileData.ChDir=SendDlgItemMessage(hwndDlg,1500,BM_GETCHECK,0,0);
    if (GetAsyncKeyState(VK_CONTROL) & 0x8000) nGetOpenFileData.More=TRUE;
    break;
  case WM_NOTIFY:
  	nGetOpenFileNotify(hwndDlg,(LPOFNOTIFY)lParam);
    break;
  default:
//	if (uMsg==cdmsgFileOK) {
//      break;
//   	} else if (uMsg == cdmsgShareViolation) {
//      break;
//	}
    break;
  }
  return FALSE;
}

// #define OFN_ENABLESIZING 0x800000

typedef struct tagOFN {
    DWORD         lStructSize;
    HWND          hwndOwner;
    HINSTANCE     hInstance;
    LPCTSTR       lpstrFilter;
    LPTSTR        lpstrCustomFilter;
    DWORD         nMaxCustFilter;
    DWORD         nFilterIndex;
    LPTSTR        lpstrFile;
    DWORD         nMaxFile;
    LPTSTR        lpstrFileTitle;
    DWORD         nMaxFileTitle;
    LPCTSTR       lpstrInitialDir;
    LPCTSTR       lpstrTitle;
    DWORD         Flags;
    WORD          nFileOffset;
    WORD          nFileExtension;
    LPCTSTR       lpstrDefExt;
    LPARAM        lCustData;
    LPOFNHOOKPROC lpfnHook;
    LPCTSTR       lpTemplateName;
    void *        pvReserved;
    DWORD         dwReserved;
    DWORD         FlagsEx;
} OPENFILENAME2;

int nGetOpenFileNameMulti(HWND hWnd,char *title,char *defext,char **initdir,
                     char *filebuf,int bufmax,char *filter,int chdir)
{
  int ret,len;
  char *cwd,*cwd2;
  OPENFILENAME2 ofn;
  OSVERSIONINFO VersionInformation;

  VersionInformation.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
  GetVersionEx(&VersionInformation);
  len=GetCurrentDirectory(0,NULL);
  if ((cwd=malloc(len+1))!=NULL) {
    GetCurrentDirectory(len,cwd);
  }
  nGetOpenFileData.ChDir=chdir;
  ofn.lStructSize=sizeof(OPENFILENAME);
  ofn.hwndOwner=hWnd;
  ofn.hInstance=hInstance;
  ofn.lpstrFilter=filter;
  ofn.nFilterIndex=1L;
  ofn.lpstrCustomFilter=NULL;
  ofn.nMaxCustFilter=0L;
  ofn.lpstrFile=filebuf;
  ofn.nMaxFile=bufmax;
  ofn.lpstrFileTitle=NULL;
  ofn.nMaxFileTitle=0L;
  if (initdir==NULL) ofn.lpstrInitialDir=NULL;
  else ofn.lpstrInitialDir=*initdir;
  ofn.lpstrTitle=title;
  ofn.Flags= OFN_FILEMUSTEXIST | OFN_HIDEREADONLY
           | OFN_PATHMUSTEXIST | OFN_ALLOWMULTISELECT
           | OFN_ENABLEHOOK | OFN_ENABLETEMPLATE;
  if (VersionInformation.dwMajorVersion>=4) {
    ofn.Flags|=OFN_EXPLORER;
    if ((VersionInformation.dwPlatformId==VER_PLATFORM_WIN32_WINDOWS)
    && (VersionInformation.dwMinorVersion>0))
      ofn.Flags|=OFN_ENABLESIZING;
    if (VersionInformation.dwMajorVersion>=5) {
      ofn.Flags|=OFN_ENABLESIZING;
      ofn.lStructSize=sizeof(OPENFILENAME2);
      ofn.FlagsEx=0;
      ofn.pvReserved=NULL;
      ofn.dwReserved=0;
    }
  }
  ofn.nFileOffset=0;
  ofn.nFileExtension=0;
  ofn.lpstrDefExt=defext;
  ofn.lCustData=NULL;
  ofn.lpfnHook=(LPOFNHOOKPROC)nGetOpenFileProc;
  if (VersionInformation.dwMajorVersion>=4)
    ofn.lpTemplateName=MAKEINTRESOURCE(1548);
  else
    ofn.lpTemplateName=MAKEINTRESOURCE(1538);
  cdmsgShareViolation = RegisterWindowMessage(szmsgSHAREVIOLATION);
  cdmsgFileOK         = RegisterWindowMessage(szmsgFILEOK);
  cdmsgHelp           = RegisterWindowMessage(szCommdlgHelp);
  ret=GetOpenFileName((OPENFILENAME *)&ofn);
  if (ret) {
    if (initdir!=NULL) free(*initdir);
    len=GetCurrentDirectory(0,NULL);
    if (initdir!=NULL) {
      if ((cwd2=malloc(len))!=NULL) {
        GetCurrentDirectory(len,cwd2);
      }
      *initdir=cwd2;
    }
  }
  if ((cwd!=NULL) && (!nGetOpenFileData.ChDir)) SetCurrentDirectory(cwd);
  free(cwd);
  if ((ret==IDOK) && (nGetOpenFileData.More)) ret=3;
  return ret;
}

int nGetOpenFileName(HWND hWnd,char *title,char *defext,char **initdir,
                     char *filebuf,int bufmax,char *filter,int exist,int chdir)
{
  int ret,len;
  char *cwd,*cwd2;
  OPENFILENAME2 ofn;
  OSVERSIONINFO VersionInformation;

  VersionInformation.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
  GetVersionEx(&VersionInformation);
  len=GetCurrentDirectory(0,NULL);
  if ((cwd=malloc(len+1))!=NULL) {
    GetCurrentDirectory(len,cwd);
  }
  nGetOpenFileData.ChDir=chdir;
  ofn.lStructSize=sizeof(OPENFILENAME);
  ofn.hwndOwner=hWnd;
  ofn.hInstance=hInstance;
  ofn.lpstrFilter=filter;
  ofn.nFilterIndex=1L;
  ofn.lpstrCustomFilter=NULL;
  ofn.nMaxCustFilter=0L;
  ofn.lpstrFile=filebuf;
  ofn.nMaxFile=bufmax;
  ofn.lpstrFileTitle=NULL;
  ofn.nMaxFileTitle=0L;
  if (initdir==NULL) ofn.lpstrInitialDir=NULL;
  else ofn.lpstrInitialDir=*initdir;
  ofn.lpstrTitle=title;
  ofn.Flags=OFN_HIDEREADONLY | OFN_PATHMUSTEXIST
             | OFN_ENABLETEMPLATE | OFN_ENABLEHOOK;
  if (exist) ofn.Flags|=OFN_FILEMUSTEXIST;
  if (VersionInformation.dwMajorVersion>=4) {
    ofn.Flags|=OFN_EXPLORER;
    if ((VersionInformation.dwPlatformId==VER_PLATFORM_WIN32_WINDOWS)
    && (VersionInformation.dwMinorVersion>0))
      ofn.Flags|=OFN_ENABLESIZING;
    if (VersionInformation.dwMajorVersion>=5) {
      ofn.Flags|=OFN_ENABLESIZING;
      ofn.lStructSize=sizeof(OPENFILENAME2);
      ofn.FlagsEx=0;
      ofn.pvReserved=NULL;
      ofn.dwReserved=0;
    }
  }
  ofn.nFileOffset=0;
  ofn.nFileExtension=0;
  ofn.lpstrDefExt=defext;
  ofn.lCustData=0;
  ofn.lpfnHook=(LPOFNHOOKPROC)nGetOpenFileProc;
  if (VersionInformation.dwMajorVersion>=4)
    ofn.lpTemplateName=MAKEINTRESOURCE(1547);
  else
    ofn.lpTemplateName=MAKEINTRESOURCE(1537);
  cdmsgShareViolation = RegisterWindowMessage(szmsgSHAREVIOLATION);
  cdmsgFileOK         = RegisterWindowMessage(szmsgFILEOK);
  cdmsgHelp           = RegisterWindowMessage(szCommdlgHelp);
  ret=GetOpenFileName((OPENFILENAME *)&ofn);
  if (ret) {
    if (initdir!=NULL) free(*initdir);
    len=GetCurrentDirectory(0,NULL);
    if (initdir!=NULL) {
      if ((cwd2=malloc(len))!=NULL) {
        GetCurrentDirectory(len,cwd2);
      }
      *initdir=cwd2;
    }
  }
  if ((cwd!=NULL) && (!nGetOpenFileData.ChDir)) SetCurrentDirectory(cwd);
  free(cwd);
  return ret ? IDOK : IDCANCEL;
}

int nGetOpenFileName2(HWND hWnd,char *title,char *defext,
                     char *filebuf,int bufmax,char *filter)
{
  int ret;
  OPENFILENAME2 ofn;
  OSVERSIONINFO VersionInformation;

  VersionInformation.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
  GetVersionEx(&VersionInformation);
  ofn.lStructSize=sizeof(OPENFILENAME);
  ofn.hwndOwner=hWnd;
  ofn.hInstance=hInstance;
  ofn.lpstrFilter=filter;
  ofn.nFilterIndex=1L;
  ofn.lpstrCustomFilter=NULL;
  ofn.nMaxCustFilter=0L;
  ofn.lpstrFile=filebuf;
  ofn.nMaxFile=bufmax;
  ofn.lpstrFileTitle=NULL;
  ofn.nMaxFileTitle=0L;
  ofn.lpstrInitialDir=NULL;
  ofn.lpstrTitle=title;
  ofn.Flags=OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST
           |OFN_NOCHANGEDIR;
  if (VersionInformation.dwMajorVersion>=4) {
    ofn.Flags|=OFN_EXPLORER;
    if ((VersionInformation.dwPlatformId==VER_PLATFORM_WIN32_WINDOWS)
    && (VersionInformation.dwMinorVersion>0))
      ofn.Flags|=OFN_ENABLESIZING;
    if (VersionInformation.dwMajorVersion>=5) {
      ofn.Flags|=OFN_ENABLESIZING;
      ofn.lStructSize=sizeof(OPENFILENAME2);
      ofn.FlagsEx=0;
      ofn.pvReserved=NULL;
      ofn.dwReserved=0;
    }
  }
  ofn.nFileOffset=0;
  ofn.nFileExtension=0;
  ofn.lpstrDefExt=defext;
  ofn.lCustData=0;
  ofn.lpfnHook=NULL;
  ofn.lpTemplateName=0;
  ret=GetOpenFileName((OPENFILENAME *)&ofn);
  return ret ? IDOK : IDCANCEL;
}

int nGetSaveFileName(HWND hWnd,char *title,char *defext,char **initdir,
                     char *filebuf,int bufmax,char *filter,int chdir)
{
  int ret,len;
  char *cwd,*cwd2;
  OPENFILENAME2 ofn;
  OSVERSIONINFO VersionInformation;

  VersionInformation.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
  GetVersionEx(&VersionInformation);
  len=GetCurrentDirectory(0,NULL);
  if ((cwd=malloc(len+1))!=NULL) {
    GetCurrentDirectory(len,cwd);
  }
  nGetOpenFileData.ChDir=chdir;
  ofn.lStructSize=sizeof(OPENFILENAME);
  ofn.hwndOwner=hWnd;
  ofn.hInstance=hInstance;
  ofn.lpstrFilter=filter;
  ofn.nFilterIndex=1L;
  ofn.lpstrCustomFilter=NULL;
  ofn.nMaxCustFilter=0L;
  ofn.lpstrFile=filebuf;
  ofn.nMaxFile=bufmax;
  ofn.lpstrFileTitle=NULL;
  ofn.nMaxFileTitle=0L;
  if (initdir==NULL) ofn.lpstrInitialDir=NULL;
  else ofn.lpstrInitialDir=*initdir;
  ofn.lpstrTitle=title;
  ofn.Flags=OFN_HIDEREADONLY | OFN_ENABLETEMPLATE | OFN_ENABLEHOOK;
  if (VersionInformation.dwMajorVersion>=4) {
    ofn.Flags|=OFN_EXPLORER;
    if ((VersionInformation.dwPlatformId==VER_PLATFORM_WIN32_WINDOWS)
    && (VersionInformation.dwMinorVersion>0))
      ofn.Flags|=OFN_ENABLESIZING;
    if (VersionInformation.dwMajorVersion>=5) {
      ofn.Flags|=OFN_ENABLESIZING;
      ofn.lStructSize=sizeof(OPENFILENAME2);
      ofn.FlagsEx=0;
      ofn.pvReserved=NULL;
      ofn.dwReserved=0;
    }
  }
  ofn.nFileOffset=0;
  ofn.nFileExtension=0;
  ofn.lpstrDefExt=defext;
  ofn.lCustData=NULL;
  ofn.lpfnHook=(LPOFNHOOKPROC)nGetOpenFileProc;
  if (VersionInformation.dwMajorVersion>=4)
    ofn.lpTemplateName=MAKEINTRESOURCE(1547);
  else
    ofn.lpTemplateName=MAKEINTRESOURCE(1537);
  ret=GetSaveFileName((OPENFILENAME *)&ofn);
  if (ret) {
    if (initdir!=NULL) free(*initdir);
    len=GetCurrentDirectory(0,NULL);
    if (initdir!=NULL) {
      if ((cwd2=malloc(len))!=NULL) {
        GetCurrentDirectory(len,cwd2);
      }
      *initdir=cwd2;
    }
  }
  if ((cwd!=NULL) && (!nGetOpenFileData.ChDir)) SetCurrentDirectory(cwd);
  free(cwd);
  return ret ? IDOK : IDCANCEL;
}

