/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 * wingraph.cpp
 *
 */

#include <owl\pch.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <io.h>
#include <dir.h>

extern "C" {
#include "ngraph.h"
#include "object.h"
#include "ioutil.h"
#include "nstring.h"
#include "odraw.h"
#include "config.h"
#include "winfopen.h"
#include "owinmenu.h"
}

#include "bitmap.rh"
#include "winmenu.rh"
#include "winmenu.h"
#include "windialg.h"
#include "wincommn.h"
#include "winview.h"

#define PAGELISTNUM 12

struct pagelisttype {
  char *paper;
  int width;
  int height;
} pagelist[PAGELISTNUM]={
  {"A3 P (29700x42000)",29700,42000},
  {"A4 P (21000x29700)",21000,29700},
  {"A4 L (29700x21000)",29700,21000},
  {"A5 P (14800x21000)",14800,21000},
  {"A5 L (21000x14800)",21000,14800},
  {"B4 P (25700x36400)",25700,36400},
  {"B5 P (18200x25700)",18200,25700},
  {"B5 L (25700x18200)",25700,18200},
  {"Letter P (21590x27940)",21590,27940},
  {"Letter L (27940x21590)",27940,21590},
  {"Legal  P (21590x35560)",21590,35560},
  {"Legal  L (35560x35560)",35560,21590},
};



class PageDialog  : public TMyDialog {
  public:
    PageDialog(TWindow *parent,TResId resID);
  protected:
    void SetupWindow() {
      TMyDialog::SetupWindow();
      SetupItem();
    }
    void SetupItem();
    void CloseWindow(int retVal);
    void PaperSelected();
    DECLARE_RESPONSE_TABLE(PageDialog);
};

DEFINE_RESPONSE_TABLE1(PageDialog,TMyDialog)
  EV_CHILD_NOTIFY(IDPPAPER,CBN_SELCHANGE,PaperSelected),
END_RESPONSE_TABLE;

PageDialog::PageDialog(TWindow *parent,TResId resID):TMyDialog(parent,resID)
{
}

void PageDialog::SetupItem()
{
  int j;
  char buf[256];

  sprintf(buf,"%d",menulocal.LeftMargin);
  SetDlgItemText(IDPLEFTM,buf);
  sprintf(buf,"%d",menulocal.TopMargin);
  SetDlgItemText(IDPTOPM,buf);
  sprintf(buf,"%d",menulocal.PaperZoom);
  SetDlgItemText(IDPZOOM,buf);
  sprintf(buf,"%d",menulocal.PaperWidth);
  SetDlgItemText(IDPWIDTH,buf);
  sprintf(buf,"%d",menulocal.PaperHeight);
  SetDlgItemText(IDPHEIGHT,buf);
  SendDlgItemMessage(IDPPAPER,CB_RESETCONTENT,0,0);
  for (j=0;j<PAGELISTNUM;j++)
    SendDlgItemMessage(IDPPAPER,CB_INSERTSTRING,j,(LPARAM)pagelist[j].paper);
  for (j=0;j<PAGELISTNUM;j++)
    if ((menulocal.PaperWidth==pagelist[j].width)
     && (menulocal.PaperHeight==pagelist[j].height))
      break;
  SendDlgItemMessage(IDPPAPER,CB_SETCURSEL,j,0);
}

void PageDialog::CloseWindow(int retVal)
{
  int len,a;
  char *buf;
  char *endptr;

  if (retVal!=IDOK) {
    TMyDialog::CloseWindow(retVal);
    return;
  }
  len=SendDlgItemMessage(IDPLEFTM,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDPLEFTM,buf,len+1);
    a=strtol(buf,&endptr,10);
    if (endptr[0]=='\0') menulocal.LeftMargin=a;
    memfree(buf);
  }
  len=SendDlgItemMessage(IDPTOPM,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDPTOPM,buf,len+1);
    a=strtol(buf,&endptr,10);
    if (endptr[0]=='\0') menulocal.TopMargin=a;
    memfree(buf);
  }
  len=SendDlgItemMessage(IDPZOOM,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDPZOOM,buf,len+1);
    a=strtol(buf,&endptr,10);
    if (a<0) a=1;
    if (endptr[0]=='\0') menulocal.PaperZoom=a;
    memfree(buf);
  }
  len=SendDlgItemMessage(IDPWIDTH,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDPWIDTH,buf,len+1);
    a=strtol(buf,&endptr,10);
    if (a<0) a=1;
    if (endptr[0]=='\0') menulocal.PaperWidth=a;
    memfree(buf);
  }
  len=SendDlgItemMessage(IDPHEIGHT,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDPHEIGHT,buf,len+1);
    a=strtol(buf,&endptr,10);
    if (a<0) a=1;
    if (endptr[0]=='\0') menulocal.PaperHeight=a;
    memfree(buf);
  }
  TMyDialog::CloseWindow(retVal);
}

void PageDialog::PaperSelected()
{
  int a;
  char buf[256];

  a=SendDlgItemMessage(IDPPAPER,CB_GETCURSEL,0,0);
  if ((a!=CB_ERR) && (a<PAGELISTNUM)) {
    sprintf(buf,"%d",pagelist[a].width);
    SetDlgItemText(IDPWIDTH,buf);
    sprintf(buf,"%d",pagelist[a].height);
    SetDlgItemText(IDPHEIGHT,buf);
  }
}

class SwitchDialog  : public TMyDialog {
  public:
    SwitchDialog(TWindow *parent,TResId resID):TMyDialog(parent,resID) {
      arrayinit(&drawrable,sizeof(char *));
      arrayinit(&idrawrable,sizeof(int));
    }
    ~SwitchDialog() {
      arraydel2(&drawrable);
      arraydel(&idrawrable);
    }
  protected:
    struct narray drawrable;
    struct narray idrawrable;
    void SetupWindow();
    void CloseWindow(int retVal);
    void AddClicked();
    void InsertClicked();
    void TopClicked();
    void LastClicked();
    void RemoveClicked();
    void SetupItem();
    DECLARE_RESPONSE_TABLE(SwitchDialog);
};

DEFINE_RESPONSE_TABLE1(SwitchDialog,TMyDialog)
  EV_CHILD_NOTIFY(IDSWADDB,BN_CLICKED,AddClicked),
  EV_CHILD_NOTIFY(IDSWINSERTB,BN_CLICKED,InsertClicked),
  EV_CHILD_NOTIFY(IDSWTOPB,BN_CLICKED,TopClicked),
  EV_CHILD_NOTIFY(IDSWLASTB,BN_CLICKED,LastClicked),
  EV_CHILD_NOTIFY(IDSWREMOVEB,BN_CLICKED,RemoveClicked),
END_RESPONSE_TABLE;

void SwitchDialog::SetupWindow()
{
  int num2,num1,j,k;
  char **buf;

  TMyDialog::SetupWindow();
  menuadddrawrable(chkobject("draw"),&drawrable);
  SendDlgItemMessage(IDSWLIST2,LB_RESETCONTENT,0,0);
  num2=arraynum(&drawrable);
  for (j=0;j<num2;j++) {
    buf=(char **)arraynget(&drawrable,j);
    SendDlgItemMessage(IDSWLIST2,LB_INSERTSTRING,-1,(LPARAM)*buf);
  }
  num1=arraynum(&(menulocal.drawrable));
  for (j=0;j<num1;j++) {
    buf=(char **)arraynget(&(menulocal.drawrable),j);
    for (k=0;k<num2;k++) if (strcmp0(*(char **)arraynget(&drawrable,k),*buf)==0) break;
    if (k!=num2) arrayadd(&idrawrable,&k);
  }
  SetupItem();
}

void SwitchDialog::SetupItem()
{
  int j,num;
  char **buf;

  SendDlgItemMessage(IDSWLIST1,LB_RESETCONTENT,0,0);
  num=arraynum(&idrawrable);
  for (j=0;j<num;j++) {
    buf=(char **)arraynget(&drawrable,*(int *)arraynget(&idrawrable,j));
    SendDlgItemMessage(IDSWLIST1,LB_INSERTSTRING,-1,(LPARAM)*buf);
  }
}

void SwitchDialog::CloseWindow(int retVal)
{
  int j,num;
  char **buf;

  if (retVal==IDOK) {
    arraydel2(&(menulocal.drawrable));
    num=arraynum(&idrawrable);
    for (j=0;j<num;j++) {
      buf=(char **)arraynget(&drawrable,*(int *)arraynget(&idrawrable,j));
      if ((*buf)!=NULL) arrayadd2(&(menulocal.drawrable),buf);
    }
  }
  TMyDialog::CloseWindow(retVal);
}

void SwitchDialog::AddClicked()
{
  int j,num;

  num=SendDlgItemMessage(IDSWLIST2,LB_GETCOUNT,0,0);
  for (j=0;j<num;j++) {
    if (SendDlgItemMessage(IDSWLIST2,LB_GETSEL,j,0)>0)
      arrayadd(&idrawrable,&j);
  }
  SetupItem();
}

void SwitchDialog::InsertClicked()
{
  int i,j,num,pos,num2;
  int *data;

  pos=SendDlgItemMessage(IDSWLIST1,LB_GETCURSEL,0,0);
  if (pos<0) pos=0;
  num2=arraynum(&idrawrable);
  data=(int *)arraydata(&idrawrable);
  num=SendDlgItemMessage(IDSWLIST2,LB_GETCOUNT,0,0);
  for (j=num-1;j>=0;j--) {
    if (SendDlgItemMessage(IDSWLIST2,LB_GETSEL,j,0)>0) {
      for (i=0;i<num2;i++) if (data[i]==j) break;
      if (i==num2) arrayins(&idrawrable,&j,pos);
    }
  }
  SetupItem();
}

void SwitchDialog::TopClicked()
{
  int j,num,k;

  num=SendDlgItemMessage(IDSWLIST1,LB_GETCOUNT,0,0);
  for (j=0;j<num;j++) {
    if (SendDlgItemMessage(IDSWLIST1,LB_GETSEL,j,0)>0) {
      k=*(int *)arraynget(&idrawrable,j);
      arrayndel(&idrawrable,j);
      arrayins(&idrawrable,&k,0);
    }
  }
  SetupItem();
}

void SwitchDialog::LastClicked()
{
  int j,num,k;

  num=SendDlgItemMessage(IDSWLIST1,LB_GETCOUNT,0,0);
  for (j=num-1;j>=0;j--) {
    if (SendDlgItemMessage(IDSWLIST1,LB_GETSEL,j,0)>0) {
      k=*(int *)arraynget(&idrawrable,j);
      arrayndel(&idrawrable,j);
      arrayadd(&idrawrable,&k);
    }
  }
  SetupItem();
}

void SwitchDialog::RemoveClicked()
{
  int j,num;

  num=SendDlgItemMessage(IDSWLIST1,LB_GETCOUNT,0,0);
  for (j=num-1;j>=0;j--) {
    if (SendDlgItemMessage(IDSWLIST1,LB_GETSEL,j,0)>0) {
      arrayndel(&idrawrable,j);
    }
  }
  SetupItem();
}




class LoadDialog  : public TMyDialog {
  public:
    LoadDialog(TWindow *parent,TResId resID);
    ~LoadDialog() {
      memfree(exdir);
    };
    int ignorepath;
    int expand;
    char *exdir;
  protected:
    void SetupWindow();
    void CloseWindow(int retVal);
};

LoadDialog::LoadDialog(TWindow *parent,TResId resID)
:TMyDialog(parent,resID)
{
  expand=menulocal.expand;
  ignorepath=menulocal.ignorepath;
  exdir=(char *)memalloc(strlen(menulocal.expanddir)+1);
  strcpy(exdir,menulocal.expanddir);
}

void LoadDialog::SetupWindow()
{
  TMyDialog::SetupWindow();
  SendDlgItemMessage(IDLIGNOREPATH,BM_SETCHECK,0,0);
  if (expand) SendDlgItemMessage(IDLEXPAND,BM_SETCHECK,1,0);
  else SendDlgItemMessage(IDLEXPAND,BM_SETCHECK,0,0);
  SetDlgItemText(IDLEXPANDDIR,exdir);
  if (ignorepath) SendDlgItemMessage(IDLIGNOREPATH,BM_SETCHECK,1,0);
  else SendDlgItemMessage(IDLIGNOREPATH,BM_SETCHECK,0,0);
}

void LoadDialog::CloseWindow(int retVal)
{
  int a,len;

  if (retVal!=IDOK) {
    TMyDialog::CloseWindow(retVal);
    return;
  }
  a=SendDlgItemMessage(IDLIGNOREPATH,BM_GETCHECK,0,0);
  if (a==1) ignorepath=TRUE;
  else ignorepath=FALSE;
  a=SendDlgItemMessage(IDLEXPAND,BM_GETCHECK,0,0);
  if (a==1) expand=TRUE;
  else expand=FALSE;
  len=SendDlgItemMessage(IDLEXPANDDIR,WM_GETTEXTLENGTH,0,0);
  memfree(exdir);
  exdir=(char *)memalloc(len+1);
  GetDlgItemText(IDLEXPANDDIR,exdir,len+1);
  TMyDialog::CloseWindow(retVal);
}


void TMyWindow::CmGraphNewFrame()
{
  if (menulock || globallock ) return;
  if (!CheckSave()) return;
  DeleteDrawable();
  CmAxisNewFrame();
  Update();
  CmViewerDraw();
}

void TMyWindow::CmGraphNewSection()
{
  if (menulock || globallock ) return;
  if (!CheckSave()) return;
  DeleteDrawable();
  CmAxisNewSection();
  Update();
  CmViewerDraw();
}

void TMyWindow::CmGraphNewCross()
{
  if (menulock || globallock ) return;
  if (!CheckSave()) return;
  DeleteDrawable();
  CmAxisNewCross();
  Update();
  CmViewerDraw();
}

void TMyWindow::CmGraphAllClear()
{
  if (menulock || globallock ) return;
  if (!CheckSave()) return;
  DeleteDrawable();
  Update();
  CmViewerDraw();
}

void TMyWindow::CmGraphSwitch()
{
  if (menulock || globallock ) return;
  if (SwitchDialog(this,DIALOG_SWITCH).Execute()==IDOK) {
    NgraphApp->Changed=TRUE;
    ChangePage();
  }
}


void TMyWindow::CmGraphLoad()
{
  LoadDialog *dlg;
  char *ext;

  if (menulock || globallock) return;
  if (!CheckSave()) return;
  GraphLoadBuf[0]='\0';
  EnableFrameWindow(this,false);
  if (nGetOpenFileName(Handle,"Load NGP file","ngp",&(menulocal.graphloaddir),
      GraphLoadBuf,512,"Ngraph Script (*.ngp)\0*.ngp\0PRM file (*.prm)\0*.prm\0",TRUE,menulocal.changedirectory)==IDOK) {
    if (((ext=getextention(GraphLoadBuf))!=NULL)
    && ((strcmp0(ext,"PRM")==0) || (strcmp0(ext,"prm")==0))) {
      LoadPrmFile(GraphLoadBuf);
      NgraphApp->Changed=FALSE;
    } else {
      dlg=new LoadDialog(this,DIALOG_LOAD);
      if (dlg->Execute()==IDOK) {
        LoadNgpFile(GraphLoadBuf,dlg->ignorepath,dlg->expand,dlg->exdir,menulocal.scriptconsole,"-f");
        NgraphApp->Changed=FALSE;
      }
      delete dlg;
    }
  }
  EnableFrameWindow(this,true);
}

void TMyWindow::CmGraphPage()
{
  PageDialog *dlg;

  if (menulock || globallock) return;
  dlg=new PageDialog((TWindow *)this,DIALOG_PAGE);
  if (dlg->Execute()==IDOK) {
    SetPageSettingsToGRA();
    NgraphApp->ChangePage();
    GetPageSettingsFromGRA();
    NgraphApp->Changed=TRUE;
  }
  delete dlg;
}

void TMyWindow::CmGraphHistory(WPARAM wparam)
{
  int fil,num,num2;
  char **data,**data2;
  LoadDialog *dlg;
  struct narray *ngpfilelist,*ngpdirlist;

  if (menulock || globallock) return;
  ngpfilelist=menulocal.ngpfilelist;
  ngpdirlist=menulocal.ngpdirlist;
  num=arraynum(ngpfilelist);
  data=(char **)arraydata(ngpfilelist);
  num2=arraynum(ngpdirlist);
  data2=(char **)arraydata(ngpdirlist);
  fil=LOWORD(wparam)-CM_GRAPH00-1;
  if ((fil<0) || (fil>=num) || (data[fil]==NULL)) return;
  if (!CheckSave()) return;
  if ((fil>=0) && (fil<num2) && (data2[fil]!=NULL) && (data2[0]!='\0'))
    chdir(data2[fil]);
  dlg=new LoadDialog(this,DIALOG_LOAD);
  if (dlg->Execute()==IDOK) {
    LoadNgpFile(data[fil],dlg->ignorepath,dlg->expand,dlg->exdir,menulocal.scriptconsole,"-f");
    NgraphApp->Changed=FALSE;
  }
  delete dlg;
}


void TMyWindow::CmOptionSaveNgp()
{
  char *ngpfile;
  char mes[256],*buf;
  int i,path;
  struct objlist *obj;

  if ((ngpfile=getscriptname("Ngraph.ngp"))==NULL) return;
  unchangefilename(ngpfile);
  path=1;
  if ((obj=chkobject("file"))!=NULL) {
    for (i=0;i<=chkobjlastinst(obj);i++)
      putobj(obj,"save_path",i,&path);
  }
  if ((obj=chkobject("merge"))!=NULL) {
    for (i=0;i<=chkobjlastinst(obj);i++)
      putobj(obj,"save_path",i,&path);
  }
  if (access(ngpfile,04)==0) {
    buf=(char *)memalloc(strlen(ngpfile)+60);
    if (buf!=NULL) {
      sprintf(buf,
#ifdef ENGLISH
               "`%s'\n\nOverwrite existing file?",
#else
               "`%s'\n\nt@C݂܂B㏑Ă낵łH",
#endif
               ngpfile);
      if (MessageBox(buf,"Save as Ngraph.ngp",MB_ICONQUESTION|MB_YESNO)!=IDYES) {
        memfree(buf);
        memfree(ngpfile);
        return;
      }
      memfree(buf);
    } else {
      if (MessageBox(
#ifdef ENGLISH
               "Overwrite existing file?",
#else
               "t@C݂܂B㏑Ă낵łH",
#endif
       "Save as Ngraph.ngp",MB_ICONQUESTION|MB_YESNO)!=IDYES) {
        memfree(ngpfile);
        return;
      }
    }
  }
  sprintf(mes,"Saving `%.128s'.",ngpfile);
  SetStatusBar(mes);
  SaveDrawable(ngpfile,FALSE,FALSE);
  ResetStatusBar();
  memfree(ngpfile);
  return;
}

void TMyWindow::CmGraphSave()
{
  if (menulock || globallock ) return;
  GraphSave(FALSE);
}

void TMyWindow::CmGraphOverWrite()
{
  if (menulock || globallock ) return;
  GraphSave(TRUE);
}


