/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 * wininfo.cpp
 *
 */

#include <owl\pch.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

extern "C" {
#include "ngraph.h"
#include "object.h"
#include "nstring.h"
#include "ioutil.h"
#include "owinmenu.h"
}

#include "bitmap.rh"
#include "winmenu.rh"
#include "winmenu.h"

DEFINE_RESPONSE_TABLE1(TDialogWindow, TSubWindow)
  EV_WM_PAINT,
  EV_WM_KEYDOWN,
  EV_WM_RBUTTONDOWN,
  EV_COMMAND(CM_COPYK,Clipboard),
END_RESPONSE_TABLE;

TDialogWindow::TDialogWindow(TWindow *parent):TSubWindow(parent)
{
  menulocal.dialogopen=TRUE;
  col1=GetSysColor(COLOR_WINDOWTEXT);
  brush1=CreateSolidBrush(GetSysColor(COLOR_WINDOW));
  PopupMenu.AppendMenu(MF_STRING,CM_COPYK,"Clipboard (INS)");
}

void TDialogWindow::SetupWindow()
{
  TSubWindow::SetupWindow();
}

TDialogWindow::~TDialogWindow()
{
  menulocal.dialogopen=FALSE;
  DeleteObject(brush1);
  NgraphApp->DeleteDialogWindow();
}

void TDialogWindow::DrawInfoText()
{
  TClientDC dc(Handle);
  RECT rect;

  ::GetClientRect(Handle,&rect);
  ::FillRect(dc,&rect,brush1);
  DrawText(dc);
}

void TDialogWindow::Update(int clear)
{
  Invalidate();
}

void TDialogWindow::Clipboard()
{
  HANDLE HD;
  char far *Clip;
  char *str;
  int i,j,num;

  str=NgraphApp->infostr;
  if (str==NULL) return;
  num=0;
  for (i=0;str[i]!='\0';i++)
    if (str[i]=='\n') num++;
  if ((HD=GlobalAlloc(GMEM_MOVEABLE,strlen(str)+num+1))!=NULL) {
    Clip=(char *)GlobalLock(HD);
    j=0;
    for (i=0;str[i]!='\0';i++) {
      if (str[i]=='\n') Clip[j++]='\r';
      Clip[j++]=str[i];
    }
    Clip[j]='\0';
    GlobalUnlock(HD);
    ::OpenClipboard(Handle);
    ::EmptyClipboard();
    ::SetClipboardData(CF_TEXT,HD);
    ::CloseClipboard();
  }
}

void TDialogWindow::DrawText(HDC dc)
{
  int x,y,len,j,k;
  HFONT orgfont;
  char *str;

  str=NgraphApp->infostr;
  if (str==NULL) return;
  orgfont=(HFONT)SelectObject(dc,menulocal.menufont);
  SetTextAlign(dc,TA_BOTTOM | TA_LEFT);
  SetTextColor(dc,col1);
  SetBkMode(dc,TRANSPARENT);
  x=NgraphApp->FWidth;
  y=2*NgraphApp->FHeight;
  len=0;
  j=k=0;
  while (TRUE) {
    if (str[j]=='\0') {
      TextOut(dc,x,y,str+k,len);
      k=j+1;
      len=0;
      break;
    } else if (str[j]=='\n') {
      TextOut(dc,x,y,str+k,len);
      k=j+1;
      len=0;
      y+=NgraphApp->FHeight;
    } else len++;
    j++;
  }
  SelectObject(dc,orgfont);
}

void TDialogWindow::EvRButtonDown(UINT modKeys,TPoint& point)
{
  TRect rect;
  TPoint point2;

  if (menulock || globallock) return;
  GetWindowRect(rect);
  point2.x=point.x+rect.left;
  point2.y=point.y+rect.top;
  PopupMenu.TrackPopupMenu(TPM_LEFTBUTTON | TPM_RIGHTBUTTON,point2,0,Handle);
}

void TDialogWindow::EvPaint()
{
  PAINTSTRUCT ps;
  HDC dc;
  RECT rc;

  if (::GetUpdateRect(Handle,&rc,FALSE)) {
    dc=::BeginPaint(*this,&ps);
    DrawText(dc);
    ::EndPaint(Handle,&ps);
  }
}

void TDialogWindow::EvKeyDown(UINT key,UINT repeatCount,UINT flags)
{

  if (menulock || globallock) return;
  switch (key) {
  case VK_INSERT:
    Clipboard();
	break;
  default:
    NgraphApp->EvKeyDown2(key,repeatCount,flags);
    break;
  }
  TWindow::EvKeyDown(key,repeatCount,flags);
}

void TMyWindow::CmWindowDialog()
{
  TDialogWindow *win;
  TRect rect;
  int x,y;

  if (menulock || globallock) return;
  if  (pTDialogWindow==NULL) {
    win=(TDialogWindow *)pTDialogWindow=new TDialogWindow();
    win->Frame=new TSubFrameWindow(this,"Information Window",win,
    &menulocal.dialogx,&menulocal.dialogy,&menulocal.dialogwidth,&menulocal.dialogheight);
    win->Frame->SetIcon(GetApplication(),ICON_5);
    NgraphApp->Frame->GetWindowRect(rect);
    x=rect.left;
    y=rect.top;
    if (menulocal.dialogwidth==CW_USEDEFAULT) win->Frame->Attr.W=FWidth*30;
    else win->Frame->Attr.W=menulocal.dialogwidth;
    if (menulocal.dialogheight==CW_USEDEFAULT) win->Frame->Attr.H=FHeight*20;
    else win->Frame->Attr.H=menulocal.dialogheight;
    if (menulocal.dialogx==CW_USEDEFAULT) win->Frame->Attr.X=CW_USEDEFAULT;
    else {
      win->Frame->Attr.X=menulocal.dialogx+x;
      if (win->Frame->Attr.X<0) win->Frame->Attr.X=0;
    }
    if (menulocal.dialogy==CW_USEDEFAULT) win->Frame->Attr.Y=CW_USEDEFAULT;
    else {
      win->Frame->Attr.Y=menulocal.dialogy+y;
      if (win->Frame->Attr.Y<0) win->Frame->Attr.Y=0;
    }
    win->Frame->Create();
  } else {
    win=(TDialogWindow *)pTDialogWindow;
    win->CloseWindow();
  }
}

void TMyWindow::CeWindowDialog(TCommandEnabler& ce)
{
  if (pTDialogWindow==NULL) ce.SetCheck(TCommandEnabler::Unchecked);
  else ce.SetCheck(TCommandEnabler::Checked);
}

