/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 *  winlgnd.h
 *
 */


#define LEGENDNUM 7

char *LegendLineCB(struct objlist *obj,int id);
char *LegendRectCB(struct objlist *obj,int id);
char *LegendArcCB(struct objlist *obj,int id);
char *LegendTextCB(struct objlist *obj,int id);

class LegendCurveDialog  : public TMyDialog {
  public:
    LegendCurveDialog(TWindow *parent,TResId resID,struct objlist *obj,int id);
    ~LegendCurveDialog() {
      delete Col;
    }
  protected:
    ColorButton *Col;
    struct objlist *Obj;
    int Id;
    void SetupWindow();
    void SetupItem(int id);
    void CopyClicked() {
      int sel;
      if ((sel=CopyClick(this,Obj,Id,LegendLineCB))!=-1)
        SetupItem(sel);
    }
    void CloseWindow(int retVal);
    void DeleteClicked() {CloseWindow(IDDELETE);}
    DECLARE_RESPONSE_TABLE(LegendCurveDialog);
};

class LegendPolyDialog  : public TMyDialog {
  public:
    LegendPolyDialog(TWindow *parent,TResId resID,struct objlist *obj,int id);
    ~LegendPolyDialog() {
      delete Col;
    }
  protected:
    ColorButton *Col;
    struct objlist *Obj;
    int Id;
    void SetupWindow();
    void SetupItem(int id);
    void CopyClicked() {
      int sel;
      if ((sel=CopyClick(this,Obj,Id,LegendLineCB))!=-1)
        SetupItem(sel);
    }
    void CloseWindow(int retVal);
    void DeleteClicked() {CloseWindow(IDDELETE);}
    DECLARE_RESPONSE_TABLE(LegendPolyDialog);
};

class ArrowHeadStatic : public TStatic {
  public:
    ArrowHeadStatic(TWindow *parent,int resId);
    void SetLenWid(int angle,int width);
  protected:
    int ang,wid;
    void EvPaint();
    DECLARE_RESPONSE_TABLE(ArrowHeadStatic);
};

class LegendArrowDialog  : public TMyDialog {
  public:
    LegendArrowDialog(TWindow *parent,TResId resID,struct objlist *obj,int id);
    ~LegendArrowDialog() {
      delete Col;
      delete LEN;
      delete WID;
      delete LENSC;
      delete WIDSC;
      delete HeadWin;
    }
  protected:
    TStatic *LEN,*WID,*ANGLE;
    TScrollBar *LENSC,*WIDSC;
    ColorButton *Col;
    ArrowHeadStatic *HeadWin;
    int wid,ang;
    struct objlist *Obj;
    int Id;
    void SetupWindow();
    void SetupItem(int id);
    void CopyClicked() {
      int sel;
      if ((sel=CopyClick(this,Obj,Id,LegendLineCB))!=-1)
        SetupItem(sel);
    }
    void CloseWindow(int retVal);
    void DeleteClicked() {CloseWindow(IDDELETE);}
    void EvHScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl);
    void EvVScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl);
    DECLARE_RESPONSE_TABLE(LegendArrowDialog);
};

class LegendRectDialog  : public TMyDialog {
  public:
    LegendRectDialog(TWindow *parent,TResId resID,struct objlist *obj,int id);
    ~LegendRectDialog() {
      delete Col;
    }
  protected:
    ColorButton *Col,*Col2;
    struct objlist *Obj;
    int Id;
    void SetupWindow();
    void SetupItem(int id);
    void CopyClicked() {
      int sel;
      if ((sel=CopyClick(this,Obj,Id,LegendRectCB))!=-1)
        SetupItem(sel);
    }
    void CloseWindow(int retVal);
    void DeleteClicked() {CloseWindow(IDDELETE);}
    DECLARE_RESPONSE_TABLE(LegendRectDialog);
};

class LegendArcDialog  : public TMyDialog {
  public:
    LegendArcDialog(TWindow *parent,TResId resID,struct objlist *obj,int id);
    ~LegendArcDialog() {
      delete Col;
    }
  protected:
    ColorButton *Col;
    struct objlist *Obj;
    int Id;
    void SetupWindow();
    void SetupItem(int id);
    void CopyClicked() {
      int sel;
      if ((sel=CopyClick(this,Obj,Id,LegendArcCB))!=-1)
        SetupItem(sel);
    }
    void CloseWindow(int retVal);
    void DeleteClicked() {CloseWindow(IDDELETE);}
    DECLARE_RESPONSE_TABLE(LegendArcDialog);
};

class LegendMarkDialog  : public TMyDialog {
  public:
    LegendMarkDialog(TWindow *parent,TResId resID,struct objlist *obj,int id);
    ~LegendMarkDialog() {
      delete Col1;
      delete Col2;
      delete Mark;
    }
  protected:
    ColorButton *Col1;
    ColorButton *Col2;
    MarkComboBox *Mark;
    struct objlist *Obj;
    int Id;
    void SetupWindow();
    void SetupItem(int id);
    void CopyClicked() {
      int sel;
      if ((sel=CopyClick(this,Obj,Id,LegendArcCB))!=-1)
        SetupItem(sel);
    }
    void CloseWindow(int retVal);
    void DeleteClicked() {CloseWindow(IDDELETE);}
    DECLARE_RESPONSE_TABLE(LegendMarkDialog);
};

class LegendTextDialog  : public TMyDialog {
  public:
    LegendTextDialog(TWindow *parent,TResId resID,struct objlist *obj,int id);
    ~LegendTextDialog() {
      delete Col;
    }
  protected:
    int pt;
    ColorButton *Col;
    struct objlist *Obj;
    int Id;
    void SetupWindow();
    void SetupItem(int id);
    void CopyClicked() {
      int sel;
      if ((sel=CopyClick(this,Obj,Id,LegendTextCB))!=-1)
        SetupItem(sel);
    }
    void CloseWindow(int retVal);
    void DeleteClicked() {CloseWindow(IDDELETE);}
    bool EvInitDialog(HWND hWndFocus);
    DECLARE_RESPONSE_TABLE(LegendTextDialog);
};

class LegendTextDefDialog  : public TMyDialog {
  public:
    LegendTextDefDialog(TWindow *parent,TResId resID,struct objlist *obj,int id);
    ~LegendTextDefDialog() {
      delete Col;
    }
  protected:
    int pt;
    ColorButton *Col;
    struct objlist *Obj;
    int Id;
    void SetupWindow();
    void SetupItem(int id);
    void CloseWindow(int retVal);
};

class TLegendWindow : public TSubWindow {
  public:
    TLegendWindow(TWindow* parent=0);
    ~TLegendWindow();
    void SelectLegend(HDC dc,int sel);
    void Update(int clear);
    void ChangeLegendNum();
  protected:
    void SetupWindow();
    TPopupMenu PopupMenu;
    int select;
    int legend[LEGENDNUM];
    COLORREF col1,col1h;
    COLORREF col2;
    HBRUSH brush1;
    HBRUSH brush2;
    HPEN pen1;
    HPEN pen2;
    struct objlist *obj[LEGENDNUM];
    void LegendDelete();
    void LegendCopy();
    void LegendCopy2();
    void LegendTop();
    void LegendLast();
    void LegendUpdate();
    void LegendUp();
    void LegendDown();
    void LegendSelect();
    void LegendHidden();
    void EvPaint();
    void EvSize(UINT sizeType, TSize& size);
    void EvLButtonDown(UINT,TPoint& size);
    void EvRButtonDown(UINT modKeys, TPoint& point);
    void EvLButtonDblClk(UINT,TPoint& size);
    void EvKeyDown(UINT key,UINT repeatCount,UINT flags);
    DECLARE_RESPONSE_TABLE(TLegendWindow);
};
