/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 * winlgndx.cpp
 *
 */

#include <owl\pch.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

extern "C" {
#include "ngraph.h"
#include "object.h"
#include "nstring.h"
#include "ioutil.h"
#include "mathfn.h"
#include "gra.h"
#include "spline.h"
#include "owinmenu.h"
}

#include "winmenu.h"
#include "winmenu.rh"
#include "windialg.h"
#include "wincommn.h"
#include "winlgnd.h"
#include "winlgndx.h"


DEFINE_RESPONSE_TABLE1(GaussWinStatic,TStatic)
  EV_WM_PAINT,
END_RESPONSE_TABLE;

double *spx,*spy,*spz;
double *spc[6];

GaussWinStatic::GaussWinStatic(TWindow *parent,int resId) : TStatic(parent,resId)
{
  int i;
  alloc=TRUE;
  if ((spx=(double *)memalloc(sizeof(double)*201))==NULL) alloc=FALSE;
  if ((spy=(double *)memalloc(sizeof(double)*201))==NULL) alloc=FALSE;
  if ((spz=(double *)memalloc(sizeof(double)*201))==NULL) alloc=FALSE;
  for (i=0;i<6;i++)
    if ((spc[i]=(double *)memalloc(sizeof(double)*201))==NULL) alloc=FALSE;
}

GaussWinStatic::~GaussWinStatic()
{
  int i;
  for (i=0;i<6;i++) memfree(spc[i]);
  memfree(spz);
  memfree(spy);
  memfree(spx);
}

void GaussWinStatic::WSetParam(int wdx,int wdy,int div,int dir,int mode,
                               double position,double param)
{
  Wdx=wdx;
  Wdy=wdy;
  Div=div;
  Dir=dir;
  Mode=mode;
  Position=position;
  Param=param;
}

void GaussWinStatic::EvPaint()
{
  HDC dc;
  PAINTSTRUCT ps;
  RECT rect;
  HPEN pen,spen;
  HBRUSH brush;
  int i,j,k,w,h,pw,dw;
  int minx,miny,maxx,maxy;
  double ppd,x,y,tmp;
//  ,x0,r,v,n,t1,t2,ofs,p;
  int Amp,Wd;
  int dpi,GC,spnum;
  struct mwlocal mwsave;
  double spc2[6];

  dc=::BeginPaint(Handle,&ps);
  ::GetClientRect(Handle,&rect);
  brush=CreateSolidBrush(RGB(255,255,255));
  FillRect(dc,&rect,brush);
  DeleteObject(brush);
  w=rect.right-rect.left;
  h=rect.bottom-rect.top;
  if (w<h) pw=w-1;
  else pw=h-1;
  if (Wdx<Wdy) dw=Wdy;
  else dw=Wdx;
  ppd=pw/((double )dw);
  dpi=nround(ppd*2540);
  minx=w/2-Wdx*ppd/2;
  miny=h/2-Wdy*ppd/2;
  maxx=w/2+Wdx*ppd/2;
  maxy=h/2+Wdy*ppd/2;
  pen=CreatePen(PS_DOT,1,RGB(128,128,128));
  spen=(HPEN)SelectObject(dc,pen);
  MoveToEx(dc,minx,miny,NULL);
  LineTo(dc,maxx,miny);
  LineTo(dc,maxx,maxy);
  LineTo(dc,minx,maxy);
  LineTo(dc,minx,miny);
  if ((Dir==0) || (Dir==1)) {
    Amp=Wdy;
    Wd=Wdx;
  } else {
    Amp=Wdx;
    Wd=Wdy;
  }
  if (alloc) {
    mwsaveDC(dc,Handle,0,0,&mwsave,dpi,FALSE,NULL);
    GC=_GRAopen(chkobjectname(menulocal.obj),"_output",menulocal.outputobj,
                menulocal.inst,menulocal.output,-1,-1,-1,NULL,mwlocal);
    if (GC>=0) {
      GRAview(GC,mwp2d(minx),mwp2d(miny),
                 mwp2d(maxx),mwp2d(maxy),1);
      for (i=0;i<=Div;i++) {
        if (Mode==0) {
          x=Wd/((double )Div)*i;
          tmp=(x-Wd*0.5-Wd*Position*0.5)/(Wd/(1+10*Param)/2);
          y=Amp*exp(-tmp*tmp);
        } else if (Mode==1) {
          x=Wd/((double )Div)*i;
          tmp=(x-Wd*0.5-Wd*Position*0.5)/(Wd/(1+10*Param)/2);
          y=Amp/(tmp*tmp+1);
        } else if (Mode==2) {
          x=Wd/((double )Div)*i;
          if (Position>=0) {
            tmp=(x-Wd*0.5-Wd*Position*0.5)/(-Wd*0.5-Wd*Position*0.5);
          } else {
            tmp=(x-Wd*0.5-Wd*Position*0.5)/(Wd*0.5-Wd*Position*0.5);
          }
          y=Amp*tmp*tmp;
        } else if (Mode==3) {
          x=Wd/((double )Div)*i;
          tmp=x/(Wd/(0.25+10*Param));
          y=Amp*0.5*(sin(2*MPI*(tmp-Position*0.5))+1);
/*          r=Amp*0.5;
          ofs=MPI*(Position+1);
          p=2*MPI*(1+10*Param);
          t1=(2*MPI-ofs)/p;
          n=(int )(1+10*Param+(Position+1)/2-0.5);
          t2=((2*n+1)*MPI-ofs)/p;

          x0=r*cos(ofs);
          v=Wd+r*cos(p+ofs)-x0;
          if (((x0-r+v*t1)>=0) && ((x0+r+v*t2)<=Wd)) goto find;
          v=(Wd-r-x0)/t2;
          if (((x0-r+v*t1)>=0) && ((x0-r*cos(p+ofs)+v)<=Wd)) goto find;
          v=(r-r*cos(p+ofs)-Wd)/(t1-1);
          x0=r-v*t1;
          if (((x0-r*cos(ofs))>=0) && ((x0+r+v*t2)<=Wd)) goto find;
          v=(2*r-Wd)/(t1-t2);
          x0=r-v*t1;
find:
          tmp=1.0/Div*i;
          x=x0-r*cos(p*tmp+ofs)+v*tmp;
          y=r*(sin(p*tmp+ofs)+1);  */
        }
        if (Dir==0) {
          spx[i]=nround(x);
          spy[i]=Wdy-nround(y);
        } else if (Dir==1) {
          spx[i]=nround(x);
          spy[i]=nround(y);
        } else if (Dir==2) {
          spx[i]=Wdx-nround(y);
          spy[i]=Wdy-nround(x);
        } else if (Dir==3) {
          spx[i]=nround(y);
          spy[i]=Wdy-nround(x);
        }
        spz[i]=i;
      }
      spnum=Div+1;
      spline(spz,spx,spc[0],spc[1],spc[2],spnum,SPLCND2NDDIF,SPLCND2NDDIF,0,0);
      spline(spz,spy,spc[3],spc[4],spc[5],spnum,SPLCND2NDDIF,SPLCND2NDDIF,0,0);
      GRAcolor(GC,0,0,0);
      GRAcurvefirst(GC,0,NULL,NULL,NULL,
                    splinedif,splineint,NULL,spx[0],spy[0]);
      for (j=0;j<spnum-1;j++) {
        for (k=0;k<6;k++) spc2[k]=spc[k][j];
         if (!GRAcurve(GC,spc2,spx[j],spy[j])) break;
      }
    }
    _GRAclose(GC);
    mwrestoreDC(&mwsave);
  }
  SelectObject(dc,spen);
  DeleteObject(pen);
  ::EndPaint(Handle,&ps);
}


DEFINE_RESPONSE_TABLE1(LegendGaussDialog,TMyDialog)
  EV_CHILD_NOTIFY(IDLCTOP,BN_CLICKED,TopClicked),
  EV_CHILD_NOTIFY(IDLCBOTTOM,BN_CLICKED,TopClicked),
  EV_CHILD_NOTIFY(IDLCLEFT,BN_CLICKED,TopClicked),
  EV_CHILD_NOTIFY(IDLCRIGHT,BN_CLICKED,TopClicked),
  EV_CHILD_NOTIFY(IDLGGAUSS,BN_CLICKED,GaussClicked),
  EV_CHILD_NOTIFY(IDLGLORENTZ,BN_CLICKED,GaussClicked),
  EV_CHILD_NOTIFY(IDLGPARABOLA,BN_CLICKED,GaussClicked),
  EV_CHILD_NOTIFY(IDLGSIN,BN_CLICKED,GaussClicked),
  EV_WM_HSCROLL,
  EV_WM_VSCROLL,
END_RESPONSE_TABLE;

LegendGaussDialog::LegendGaussDialog(TWindow *parent,TResId resID,struct objlist *obj,int id,
                                    int minx,int miny,int wdx,int wdy)
:TMyDialog(parent,resID)
{
  Obj=obj;
  Id=id;
  Minx=minx;
  Miny=miny;
  Wdx=wdx;
  Wdy=wdy;
  Div=20;
  Position=0;
  Param=0.175;
  Dir=0;
  Mode=0;
  Col=new ColorButton(this,IDLCCOLB);
  Win=new GaussWinStatic(this,IDLCWIN);
  Win->WSetParam(Wdx,Wdy,Div,Dir,Mode,Position,Param);
  DIV=new TStatic(this,IDLCDIV,16);
  DIVSC=new TScrollBar(this,IDLCDIVSC);
  SCVV=new TStatic(this,IDLCSCVV,16);
  SCHV=new TStatic(this,IDLCSCHV,16);
  SCV=new TScrollBar(this,IDLCSCV);
  SCH=new TScrollBar(this,IDLCSCH);
}

LegendGaussDialog::~LegendGaussDialog()
{
  delete SCH;
  delete SCV;
  delete SCHV;
  delete SCVV;
  delete DIVSC;
  delete DIV;
  delete Win;
  delete Col;
}

void LegendGaussDialog::SetupWindow()
{
  char *title;
  int len;

  TMyDialog::SetupWindow();
  len=GetWindowTextLength();
  if ((title=(char *)memalloc(len+10))!=NULL) {
    GetWindowText(title,len+1);
    sprintf(title+len," %d",Id);
    SetCaption(title);
    memfree(title);
  }
  SetupItem(Id);
}

void LegendGaussDialog::SetupItem(int id)
{
  int R,G,B;
  char buf[16];

  SetStyleFromObjField(Handle,IDLCSTYLE,Obj,id,"style");
  SetComboList(Handle,IDLCWIDTH,cblinewidth,CBLINEWIDTH);
  SetTextFromObjField(Handle,IDLCWIDTH,Obj,id,"width");
  SetListFromObjField(Handle,IDLCJOIN,Obj,id,"join");
  SetTextFromObjField(Handle,IDLCMITER,Obj,id,"miter_limit");
  getobj(Obj,"R",id,0,NULL,&R);
  getobj(Obj,"G",id,0,NULL,&G);
  getobj(Obj,"B",id,0,NULL,&B);
  Col->SetColor(R,G,B);
  sprintf(buf,"%d",Div);
  SetDlgItemText(IDLCDIV,buf);
  SendDlgItemMessage(IDLCTOP,BM_SETCHECK,0,0);
  SendDlgItemMessage(IDLCBOTTOM,BM_SETCHECK,0,0);
  SendDlgItemMessage(IDLCLEFT,BM_SETCHECK,0,0);
  SendDlgItemMessage(IDLCRIGHT,BM_SETCHECK,0,0);
  if (Dir==0) SendDlgItemMessage(IDLCTOP,BM_SETCHECK,1,0);
  else if (Dir==1) SendDlgItemMessage(IDLCBOTTOM,BM_SETCHECK,1,0);
  else if (Dir==2) SendDlgItemMessage(IDLCLEFT,BM_SETCHECK,1,0);
  else if (Dir==3) SendDlgItemMessage(IDLCRIGHT,BM_SETCHECK,1,0);
  SendDlgItemMessage(IDLGGAUSS,BM_SETCHECK,0,0);
  SendDlgItemMessage(IDLGLORENTZ,BM_SETCHECK,0,0);
  SendDlgItemMessage(IDLGPARABOLA,BM_SETCHECK,0,0);
  SendDlgItemMessage(IDLGSIN,BM_SETCHECK,0,0);
  if (Mode==0) SendDlgItemMessage(IDLGGAUSS,BM_SETCHECK,1,0);
  else if (Mode==1) SendDlgItemMessage(IDLGLORENTZ,BM_SETCHECK,1,0);
  else if (Mode==2) SendDlgItemMessage(IDLGPARABOLA,BM_SETCHECK,1,0);
  else if (Mode==3) SendDlgItemMessage(IDLGSIN,BM_SETCHECK,1,0);
  sprintf(buf,"%d",Div);
  DIV->SetText(buf);
  DIVSC->SetRange(10,200);
  DIVSC->SetPosition(Div);
  sprintf(buf,"%.2f",Position);
  SCHV->SetText(buf);
  SCH->SetRange(0,200);
  SCH->SetPosition(nround((Position+1)*100));
  sprintf(buf,"%.2f",(1+10*Param));
  SCVV->SetText(buf);
  SCV->SetRange(0,1000);
  SCV->SetPosition(nround(Param*1000));
}


void LegendGaussDialog::CloseWindow(int retVal)
{
  int a;
  int R,G,B;
  double x,y,tmp;
  int Amp,Wd,gx,gy;
  struct narray *parray;
  int i;

  if (retVal!=IDOK) {
    TMyDialog::CloseWindow(retVal);
    return;
  }
  if (SetObjFieldFromStyle(Handle,IDLCSTYLE,Obj,Id,"style")) return;
  if (SetObjFieldFromText(Handle,IDLCWIDTH,Obj,Id,"width")) return;
  if (SetObjFieldFromList(Handle,IDLCJOIN,Obj,Id,"join")) return;
  if (SetObjFieldFromText(Handle,IDLCMITER,Obj,Id,"miter_limit")) return;
  Col->GetColor(&R,&G,&B);
  if (putobj(Obj,"R",Id,&R)==-1) return;
  if (putobj(Obj,"G",Id,&G)==-1) return;
  if (putobj(Obj,"B",Id,&B)==-1) return;
  if ((Dir==0) || (Dir==1)) {
    Amp=Wdy;
    Wd=Wdx;
  } else {
    Amp=Wdx;
    Wd=Wdy;
  }
  parray=arraynew(sizeof(int));
  for (i=0;i<=Div;i++) {
    if (Mode==0) {
      x=Wd/((double )Div)*i;
      tmp=(x-Wd*0.5-Wd*Position*0.5)/(Wd/(1+10*Param)/2);
      y=Amp*exp(-tmp*tmp);
    } else if (Mode==1) {
      x=Wd/((double )Div)*i;
      tmp=(x-Wd*0.5-Wd*Position*0.5)/(Wd/(1+10*Param)/2);
      y=Amp/(tmp*tmp+1);
    } else if (Mode==2) {
      x=Wd/((double )Div)*i;
      if (Position>=0) {
        tmp=(x-Wd*0.5-Wd*Position*0.5)/(-Wd*0.5-Wd*Position*0.5);
      } else {
        tmp=(x-Wd*0.5-Wd*Position*0.5)/(Wd*0.5-Wd*Position*0.5);
      }
      y=Amp*tmp*tmp;
    } else if (Mode==3) {
      x=Wd/((double )Div)*i;
      tmp=x/(Wd/(0.25+10*Param));
      y=Amp*0.5*(sin(2.0*MPI*(tmp-Position*0.5))+1);
    }
    if (Dir==0) {
      gx=nround(x);
      gy=Wdy-nround(y);
    } else if (Dir==1) {
      gx=nround(x);
      gy=nround(y);
    } else if (Dir==2) {
      gx=Wdx-nround(y);
      gy=Wdy-nround(x);
    } else if (Dir==3) {
      gx=nround(y);
      gy=Wdy-nround(x);
    }
    gx+=Minx;
    gy+=Miny;
    arrayadd(parray,&gx);
    arrayadd(parray,&gy);
  }
  putobj(Obj,"points",Id,parray);
  a=0;
  putobj(Obj,"interpolation",Id,&a);
  TMyDialog::CloseWindow(retVal);
}

void LegendGaussDialog::EvHScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl)
{
  int Min,Max,Sc,X,ScPos;
  char buf[16];

  if (hWndCtl==DIVSC->Handle) {
    DIVSC->GetRange(Min,Max);
    X=Div;
    switch (scrollCode) {
    case SB_PAGEUP:
      Sc=-10;
      break;
    case SB_PAGEDOWN:
      Sc=10;
      break;
    case SB_LINEUP:
      Sc=-1;
      break;
    case SB_LINEDOWN:
      Sc=1;
      break;
    case SB_THUMBPOSITION:
      Sc=thumbPos-X;
      break;
    case SB_THUMBTRACK:
      Sc=thumbPos-X;
      break;
    default:
      Sc=0;
      break;
    }
    ScPos=X+Sc;
    ScPos=max(Min,ScPos);
    ScPos=min(Max,ScPos);
    Sc=ScPos-X;
    X=ScPos;
    if (Sc==0) return;
    DIVSC->SetPosition(X);
    Div=X;
    sprintf(buf,"%d",Div);
    DIV->SetText(buf);
    Win->WSetParam(Wdx,Wdy,Div,Dir,Mode,Position,Param);
    Win->Invalidate();
  } else {
    SCH->GetRange(Min,Max);
    X=nround((Position+1)*100);
    switch (scrollCode) {
    case SB_PAGEUP:
      Sc=-10;
      break;
    case SB_PAGEDOWN:
      Sc=10;
      break;
    case SB_LINEUP:
      Sc=-1;
      break;
    case SB_LINEDOWN:
      Sc=1;
      break;
    case SB_THUMBPOSITION:
      Sc=thumbPos-X;
      break;
    case SB_THUMBTRACK:
      Sc=thumbPos-X;
      break;
    default:
      Sc=0;
      break;
    }
    ScPos=X+Sc;
    ScPos=max(Min,ScPos);
    ScPos=min(Max,ScPos);
    Sc=ScPos-X;
    X=ScPos;
    if (Sc==0) return;
    SCH->SetPosition(X);
    Position=X/100.0-1;
    sprintf(buf,"%.2f",Position);
    SCHV->SetText(buf);
    Win->WSetParam(Wdx,Wdy,Div,Dir,Mode,Position,Param);
    Win->Invalidate();
  }
}

void LegendGaussDialog::EvVScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl)
{
  int Min,Max,Sc,X,ScPos;
  char buf[5];

  SCV->GetRange(Min,Max);
  X=nround(Param*1000);
  switch (scrollCode) {
  case SB_PAGEUP:
    Sc=-10;
    break;
  case SB_PAGEDOWN:
    Sc=10;
    break;
  case SB_LINEUP:
    Sc=-1;
    break;
  case SB_LINEDOWN:
    Sc=1;
    break;
  case SB_THUMBPOSITION:
    Sc=thumbPos-X;
    break;
  case SB_THUMBTRACK:
    Sc=thumbPos-X;
    break;
  default:
    Sc=0;
    break;
  }
  ScPos=X+Sc;
  ScPos=max(Min,ScPos);
  ScPos=min(Max,ScPos);
  Sc=ScPos-X;
  X=ScPos;
  if (Sc==0) return;
  SCV->SetPosition(X);
  Param=X/1000.0;
  if ((Mode==0) || (Mode==1)) sprintf(buf,"%.2f",(1+10*Param));
  else if (Mode==2) buf[0]='\0';
  else if (Mode==3) sprintf(buf,"%.2f",(0.25+10*Param));
  SCVV->SetText(buf);
  Win->WSetParam(Wdx,Wdy,Div,Dir,Mode,Position,Param);
  Win->Invalidate();
}

void LegendGaussDialog::TopClicked()
{
  if (SendDlgItemMessage(IDLCTOP,BM_GETCHECK,0,0)==1) Dir=0;
  if (SendDlgItemMessage(IDLCBOTTOM,BM_GETCHECK,0,0)==1) Dir=1;
  if (SendDlgItemMessage(IDLCLEFT,BM_GETCHECK,0,0)==1) Dir=2;
  if (SendDlgItemMessage(IDLCRIGHT,BM_GETCHECK,0,0)==1) Dir=3;
  Win->WSetParam(Wdx,Wdy,Div,Dir,Mode,Position,Param);
  Win->Invalidate();
}

void LegendGaussDialog::GaussClicked()
{
  char buf[5];

  if (SendDlgItemMessage(IDLGGAUSS,BM_GETCHECK,0,0)==1) Mode=0;
  if (SendDlgItemMessage(IDLGLORENTZ,BM_GETCHECK,0,0)==1) Mode=1;
  if (SendDlgItemMessage(IDLGPARABOLA,BM_GETCHECK,0,0)==1) Mode=2;
  if (SendDlgItemMessage(IDLGSIN,BM_GETCHECK,0,0)==1) Mode=3;
  Win->WSetParam(Wdx,Wdy,Div,Dir,Mode,Position,Param);
  if ((Mode==0) || (Mode==1)) sprintf(buf,"%.2f",(1+10*Param));
  else if (Mode==2) buf[0]='\0';
  else if (Mode==3) sprintf(buf,"%.2f",(0.25+10*Param));
  SCVV->SetText(buf);
  Win->Invalidate();
}




