/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 *  winlgndx.h
 *
 */

class GaussWinStatic : public TStatic {
  public:
    GaussWinStatic(TWindow *parent,int resId);
    ~GaussWinStatic();
    void WSetParam(int wdx,int wdy,int div,int dir,int mode,double position,double param);
    int Mode;
  protected:
    int Wdx,Wdy;
    int Div,Dir;
    int alloc;
    double Position,Param;
    void EvPaint();
    DECLARE_RESPONSE_TABLE(GaussWinStatic);
};

class LegendGaussDialog  : public TMyDialog {
  public:
    LegendGaussDialog(TWindow *parent,TResId resID,struct objlist *obj,int id,
                      int minx,int miny,int wdx,int wdy);
    ~LegendGaussDialog();
  protected:
    int Minx,Miny,Wdx,Wdy;
    int Div,Dir;
    int Mode;
    double Position,Param;
    TStatic *SCVV,*SCHV,*DIV;
    TScrollBar *SCV,*SCH,*DIVSC;
    ColorButton *Col;
    GaussWinStatic *Win;
    struct objlist *Obj;
    int Id;
    void SetupWindow();
    void SetupItem(int id);
    void CloseWindow(int retVal);
    void TopClicked();
    void GaussClicked();
    void EvHScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl);
    void EvVScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl);
    DECLARE_RESPONSE_TABLE(LegendGaussDialog);
};



