/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 * winmain.cpp
 *
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#include <time.h>

#include <windows.h>

extern "C" {
#include "ngraph.h"
#include "object.h"
#include "ioutil.h"
#include "nstring.h"
#include "jnstring.h"
#include "config.h"
}

#define TRUE  1
#define FALSE 0

#define SYSCONF "[Ngraph]"

char **mainenviron;
char *systemname;
HINSTANCE hInstance;
extern HINSTANCE _hInstance;
extern int globallock;

HANDLE consolefdout=NULL;
HANDLE consolefdin=NULL;
int consoleac=FALSE;
HWND consolehWnd=NULL;
char consoletitle[256];
int consolex=-1;
int consoley=-1;
int consolecol=80;
int consolerow=25;

extern "C" {
void *addobjectroot(void);
void *addint(void);
void *adddouble(void);
void *addstring(void);
void *addiarray(void);
void *adddarray(void);
void *addsarray(void);
void *addsystem(void);
void *addshell(void);
void *adddraw(void);
void *addfile(void);
void *addmath(void);
void *addfit(void);
void *addgra(void);
void *addgra2(void);
void *addgra2null(void);
void *addgra2file(void);
void *addgra2prn(void);
void *addmerge(void);
void *addlegend(void);
void *addline(void);
void *addcurve(void);
void *addrectangle(void);
void *addarc(void);
void *addpolygon(void);
void *addmark(void);
void *addtext(void);
void *addaxis(void);
void *addagrid(void);
void *addprm(void);
void *addgra2win(void);
void *adddialog(void);
void *addmenu(void);
void resizeconsole(int col,int row);
}

int wininputyn(char *mes)
{
  int ret;

  ret=MessageBox(NULL,mes,"Question",MB_YESNO|MB_TASKMODAL|MB_ICONQUESTION|MB_SETFOREGROUND);
  return (ret==IDYES)?TRUE:FALSE;
}

int winputstderr(char *s)
{
  int len;

  len=strlen(s);
  MessageBox(NULL,s,"Error:",MB_OK|MB_TASKMODAL|MB_ICONEXCLAMATION|MB_SETFOREGROUND);
  return len+1;
}

int winprintfstderr(char *fmt,...)
{
  int len;
  char buf[1024];
  va_list ap;

  va_start(ap,fmt);
  len=vsprintf(buf,fmt,ap);
  va_end(ap);
  MessageBox(NULL,buf,"Error:",MB_OK|MB_TASKMODAL|MB_ICONEXCLAMATION|MB_SETFOREGROUND);
  return len;
}

int putconsole(char *s)
{
  DWORD len,len2;

  len=strlen(s);
  WriteFile(consolefdout,s,len,&len2,NULL);
  WriteFile(consolefdout,"\n",1,&len2,NULL);
  return len+1;
}

int printfconsole(char *fmt,...)
{
  DWORD len,len2;
  char buf[1024];
  va_list ap;

  va_start(ap,fmt);
  len=vsprintf(buf,fmt,ap);
  va_end(ap);

  WriteFile(consolefdout,buf,len,&len2,NULL);
  return len;
}

int interruptconsole(void)
{
  return FALSE;
}

int inputynconsole(char *mes)
{
  DWORD len,len2;
  char buf[10];

  len=strlen(mes);
  WriteFile(consolefdout,mes,len,&len2,NULL);
  do {
    ReadFile(consolefdin,buf,1,&len2,NULL);
  } while ((buf[0]!='y') && (buf[0]!='Y') && (buf[0]!='n') && (buf[0]!='N'));
  if ((buf[0]=='y') || (buf[0]=='Y')) return TRUE;
  return FALSE;
}

void displaydialogconsole(char *str)
{
  putconsole(str);
}

void displaystatusconsole(char *str)
{
}

struct savedstdio consolesave;

BOOL CALLBACK EnumFunc(HWND hWnd,LPARAM lParam)
{
  char wtitle[1024];

  GetWindowText(hWnd,wtitle,sizeof(wtitle));
  if (strcmp(wtitle,consoletitle)==0) {
    consolehWnd=hWnd;
    return FALSE;
  }
  return TRUE;
}

void resizeconsole(int col,int row)
{
  CONSOLE_SCREEN_BUFFER_INFO csbi;
  SMALL_RECT rect;
  COORD coordSize;

  if (consoleac) {
    rect.Left=0;
    rect.Top=0;
    rect.Right=col-1;
    rect.Bottom=row-1;
    SetConsoleWindowInfo(consolefdout,TRUE,&rect);

    GetConsoleScreenBufferInfo(consolefdout,&csbi);
    coordSize.X=col;
    coordSize.Y=csbi.dwSize.Y;
    SetConsoleScreenBufferSize(consolefdout,coordSize);
    SetConsoleWindowInfo(consolefdout,TRUE,&rect);
  }
}

int nallocconsole()
{
  int allocnow;
  time_t tm;

  if (!consoleac) {
    allocnow=AllocConsole();
    if (allocnow) {
      time(&tm);
      sprintf(consoletitle,"Ngraph Shell %d",tm);
      SetConsoleTitle(consoletitle);
      consolehWnd=NULL;
      while (consolehWnd==NULL) ::EnumWindows((WNDENUMPROC)EnumFunc,(LPARAM)NULL);
      sprintf(consoletitle,"Ngraph Shell");
      SetConsoleTitle(consoletitle);
      if ((consolex>=0) && (consoley>=0))
        SetWindowPos(consolehWnd,HWND_TOP,consolex,consoley,0,0,SWP_NOSIZE | SWP_NOZORDER);
      consoleac=TRUE;
      consolefdout=GetStdHandle(STD_OUTPUT_HANDLE);
      consolefdin=GetStdHandle(STD_INPUT_HANDLE);
      nsetconsolemode();
      savestdio(&consolesave);
      putstderr=putconsole;
      printfstderr=printfconsole;
      ninterrupt=interruptconsole;
      inputyn=inputynconsole;
      ndisplaydialog=displaydialogconsole;
      ndisplaystatus=displaystatusconsole;

      resizeconsole(consolecol,consolerow);

    }
  } else allocnow=FALSE;
  return allocnow;
}

int nallocconsole2()
{
  int allocnow;

  allocnow=AllocConsole();
  if (allocnow) FreeConsole();
}

void nsetconsolemode()
{

  if (consoleac) {
    SetConsoleMode(consolefdin,ENABLE_LINE_INPUT | ENABLE_ECHO_INPUT |ENABLE_PROCESSED_INPUT);
    SetConsoleMode(consolefdout,ENABLE_PROCESSED_OUTPUT | ENABLE_WRAP_AT_EOL_OUTPUT);
  }
}

void nfreeconsole()
{
  if (consoleac) {
    FreeConsole();
    consoleac=FALSE;
    loadstdio(&consolesave);
  }
}

void nforegroundconsole()
{
  if (consoleac) SetForegroundWindow(consolehWnd);
}

int OwlMain(int argc,char **argv)
{
  char *homedir,*libdir,*lib,*home,*inifile,*loginshell;
  char *inst;
  struct objlist *sys,*obj,*lobj;
  int i,id;
  char *sarg[2];
  struct narray sarray;
  FILE *fp;
  char *tok,*str,*s2;
  char *f1,*endptr;
  int len,val;
  int allocnow,allocconsole;
  struct narray iarray;
  char *arg;

  hInstance=_hInstance;
  mainenviron=_environ;

  ignorestdio(NULL);
  ninterrupt=vinterrupt;
  inputyn=vinputyn;
  printfstderr=seprintf;
  putstderr=seputs;

  if ((lib=getenv("NGRAPHLIB"))!=NULL) {
    if ((libdir=(char *)memalloc(strlen(lib)+1))==NULL) exit(1);
    strcpy(libdir,lib);
  } else {
    for (i=strlen(argv[0]);(argv[0][i]!='\\') && (i>0);i--);
    if ((libdir=(char *)memalloc(i+1))==NULL) exit(1);
    strncpy(libdir,argv[0],i);
    libdir[i]='\0';
  }
  changefilename(libdir);
  if ((home=getenv("NGRAPHHOME"))!=NULL) {
    if ((homedir=(char *)memalloc(strlen(home)+1))==NULL) exit(1);
    strcpy(homedir,home);
  }else if ((home=getenv("HOME"))!=NULL) {
    if ((homedir=(char *)memalloc(strlen(home)+1))==NULL) exit(1);
    strcpy(homedir,home);
  }else if ((home=getenv("Home"))!=NULL) {
    if ((homedir=(char *)memalloc(strlen(home)+1))==NULL) exit(1);
    strcpy(homedir,home);
  } else {
    if ((homedir=(char *)memalloc(strlen(libdir)+1))==NULL) exit(1);
    strcpy(homedir,libdir);
  }
  changefilename(homedir);

  if (addobjectroot()==NULL) exit(1);
  if (addsystem()==NULL) exit(1);

  newobj(getobject("system"));
  if ((sys=getobject("system"))==NULL) exit(1);
  inst=chkobjinst(sys,0);
  if (_putobj(sys,"lib_dir",inst,libdir)) exit(1);
  if (_putobj(sys,"home_dir",inst,homedir)) exit(1);
  if (_getobj(sys,"lib_dir",inst,&libdir)==-1) exit(1);
  if (_getobj(sys,"home_dir",inst,&homedir)==-1) exit(1);
  if (_getobj(sys,"name",inst,&systemname)==-1) exit(1);

  if (addshell()==NULL) exit(1);

  if (addgra()==NULL) exit(1);
  if (addgra2()==NULL) exit(1);
  if (addgra2null()==NULL) exit(1);
  if (addgra2win()==NULL) exit(1);
  if (addgra2file()==NULL) exit(1);
  if (addgra2prn()==NULL) exit(1);

  if (addint()==NULL) exit(1);
  if (adddouble()==NULL) exit(1);
  if (addstring()==NULL) exit(1);
  if (addiarray()==NULL) exit(1);
  if (adddarray()==NULL) exit(1);
  if (addsarray()==NULL) exit(1);
  if (addmath()==NULL) exit(1);
  if (addfit()==NULL) exit(1);
  if (addprm()==NULL) exit(1);

  if (adddraw()==NULL) exit(1);
  if (addagrid()==NULL) exit(1);
  if (addaxis()==NULL) exit(1);
  if (addfile()==NULL) exit(1);
  if (addmerge()==NULL) exit(1);
  if (addlegend()==NULL) exit(1);
  if (addrectangle()==NULL) exit(1);
  if (addline()==NULL) exit(1);
  if (addcurve()==NULL) exit(1);
  if (addarc()==NULL) exit(1);
  if (addpolygon()==NULL) exit(1);
  if (addmark()==NULL) exit(1);
  if (addtext()==NULL) exit(1);

  if (addmenu()==NULL) exit(1);
  if (adddialog()==NULL) exit(1);

  loginshell=NULL;
  allocconsole=FALSE;
  if ((fp=openconfig(SYSCONF))!=NULL) {
     while ((tok=getconfig(fp,&str))!=NULL) {
      s2=str;
      if (strcmp(tok,"login_shell")==0) {
        f1=getitok2(&s2,&len," \x09,");
        if (_putobj(sys,"login_shell",inst,f1)) exit(1);
      } else if (strcmp(tok,"create_object")==0) {
        while ((f1=getitok2(&s2,&len," \x09,"))!=NULL) {
          newobj(getobject(f1));
          memfree(f1);
        }
      } else if (strcmp(tok,"alloc_console")==0) {
        f1=getitok2(&s2,&len," \x09,");
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') {
          if (val==0) allocconsole=FALSE;
          else allocconsole=TRUE;
        }
        memfree(f1);
      } else if (strcmp(tok,"console_position")==0) {
        f1=getitok2(&s2,&len," \x09,");
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') consolex=val;
        memfree(f1);
        f1=getitok2(&s2,&len," \x09,");
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') consoley=val;
        memfree(f1);
      } else if (strcmp(tok,"console_size")==0) {
        f1=getitok2(&s2,&len," \x09,");
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') consolecol=val;
        memfree(f1);
        f1=getitok2(&s2,&len," \x09,");
        val=strtol(f1,&endptr,10);
        if (endptr[0]=='\0') consolerow=val;
        memfree(f1);
      }
      memfree(tok);
      memfree(str);
    }
    closeconfig(fp);
  }

  putstderr=winputstderr;
  printfstderr=winprintfstderr;
  inputyn=wininputyn;
  ndisplaydialog=displaydialogconsole;
  ndisplaystatus=displaystatusconsole;
  GetStdHandle(STD_OUTPUT_HANDLE);
  GetStdHandle(STD_INPUT_HANDLE);
  if (allocconsole) nallocconsole();
  else nallocconsole2();
  inifile=NULL;
  id=newobj((obj=getobject("shell")));
  for (i=1;i<argc;i++) {
    if (argv[i][0]=='-') {
      if (argv[i][1]=='i') {
        i++;
        if (i<argc) {
          if ((inifile=(char *)memalloc(strlen(argv[i])+1))==NULL) exit(1);
          strcpy(inifile,argv[i]);
          changefilename(inifile);
        } else break;
      } else break;
    } else break;
  }
  if (inifile==NULL) {
    if (findfilename(homedir,CONFTOP,systemname))
      inifile=getfilename(homedir,CONFTOP,systemname);
    else if (findfilename(libdir,CONFTOP,systemname))
      inifile=getfilename(libdir,CONFTOP,systemname);
  }
  if (inifile!=NULL) {
    arrayinit(&sarray,sizeof(char *));
    if (arrayadd(&sarray,&inifile)==NULL) exit(1);
    for (;i<argc;i++)
      if (arrayadd(&sarray,&(argv[i]))==NULL) exit(1);
    sarg[0]=(char *)&sarray;
    sarg[1]=NULL;
    exeobj(obj,"shell",id,1,sarg);
    arraydel(&sarray);
    memfree(inifile);
  }

  if (getobj(sys,"login_shell",0,0,NULL,&loginshell)) exit(1);
  do {
    if (_putobj(sys,"login_shell",inst,NULL)) exit(1);
    if (loginshell==NULL) {
      allocnow=nallocconsole();
      exeobj(obj,"shell",id,0,NULL);
      if (allocnow) nfreeconsole();
    } else {
      arrayinit(&iarray,sizeof(int));
      arg=loginshell;
      if (getobjilist2(&arg,&lobj,&iarray,TRUE)) return -1;
      arraydel(&iarray);
      if (lobj==obj) allocnow=nallocconsole();
      else allocnow=FALSE;
      sexeobj(loginshell);
      if (allocnow) nfreeconsole();
    }
    memfree(loginshell);
    if (getobj(sys,"login_shell",0,0,NULL,&loginshell)) exit(1);
  } while (loginshell!=NULL);
  delobj(getobject("system"),0);
  return 0;
}
