/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 *  winmenu.h
 *
 */

extern HINSTANCE hInstance;


class TMyApp : public TApplication {
  public:
    TMyApp(char *file);
    ~TMyApp();
  protected:
    void InitMainWindow();
    void InitInstance();
    bool IdleAction(long idleCount);
    char *File;
};

class TSubFrameWindow;

class TSubWindow : public TWindow {
  public:
    TSubWindow(TWindow* parent):TWindow(parent) {};
    TSubFrameWindow *Frame;
    virtual void Activate();
  protected:
};

class TSubFrameWindow : public TDecoratedFrame {
  public:
    TSubFrameWindow(TWindow *parent,const char far *title,TSubWindow *clientWnd,
     int *x,int *y,int *width,int *height):TDecoratedFrame(parent,title,clientWnd,true)
    {
      client=clientWnd;
      X=x;
      Y=y;
      Width=width;
      Height=height;
      framex=framey=0;
    };
    void WindowShift(int dx,int dy);
  protected:
    void EvSize(UINT sizeType, TSize& size);
    void EvMove(TPoint &clientOrigin);
    void EvDestroy();
    int *X,*Y,*Width,*Height,framex,framey;
    TSubWindow *client;
    void EvActivate(uint active,bool minimized,THandle hWndOther);
    DECLARE_RESPONSE_TABLE(TSubFrameWindow);
};

class TDialogWindow : public TSubWindow {
  public:
    TDialogWindow(TWindow* parent=0);
    ~TDialogWindow();
    void DrawInfoText();
    void Update(int clear);
  protected:
    void SetupWindow();
    TPopupMenu PopupMenu;
    COLORREF col1;
    HBRUSH brush1;
    void Clipboard();
    void EvPaint();
    void DrawText(HDC dc);
    void EvRButtonDown(UINT modKeys, TPoint& point);
    void EvKeyDown(UINT key,UINT repeatCount,UINT flags);
    DECLARE_RESPONSE_TABLE(TDialogWindow);
};

class TCoordWindow : public TSubWindow {
  public:
    TCoordWindow(TWindow* parent=0);
    ~TCoordWindow();
    void SetCoord(int x,int y);
    void Update(int clear);
  protected:
    void SetupWindow();
    COLORREF col1;
    HBRUSH brush1;
    char *str;
    void EvPaint();
    void DrawText(HDC dc);
    void EvKeyDown(UINT key,UINT repeatCount,UINT flags);
    DECLARE_RESPONSE_TABLE(TCoordWindow);
};

class TViewWindow;

class TMyWindow : public TSubWindow {
  public:
    TMyWindow(TWindow *parent=0);
    ~TMyWindow();
    void EnableFrameWindow(TWindow *win,bool enable);
    bool CanClose();
    int Changed;
    TColor custColors[16];
    TControlBar *CB;
    TControlBar *CB2;
    TStatusBar *SB;
    TTextGadget *PointX,*PointY,*Zoom;
    TSeparatorGadget *Separator0,*Separator1,*Separator2,*Separator3;
    int FHeight,FWidth;

    void CmSystemShell();
    void CmFileNew();
    void CmFileOpen();
    void CmFileClose();
    void CmFileUpdate();
    void CmFileEdit();
    void CmFileDirectory();
    void CmFileHistory(WPARAM wparam);
    void CmAxisNewFrame();
    void CmAxisNewSection();
    void CmAxisNewCross();
    void CmAxisNewSingle();
    void CmAxisDel();
    void CmAxisUpdate();
    void CmAxisZoom();
    void CmAxisClear();
    void CmAxisGridNew();
    void CmAxisGridDel();
    void CmAxisGridUpdate();
    void CmLineDel();
    void CmLineUpdate();
    void CmCurveDel();
    void CmCurveUpdate();
    void CmPolyDel();
    void CmPolyUpdate();
    void CmRectDel();
    void CmRectUpdate();
    void CmArcDel();
    void CmArcUpdate();
    void CmMarkDel();
    void CmMarkUpdate();
    void CmTextDel();
    void CmTextUpdate();
    void CmMergeOpen();
    void CmMergeClose();
    void CmMergeUpdate();
    void CmViewerDraw();
    void CmViewerClear();
    void CmViewerClipboard();
    void CmViewerDrawB();
    void CmGraphPage();
    void CmGraphLoad();
    void CmGraphSave();
    void CmGraphOverWrite();
    void CmGraphNewFrame();
    void CmGraphNewSection();
    void CmGraphNewCross();
    void CmGraphAllClear();
    void CmGraphSwitch();
    void CmGraphHistory(WPARAM wparam);
    void CmScriptExec();
    void CmOptionFont();
    void CmOptionViewer();
    void CmOptionExtViewer();
    void CmOptionExtDriver();
    void CmOptionScript();
    void CmOptionMisc();
    void CmOptionSaveDefault();
    void CmOptionSaveNgp();
    void CmOptionFileDef();
    void CmOptionTextDef();
    void CmWindowFile();
    void CmWindowAxis();
    void CmWindowLegend();
    void CmWindowMerge();
    void CmWindowDialog();
    void CmWindowConfig();
    void CmWindowConfig2();
    void CmWindowMove();
    void CmWindowCoord();
    void CmWindowControlBar();
    void CmPrintSetup();
    void CmPrintPrint();
    void CmPrintViewer();
    void CmPrintDriver();
    void CmPrintGRAFile();
    void CmPrintDataFile();
    void CmHelpAbout();
    void CmHelpHelp();

    void PointBPushed();
    void LegendBPushed();
    void LineBPushed();
    void CurveBPushed();
    void RectBPushed();
    void ArcBPushed();
    void PolyBPushed();
    void MarkBPushed();
    void TextBPushed();
    void GaussBPushed();
    void AxisBPushed();
    void TrimBPushed();
    void FrameBPushed();
    void SectionBPushed();
    void CrossBPushed();
    void SingleBPushed();
    void DataBPushed();
    void EvalBPushed();
    void ZoomBPushed();

    void CeWindowFile(TCommandEnabler& ce);
    void CeWindowAxis(TCommandEnabler& ce);
    void CeWindowLegend(TCommandEnabler& ce);
    void CeWindowMerge(TCommandEnabler& ce);
    void CeWindowDialog(TCommandEnabler& ce);
    void CeWindowCoord(TCommandEnabler& ce);
    void CeWindowMove(TCommandEnabler& ce);
    void CeWindowControlBar(TCommandEnabler& ce);

    void CmSetMathAll();
    void CmScaleUndo();
    void CmInterrupt();

    void DisplayDialog(char *str);
    void DisplayStatus(char *str);
    int PutStderr(char *s);
    int InputYN(char *mes);
    void Update();
    void Update2();
    void ChangePage();
    void FileUpdate();
    void SetCoord(int x,int y);
    void SetPoint(int x,int y);
    void SetZoom(double zm);
    void ResetZoom();
    void SetStatusBar(char *mes);
    void ResetStatusBar();
    void DeleteFileWindow() {pTFileWindow=NULL;}
    void DeleteAxisWindow() {pTAxisWindow=NULL;}
    void DeleteMergeWindow() {pTMergeWindow=NULL;}
    void DeleteDialogWindow() {pTDialogWindow=NULL;}
    void DeleteLegendWindow() {pTLegendWindow=NULL;}
    void DeleteCoordWindow() {pTCoordWindow=NULL;}
    int ViewOpened();
    TButtonGadget *interB,*viewB,*fileB,*axisB,*legendB,*mergeB,*dialogB,*coordB;
    TButtonGadget *openfileB,*loadB,*saveB,*printB,*exviewB;
    TButtonGadget *clipB,*drawB,*clearB;
    TButtonGadget *axisClearB,*interruptB;
    TButtonGadget *MathB,*ScaleUndoB;
    int Interrupt;
    int ChkInterrupt();
    void Draw();
    void Focus(struct objlist *legendobj,int id);
    void UnFocus();
    void EvKeyDown2(UINT key,UINT repeatCount,UINT flags);
    void EvDropFiles(TDropInfo);
    void LoadPrmFile(char *File);
    int SaveDrawable(char *name,int storedata,int storemerge);
    int GraphSave(int overwrite);
    int CheckSave();
    int CheckIniFile();
    void SaveHistory();
    void SetFrameCaption(char *file);
    TWindow *ActiveWindow;
    TPrinter *Printer;
    char *infostr;
    void SetInfoText(char *text);
    char *FileName;
    TViewWindow *pTViewWindow;
    TSubWindow *pTFileWindow;
    TSubWindow *pTAxisWindow;
    TSubWindow *pTMergeWindow;
    TSubWindow *pTDialogWindow;
    TSubWindow *pTCoordWindow;
    TSubWindow *pTLegendWindow;
  protected:
    HCURSOR hcrWait,hcrOld;
    void SetMenuFont(void);
    void SetupWindow();
    DECLARE_RESPONSE_TABLE(TMyWindow);
};

extern class TMyWindow *NgraphApp;


