/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 *  winmerge.h
 *
 */

 class MergeDialog  : public TMyDialog {
  public:
    MergeDialog(TWindow *parent,TResId resID,struct objlist *obj,int id);
  protected:
    struct objlist *Obj;
    int Id;
    void SetupWindow();
    void SetupItem(int file,int id);
    void CopyClicked() {
      int sel;
      if ((sel=CopyClick(this,Obj,Id,FileCB))!=-1) SetupItem(FALSE,sel);
    }
    void CloseWindow(int retVal);
    void DeleteClicked() {CloseWindow(IDDELETE);}
    DECLARE_RESPONSE_TABLE(MergeDialog);
};

class TMergeWindow : public TSubWindow {
  public:
    TMergeWindow(TWindow* parent=0);
    ~TMergeWindow();
    void SelectFile(HDC dc,int sel);
    void Update(int clear);
    void ChangeFileNum();
  protected:
    void SetupWindow();
    TPopupMenu PopupMenu;
    int select;
    int filenum;
    COLORREF col1,col1h;
    COLORREF col2;
    HBRUSH brush1;
    HBRUSH brush2;
    HPEN pen1;
    HPEN pen2;
    struct objlist *obj;
    void MergeOpen();
    void MergeDelete();
    void MergeCopy();
    void MergeTop();
    void MergeLast();
    void MergeUpdate();
    void MergeUp();
    void MergeDown();
    void MergeSelect();
    void MergeHidden();
    void EvPaint();
    void EvSize(UINT sizeType, TSize& size);
    void EvLButtonDown(UINT,TPoint& size);
    void EvRButtonDown(UINT modKeys, TPoint& point);
    void EvLButtonDblClk(UINT,TPoint& size);
    void EvKeyDown(UINT key,UINT repeatCount,UINT flags);
    DECLARE_RESPONSE_TABLE(TMergeWindow);
};

