/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 * winopt.cpp
 *
 */

#include <owl\pch.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

extern "C" {
#include "ngraph.h"
#include "object.h"
#include "ioutil.h"
#include "nstring.h"
#include "config.h"
#include "odraw.h"
#include "owinmenu.h"
#include "winfopen.h"
#include "winprt.h"
}

#include "winmenu.h"
#include "winmenu.rh"
#include "windialg.h"
#include "winview.h"
#include "wincommn.h"

char FileOpenBuf2[512]={0};

class DefaultDialog : public TMyDialog {
  public:
    DefaultDialog(TWindow *parent,TResId resID):TMyDialog(parent,resID) {}
    ~DefaultDialog() {};
  protected:
    void SetupWindow() {
      TMyDialog::SetupWindow();
      SendDlgItemMessage(IDSDFRAMEWINDOW,BM_SETCHECK,0,0);
      SendDlgItemMessage(IDSDMDIWINDOW,BM_SETCHECK,0,0);
      SendDlgItemMessage(IDSDFONT,BM_SETCHECK,0,0);
      SendDlgItemMessage(IDSDVIEWER,BM_SETCHECK,0,0);
      SendDlgItemMessage(IDSDEXVIEWER,BM_SETCHECK,0,0);
      SendDlgItemMessage(IDSDEXDRIVER,BM_SETCHECK,0,0);
      SendDlgItemMessage(IDSDSCRIPT,BM_SETCHECK,0,0);
      SendDlgItemMessage(IDSDMISC,BM_SETCHECK,0,0);
    }
    void CloseWindow(int retVal);
};

void DefaultDialog::CloseWindow(int retVal)
{
  struct narray conf;
  char *buf;
  TRect rect;
  struct fontmap *fcur;
  struct extprinter *pcur;
  struct script *scur;
  char *charset,*italic;
  char *driver,*ext,*option,*script;
//  TAbsLocation loc;
//  int controlbf;

  if (retVal==IDOK) {
    if (!NgraphApp->CheckIniFile()) {
      TMyDialog::CloseWindow(retVal);
      return;
    }
    arrayinit(&conf,sizeof(char *));
    if (SendDlgItemMessage(IDSDFRAMEWINDOW,BM_GETCHECK,0,0)) {
      NgraphApp->Frame->GetWindowRect(rect);
      menulocal.menux=rect.left;
      menulocal.menuy=rect.top;
      menulocal.menuwidth=rect.right-rect.left;
      menulocal.menuheight=rect.bottom-rect.top;
      if ((buf=(char *)memalloc(76))!=NULL) {
        sprintf(buf,"menu_win=%d,%d,%d,%d",
          menulocal.menux,menulocal.menuy,menulocal.menuwidth,menulocal.menuheight);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(30))!=NULL) {
        sprintf(buf,"move_child_window=%d",menulocal.movechild);
        arrayadd(&conf,&buf);
      }

    }
    if (SendDlgItemMessage(IDSDMDIWINDOW,BM_GETCHECK,0,0)) {
/*      loc=alTop;
      if (loc==alTop) controlbf=1;
      else if (loc==alBottom) controlbf=2;
      else if (loc==alLeft) controlbf=3;
      else if (loc==alRight) controlbf=4;
      else controlbf=0;
      if ((buf=(char *)memalloc(20))!=NULL) {
        sprintf(buf,"control_bar1=%d",controlbf);
        arrayadd(&conf,&buf);
      }
      loc=alTop;
      if (loc==alTop) controlbf=1;
      else if (loc==alBottom) controlbf=2;
      else if (loc==alLeft) controlbf=3;
      else if (loc==alRight) controlbf=4;
      else controlbf=0;
      if ((buf=(char *)memalloc(20))!=NULL) {
        sprintf(buf,"control_bar2=%d",controlbf);
        arrayadd(&conf,&buf);
      }   */
      if ((buf=(char *)memalloc(76))!=NULL) {
        sprintf(buf,"file_win=%d,%d,%d,%d,%d",
          menulocal.filex,menulocal.filey,menulocal.filewidth,menulocal.fileheight,menulocal.fileopen);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(76))!=NULL) {
        sprintf(buf,"axis_win=%d,%d,%d,%d,%d",
          menulocal.axisx,menulocal.axisy,menulocal.axiswidth,menulocal.axisheight,menulocal.axisopen);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(76))!=NULL) {
        sprintf(buf,"legend_win=%d,%d,%d,%d,%d",
          menulocal.legendx,menulocal.legendy,menulocal.legendwidth,menulocal.legendheight,menulocal.legendopen);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(76))!=NULL) {
        sprintf(buf,"merge_win=%d,%d,%d,%d,%d",
          menulocal.mergex,menulocal.mergey,menulocal.mergewidth,menulocal.mergeheight,menulocal.mergeopen);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(76))!=NULL) {
        sprintf(buf,"information_win=%d,%d,%d,%d,%d",
          menulocal.dialogx,menulocal.dialogy,menulocal.dialogwidth,menulocal.dialogheight,menulocal.dialogopen);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(76))!=NULL) {
        sprintf(buf,"coordinate_win=%d,%d,%d,%d,%d",
          menulocal.coordx,menulocal.coordy,menulocal.coordwidth,menulocal.coordheight,menulocal.coordopen);
        arrayadd(&conf,&buf);
      }
    }
    if (SendDlgItemMessage(IDSDVIEWER,BM_GETCHECK,0,0)) {
      if ((buf=(char *)memalloc(20))!=NULL) {
        sprintf(buf,"viewer_dpi=%d",mwlocal->windpi);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(30))!=NULL) {
        sprintf(buf,"viewer_auto_redraw=%d",mwlocal->autoredraw);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(40))!=NULL) {
        sprintf(buf,"viewer_load_file_on_redraw=%d",mwlocal->redrawf);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(30))!=NULL) {
        sprintf(buf,"viewer_show_ruler=%d",mwlocal->ruler);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(20))!=NULL) {
        sprintf(buf,"viewer_grid=%d",mwlocal->grid);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(20))!=NULL) {
        sprintf(buf,"backgroundR=%d",mwlocal->bgR);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(20))!=NULL) {
        sprintf(buf,"backgroundG=%d",mwlocal->bgG);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(20))!=NULL) {
        sprintf(buf,"backgroundB=%d",mwlocal->bgB);
        arrayadd(&conf,&buf);
      }
    }
    if (SendDlgItemMessage(IDSDEXDRIVER,BM_GETCHECK,0,0)) {
      pcur=menulocal.extprinterroot;
      while (pcur!=NULL) {
        if (pcur->driver==NULL) driver="";
        else driver=pcur->driver;
        if (pcur->ext==NULL) ext="";
        else ext=pcur->ext;
        if (pcur->option==NULL) option="";
        else option=pcur->option;
        if ((buf=(char *)memalloc(strlen(pcur->name)+strlen(driver)+strlen(ext)+strlen(option)+20))!=NULL) {
          sprintf(buf,"ext_driver=%s,%s,%s,%s",pcur->name,driver,ext,option);
          arrayadd(&conf,&buf);
        }
        pcur=pcur->next;
      }
    }
    if (SendDlgItemMessage(IDSDSCRIPT,BM_GETCHECK,0,0)) {
      scur=menulocal.scriptroot;
      while (scur!=NULL) {
        if (scur->script==NULL) script="";
        else script=scur->script;
        if (scur->option==NULL) option="";
        else option=scur->option;
        if ((buf=(char *)memalloc(strlen(scur->name)+strlen(script)+strlen(option)+20))!=NULL) {
          sprintf(buf,"script=%s,%s,%s",scur->name,script,option);
          arrayadd(&conf,&buf);
        }
        scur=scur->next;
      }
    }
    if (SendDlgItemMessage(IDSDMISC,BM_GETCHECK,0,0)) {
      if (menulocal.fontname!=NULL) {
        if ((buf=(char *)memalloc(strlen(menulocal.fontname)+30))!=NULL) {
          if (menulocal.fontcharset==SHIFTJIS_CHARSET) charset="shiftjis";
          else if (menulocal.fontcharset==SYMBOL_CHARSET) charset="symbol";
          else if (menulocal.fontcharset==ANSI_CHARSET) charset="ansi";
          else if (menulocal.fontcharset==OEM_CHARSET) charset="oem";
          else if (menulocal.fontcharset==HANGEUL_CHARSET) charset="hangeul";
          else if (menulocal.fontcharset==CHINESEBIG5_CHARSET) charset="chinesebig5";
          else charset="default";
          if (menulocal.fontitalic==FONT_ROMAN) italic="roman";
          else if (menulocal.fontitalic==FONT_ITALIC) italic="italic";
          else if (menulocal.fontitalic==FONT_BOLD) italic="bold";
          else if (menulocal.fontitalic==FONT_BOLDITALIC) italic="bold_italic";
          else italic="unknown";
          sprintf(buf,"window_font=%d,%s,%s,%s",menulocal.fontsize,charset,italic,menulocal.fontname);
          arrayadd(&conf,&buf);
        }
      }
      if (menulocal.editor!=NULL) {
        if ((buf=(char *)memalloc(strlen(menulocal.editor)+10))!=NULL) {
          sprintf(buf,"editor=%s",menulocal.editor);
          arrayadd(&conf,&buf);
        }
      }
      if ((buf=(char *)memalloc(30))!=NULL) {
        sprintf(buf,"change_directory=%d",menulocal.changedirectory);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(30))!=NULL) {
        sprintf(buf,"save_history=%d",menulocal.savehistory);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(20))!=NULL) {
        sprintf(buf,"save_path=%d",menulocal.savepath);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(30))!=NULL) {
        sprintf(buf,"save_with_data=%d",menulocal.savewithdata);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(30))!=NULL) {
        sprintf(buf,"save_with_merge=%d",menulocal.savewithmerge);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(strlen(menulocal.expanddir)+20))!=NULL) {
        sprintf(buf,"expand_dir=%s",menulocal.expanddir);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(20))!=NULL) {
        sprintf(buf,"expand=%d",menulocal.expand);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(20))!=NULL) {
        sprintf(buf,"ignore_path=%d",menulocal.ignorepath);
        arrayadd(&conf,&buf);
      }
    }
    replaceconfig("[winmenu]",&conf);
    arraydel2(&conf);
    arrayinit(&conf,sizeof(char *));
    if (SendDlgItemMessage(IDSDEXVIEWER,BM_GETCHECK,0,0)) {
      if ((buf=(char *)memalloc(20))!=NULL) {
        sprintf(buf,"win_dpi=%d",menulocal.exwindpi);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(20))!=NULL) {
        sprintf(buf,"win_width=%d",menulocal.exwinwidth);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(20))!=NULL) {
        sprintf(buf,"win_height=%d",menulocal.exwinheight);
        arrayadd(&conf,&buf);
      }
      if ((buf=(char *)memalloc(30))!=NULL) {
        sprintf(buf,"store_in_memory=%d",menulocal.exwinmemory);
        arrayadd(&conf,&buf);
      }
    }
    replaceconfig("[gra2win]",&conf);
    arraydel2(&conf);
    if (SendDlgItemMessage(IDSDFONT,BM_GETCHECK,0,0)) {
      arrayinit(&conf,sizeof(char *));
      fcur=mwlocal->fontmaproot;
      while (fcur!=NULL) {
        if ((buf=(char *)memalloc(strlen(fcur->fontalias)+strlen(fcur->fontname)+50))!=NULL) {
          if (fcur->charset==SHIFTJIS_CHARSET) charset="shiftjis";
          else if (fcur->charset==SYMBOL_CHARSET) charset="symbol";
          else if (fcur->charset==ANSI_CHARSET) charset="ansi";
          else if (fcur->charset==OEM_CHARSET) charset="oem";
          else if (fcur->charset==HANGEUL_CHARSET) charset="hangeul";
          else if (fcur->charset==CHINESEBIG5_CHARSET) charset="chinesebig5";
          else charset="default";
          if (fcur->italic==FONT_ROMAN) italic="roman";
          else if (fcur->italic==FONT_ITALIC) italic="italic";
          else if (fcur->italic==FONT_BOLD) italic="bold";
          else if (fcur->italic==FONT_BOLDITALIC) italic="bold_italic";
          else italic="unknown";
          sprintf(buf,"font_map=%s,%s,%s,%s",fcur->fontalias,charset,italic,fcur->fontname);
          arrayadd(&conf,&buf);
        }
        fcur=fcur->next;
      }
      replaceconfig("[winmenu]",&conf);
      replaceconfig("[gra2win]",&conf);
      arraydel2(&conf);
    }

    arrayinit(&conf,sizeof(char *));
    if (SendDlgItemMessage(IDSDEXDRIVER,BM_GETCHECK,0,0)) {
      if (menulocal.extprinterroot==NULL) {
        if ((buf=(char *)memalloc(20))!=NULL) {
          sprintf(buf,"ext_driver");
          arrayadd(&conf,&buf);
        }
      }
    }
    if (SendDlgItemMessage(IDSDSCRIPT,BM_GETCHECK,0,0)) {
      if (menulocal.scriptroot==NULL) {
        if ((buf=(char *)memalloc(20))!=NULL) {
          sprintf(buf,"script");
          arrayadd(&conf,&buf);
        }
      }
    }
    if (SendDlgItemMessage(IDSDMISC,BM_GETCHECK,0,0)) {
      if (menulocal.editor==NULL) {
        if ((buf=(char *)memalloc(20))!=NULL) {
          sprintf(buf,"editor");
          arrayadd(&conf,&buf);
        }
      }
      if (menulocal.fontname==NULL) {
        if ((buf=(char *)memalloc(20))!=NULL) {
          sprintf(buf,"window_font");
          arrayadd(&conf,&buf);
        }
      }
    }
    removeconfig("[winmenu]",&conf);
    arraydel2(&conf);

    if (SendDlgItemMessage(IDSDFONT,BM_GETCHECK,0,0)) {
      if (mwlocal->fontmaproot==NULL) {
        arrayinit(&conf,sizeof(char *));
        if ((buf=(char *)memalloc(10))!=NULL) {
          sprintf(buf,"font_map");
          arrayadd(&conf,&buf);
        }
        removeconfig("[winmenu]",&conf);
        removeconfig("[gra2win]",&conf);
        arraydel2(&conf);
      }
    }

  }
  TMyDialog::CloseWindow(retVal);
}


class ExViewerDialog  : public TMyDialog {
  public:
    ExViewerDialog(TWindow *parent,TResId resID);
    ~ExViewerDialog();
  protected:
    TStatic *DPI;
    TScrollBar *DPIS;
    int dpi;
    void SetupWindow();
    void CloseWindow(int retVal);
    void EvHScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl);
    DECLARE_RESPONSE_TABLE(ExViewerDialog);
};

DEFINE_RESPONSE_TABLE1(ExViewerDialog,TMyDialog)
  EV_WM_HSCROLL,
END_RESPONSE_TABLE;


ExViewerDialog::ExViewerDialog(TWindow *parent,TResId resID):TMyDialog(parent,resID)
{
  DPI=new TStatic(this,IDVDPI,5);
  DPIS=new TScrollBar(this,IDVDPIS);
}

ExViewerDialog::~ExViewerDialog()
{
  delete DPIS;
  delete DPI;
}

void ExViewerDialog::SetupWindow()
{
  char buf[256];

  TMyDialog::SetupWindow();
  dpi=menulocal.exwindpi;
  sprintf(buf,"%d",dpi);
  DPI->SetText(buf);
  DPIS->SetRange(20,620);
  DPIS->SetPosition(menulocal.exwindpi);
  sprintf(buf,"%d",menulocal.exwinwidth);
  SetDlgItemText(IDEXVWIDTH,buf);
  sprintf(buf,"%d",menulocal.exwinheight);
  SetDlgItemText(IDEXVHEIGHT,buf);
  if (menulocal.exwinmemory) SendDlgItemMessage(IDEXVMEMORY,BM_SETCHECK,1,0);
  else SendDlgItemMessage(IDEXVMEMORY,BM_SETCHECK,0,0);
}

void ExViewerDialog::CloseWindow(int retVal)
{
  int a,len;
  char *buf,*endptr;

  if (retVal!=IDOK) {
    TMyDialog::CloseWindow(retVal);
    return;
  }
  menulocal.exwindpi=dpi;
  len=SendDlgItemMessage(IDEXVWIDTH,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDEXVWIDTH,buf,len+1);
    a=strtol(buf,&endptr,10);
    if (endptr[0]=='\0') menulocal.exwinwidth=a;
    memfree(buf);
  }
  len=SendDlgItemMessage(IDEXVHEIGHT,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDEXVHEIGHT,buf,len+1);
    a=strtol(buf,&endptr,10);
    if (endptr[0]=='\0') menulocal.exwinheight=a;
    memfree(buf);
  }
  a=SendDlgItemMessage(IDEXVMEMORY,BM_GETCHECK,0,0);
  if (a!=2) menulocal.exwinmemory=a;
  TMyDialog::CloseWindow(retVal);
}

void ExViewerDialog::EvHScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl)
{
  int Min,Max,Sc,X,ScPos;
  char buf[5];

  DPIS->GetRange(Min,Max);
  X=dpi;
  switch (scrollCode) {
  case SB_PAGEUP:
    Sc=-10;
    break;
  case SB_PAGEDOWN:
    Sc=10;
    break;
  case SB_LINEUP:
    Sc=-1;
    break;
  case SB_LINEDOWN:
    Sc=1;
    break;
  case SB_THUMBPOSITION:
    Sc=thumbPos-X;
    break;
  case SB_THUMBTRACK:
    Sc=thumbPos-X;
    break;
  default:
    Sc=0;
    break;
  }
  ScPos=X+Sc;
  ScPos=max(Min,ScPos);
  ScPos=min(Max,ScPos);
  Sc=ScPos-X;
  X=ScPos;
  if (Sc==0) return;
  DPIS->SetPosition(X);
  dpi=X;
  sprintf(buf,"%d",dpi);
  DPI->SetText(buf);
}

class ViewerDialog  : public TMyDialog {
  public:
    ViewerDialog(TWindow *parent,TResId resID,struct objlist *obj,int id);
    ~ViewerDialog();
    int Clear;
  protected:
    struct objlist *Obj;
    int Id;
    ColorButton *Col;
    TStatic *DPI;
    TScrollBar *DPIS;
    int dpi,dpis;
    void SetupWindow() {
      TMyDialog::SetupWindow();
      SetupItem(Id);
    }
    void SetupItem(int id);
    void CloseWindow(int retVal);
    void EvHScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl);
    DECLARE_RESPONSE_TABLE(ViewerDialog);
};

DEFINE_RESPONSE_TABLE1(ViewerDialog,TMyDialog)
  EV_WM_HSCROLL,
END_RESPONSE_TABLE;


ViewerDialog::ViewerDialog(TWindow *parent,TResId resID,struct objlist *obj,int id)
:TMyDialog(parent,resID)
{
  Col=new ColorButton(this,IDVCOLOR);
  DPI=new TStatic(this,IDVDPI,5);
  DPIS=new TScrollBar(this,IDVDPIS);
  Obj=obj;
  Id=id;
  Clear=FALSE;
}

ViewerDialog::~ViewerDialog()
{
  delete DPIS;
  delete DPI;
  delete Col;
}

void ViewerDialog::SetupItem(int id)
{
  char buf[64];
  int a;

  getobj(Obj,"dpi",id,0,NULL,&dpi);
  dpis=dpi;
  sprintf(buf,"%d",dpi);
  DPI->SetText(buf);
  DPIS->SetRange(20,620);
  DPIS->SetPosition(dpi);
  a=mwlocal->ruler;
  if (a) SendDlgItemMessage(IDVRULER,BM_SETCHECK,1,0);
  else SendDlgItemMessage(IDVRULER,BM_SETCHECK,0,0);
  getobj(Obj,"auto_redraw",id,0,NULL,&a);
  if (a) SendDlgItemMessage(IDVREDRAW,BM_SETCHECK,1,0);
  else SendDlgItemMessage(IDVREDRAW,BM_SETCHECK,0,0);
  getobj(Obj,"redraw_flag",id,0,NULL,&a);
  if (a) SendDlgItemMessage(IDVLOADFILE,BM_SETCHECK,1,0);
  else SendDlgItemMessage(IDVLOADFILE,BM_SETCHECK,0,0);
  sprintf(buf,"%d",mwlocal->grid);
  SetDlgItemText(IDVGRID,buf);
  Col->SetColor(mwlocal->bgR,mwlocal->bgG,mwlocal->bgB);
}

void ViewerDialog::CloseWindow(int retVal)
{
  int a,len;
  char *buf,*endptr;
  int R,G,B;

  if (retVal!=IDOK) {
    TMyDialog::CloseWindow(retVal);
    return;
  }
  if (dpis!=dpi) {
    if (putobj(Obj,"dpi",Id,&dpi)==-1) return;
    Clear=TRUE;
  }
  a=SendDlgItemMessage(IDVRULER,BM_GETCHECK,0,0);
  if (a!=2) {
    if (mwlocal->ruler!=a) Clear=TRUE;
    mwlocal->ruler=a;
  }
  a=SendDlgItemMessage(IDVREDRAW,BM_GETCHECK,0,0);
  if (a!=2) {
    if (putobj(Obj,"auto_redraw",Id,&a)==-1) return;
    mwlocal->autoredraw=a;
  }
  a=SendDlgItemMessage(IDVLOADFILE,BM_GETCHECK,0,0);
  if (a!=2) {
    if (putobj(Obj,"redraw_flag",Id,&a)==-1) return;
    mwlocal->redrawf=a;
  }
  len=SendDlgItemMessage(IDVGRID,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDVGRID,buf,len+1);
    a=strtol(buf,&endptr,10);
    if (a<1) a=1;
    else if (a>1000) a=1000;
    if (endptr[0]=='\0') mwlocal->grid=a;
    memfree(buf);
  }
  Col->GetColor(&R,&G,&B);
  if ((R!=mwlocal->bgR) || (G!=mwlocal->bgG) || (B!=mwlocal->bgB)) {
    NgraphApp->pTViewWindow->SetBkgndColor(RGB(mwlocal->bgR,mwlocal->bgG,mwlocal->bgB));
    ::InvalidateRect(mwlocal->hWnd,NULL,TRUE);
    mwlocal->bgR=R;
    mwlocal->bgG=G;
    mwlocal->bgB=B;
  }
  TMyDialog::CloseWindow(retVal);
}

void ViewerDialog::EvHScroll(UINT scrollCode, UINT thumbPos, HWND hWndCtl)
{
  int Min,Max,Sc,X,ScPos;
  char buf[5];

  DPIS->GetRange(Min,Max);
  X=dpi;
  switch (scrollCode) {
  case SB_PAGEUP:
    Sc=-10;
    break;
  case SB_PAGEDOWN:
    Sc=10;
    break;
  case SB_LINEUP:
    Sc=-1;
    break;
  case SB_LINEDOWN:
    Sc=1;
    break;
  case SB_THUMBPOSITION:
    Sc=thumbPos-X;
    break;
  case SB_THUMBTRACK:
    Sc=thumbPos-X;
    break;
  default:
    Sc=0;
    break;
  }
  ScPos=X+Sc;
  ScPos=max(Min,ScPos);
  ScPos=min(Max,ScPos);
  Sc=ScPos-X;
  X=ScPos;
  if (Sc==0) return;
  DPIS->SetPosition(X);
  dpi=X;
  sprintf(buf,"%d",dpi);
  DPI->SetText(buf);
}

class MiscDialog  : public TMyDialog {
  public:
    MiscDialog(TWindow *parent,TResId resID):TMyDialog(parent,resID) {
    }
    ~MiscDialog() {
    }
  protected:
    void SetupWindow();
    void BrowseClicked();
    void FontClicked();
    void DefaultFontClicked();
    void CloseWindow(int retVal);
    DECLARE_RESPONSE_TABLE(MiscDialog);
};

DEFINE_RESPONSE_TABLE1(MiscDialog,TMyDialog)
  EV_CHILD_NOTIFY(IDMISCFONT,BN_CLICKED,FontClicked),
  EV_CHILD_NOTIFY(IDMISCDEFAULT,BN_CLICKED,DefaultFontClicked),
  EV_CHILD_NOTIFY(IDMISCBROWSE,BN_CLICKED,BrowseClicked),
END_RESPONSE_TABLE;

void MiscDialog::SetupWindow()
{
  char **enumlist;
  int j;

  TMyDialog::SetupWindow();
  SetDlgItemText(IDMISCEDITOR,menulocal.editor);
  if (menulocal.changedirectory) SendDlgItemMessage(IDMISCCHDIR,BM_SETCHECK,1,0);
  else SendDlgItemMessage(IDMISCCHDIR,BM_SETCHECK,0,0);
  if (menulocal.savehistory) SendDlgItemMessage(IDMISCSAVEHISTORY,BM_SETCHECK,1,0);
  else SendDlgItemMessage(IDMISCSAVEHISTORY,BM_SETCHECK,0,0);
  SendDlgItemMessage(IDMISCSVPATH,CB_RESETCONTENT,0,0);
  enumlist=pathchar;
  for (j=0;enumlist[j]!=NULL;j++)
    SendDlgItemMessage(IDMISCSVPATH,CB_INSERTSTRING,j,(LPARAM)enumlist[j]);
  SendDlgItemMessage(IDMISCSVPATH,CB_SETCURSEL,menulocal.savepath,0);
  SendDlgItemMessage(IDMISCSVDATA,BM_SETCHECK,menulocal.savewithdata,0);
  SendDlgItemMessage(IDMISCSVMERGE,BM_SETCHECK,menulocal.savewithmerge,0);
  if (menulocal.expand) SendDlgItemMessage(IDMISCEXPAND,BM_SETCHECK,1,0);
  else SendDlgItemMessage(IDMISCEXPAND,BM_SETCHECK,0,0);
  SetDlgItemText(IDMISCEXPANDDIR,menulocal.expanddir);
  if (menulocal.ignorepath) SendDlgItemMessage(IDMISCIGNOREPATH,BM_SETCHECK,1,0);
  else SendDlgItemMessage(IDMISCIGNOREPATH,BM_SETCHECK,0,0);
}

void MiscDialog::CloseWindow(int retVal)
{
  int len,a;
  char *buf;

  len=SendDlgItemMessage(IDMISCEDITOR,WM_GETTEXTLENGTH,0,0);
  if (len==0) {
    memfree(menulocal.editor);
    menulocal.editor=NULL;
  } else if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDMISCEDITOR,buf,len+1);
    changefilename(buf);
    memfree(menulocal.editor);
    menulocal.editor=buf;
  }
  if (SendDlgItemMessage(IDMISCCHDIR,BM_GETCHECK,0,0)) menulocal.changedirectory=1;
  else menulocal.changedirectory=0;
  if (SendDlgItemMessage(IDMISCSAVEHISTORY,BM_GETCHECK,0,0)) menulocal.savehistory=1;
  else menulocal.savehistory=0;
  a=SendDlgItemMessage(IDMISCSVPATH,CB_GETCURSEL,0,0);
  if (a!=CB_ERR) menulocal.savepath=a;
  menulocal.savewithdata=SendDlgItemMessage(IDMISCSVDATA,BM_GETCHECK,0,0);
  menulocal.savewithmerge=SendDlgItemMessage(IDMISCSVMERGE,BM_GETCHECK,0,0);
  if (SendDlgItemMessage(IDMISCEXPAND,BM_GETCHECK,0,0)) menulocal.expand=1;
  else menulocal.expand=0;
  len=SendDlgItemMessage(IDMISCEXPANDDIR,WM_GETTEXTLENGTH,0,0);
  if (len!=0) {
    buf=(char *)memalloc(len+1);
    GetDlgItemText(IDMISCEXPANDDIR,buf,len+1);
    memfree(menulocal.expanddir);
    menulocal.expanddir=buf;
  }
  if (SendDlgItemMessage(IDMISCIGNOREPATH,BM_GETCHECK,0,0)) menulocal.ignorepath=1;
  else menulocal.ignorepath=0;
  TMyDialog::CloseWindow(retVal);
}

void MiscDialog::BrowseClicked()
{
  FileOpenBuf2[0]='\0';
  if (nGetOpenFileName2(Handle,"Editor","exe",
      FileOpenBuf2,512,"Executable (*.exe)\0*.exe\0")==IDOK)
    SetDlgItemText(IDMISCEDITOR,FileOpenBuf2);
}

void MiscDialog::FontClicked()
{
  char *name;
  TChooseFontDialog::TData FontData;
  LOGFONT IDFont;
  HDC dc;
  int dpi;

  dc=GetDC(Handle);
  dpi=GetDeviceCaps(dc,LOGPIXELSX);
  ReleaseDC(Handle,dc);
  FontData.DC=0;
  IDFont.lfHeight=menulocal.fontsize*dpi/72;
  IDFont.lfWidth=0;
  IDFont.lfEscapement=IDFont.lfOrientation=0;
  IDFont.lfUnderline=0;
  IDFont.lfStrikeOut=0;
  IDFont.lfPitchAndFamily=FIXED_PITCH;
  IDFont.lfCharSet=menulocal.fontcharset;
  IDFont.lfOutPrecision=0;
  IDFont.lfClipPrecision=0;
  IDFont.lfQuality=PROOF_QUALITY;
  if (menulocal.fontitalic==FONT_ROMAN) {
    IDFont.lfWeight=400;
    IDFont.lfItalic=FALSE;
  } else if (menulocal.fontitalic==FONT_ITALIC) {
    IDFont.lfWeight=400;
    IDFont.lfItalic=TRUE;
  } else if (menulocal.fontitalic==FONT_BOLD) {
    IDFont.lfWeight=700;
    IDFont.lfItalic=FALSE;
  } else if (menulocal.fontitalic==FONT_BOLDITALIC) {
    IDFont.lfWeight=700;
    IDFont.lfItalic=TRUE;
  } else {
    IDFont.lfWeight=0;
    IDFont.lfItalic=0;
  }
  if (menulocal.fontname!=NULL) strcpy(IDFont.lfFaceName,menulocal.fontname);
  else IDFont.lfFaceName[0]=0;
  FontData.LogFont=IDFont;
  FontData.Flags= CF_SCREENFONTS|CF_FIXEDPITCHONLY|CF_FORCEFONTEXIST|CF_INITTOLOGFONTSTRUCT|CF_ANSIONLY;
  FontData.Color=0;
  FontData.Style=0;
  FontData.FontType=SCREEN_FONTTYPE;
  FontData.SizeMin=0;
  FontData.SizeMax=0;
  FontData.PointSize=menulocal.fontsize*10;
  if (TChooseFontDialog(this,FontData).Execute()==IDOK) {
    if ((name=(char *)memalloc(strlen(FontData.LogFont.lfFaceName)+1))!=NULL) {
      memfree(menulocal.fontname);
      strcpy(name,FontData.LogFont.lfFaceName);
      menulocal.fontname=name;
      menulocal.fontsize=FontData.PointSize/10;
      menulocal.fontcharset=FontData.LogFont.lfCharSet;
      if (FontData.LogFont.lfItalic) {
        if (FontData.LogFont.lfWeight==400) menulocal.fontitalic=FONT_ITALIC;
        else menulocal.fontitalic=FONT_BOLDITALIC;
      } else {
        if (FontData.LogFont.lfWeight==400) menulocal.fontitalic=FONT_ROMAN;
        else menulocal.fontitalic=FONT_BOLD;
      }
    } else {
      memfree(menulocal.fontname);
      menulocal.fontname=NULL;
    }
  }
}

void MiscDialog::DefaultFontClicked()
{
  memfree(menulocal.fontname);
  menulocal.fontname=NULL;
}

class ChooseDriverDialog  : public TMyDialog {
  public:
    ChooseDriverDialog(TWindow *parent,TResId resID,struct extprinter *prn)
    :TMyDialog(parent,resID) {
      Driver=prn;
    }
    ~ChooseDriverDialog() {
    }
  protected:
    struct extprinter *Driver;
    void SetupWindow();
    void BrowseClicked();
    void CloseWindow(int retVal);
    DECLARE_RESPONSE_TABLE(ChooseDriverDialog);
};

DEFINE_RESPONSE_TABLE1(ChooseDriverDialog,TMyDialog)
  EV_CHILD_NOTIFY(IDCDBROWSE,BN_CLICKED,BrowseClicked),
END_RESPONSE_TABLE;

void ChooseDriverDialog::SetupWindow()
{
  TMyDialog::SetupWindow();
  SetDlgItemText(IDCDNAME,Driver->name);
  SetDlgItemText(IDCDDRIVER,Driver->driver);
  SetDlgItemText(IDCDEXT,Driver->ext);
  SetDlgItemText(IDCDOPTION,Driver->option);
}

void ChooseDriverDialog::CloseWindow(int retVal)
{
  int len;
  char *buf;

  if (retVal!=IDOK) {
    TMyDialog::CloseWindow(retVal);
    return;
  }
  len=SendDlgItemMessage(IDCDNAME,WM_GETTEXTLENGTH,0,0);
  if (len==0) {
    MessageBox("Please specify driver name.","Error:",MB_ICONEXCLAMATION|MB_OK);
    return;
  }
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDCDNAME,buf,len+1);
    memfree(Driver->name);
    Driver->name=buf;
  }
  len=SendDlgItemMessage(IDCDDRIVER,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDCDDRIVER,buf,len+1);
    changefilename(buf);
    memfree(Driver->driver);
    Driver->driver=buf;
  }
  len=SendDlgItemMessage(IDCDEXT,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDCDEXT,buf,len+1);
    memfree(Driver->ext);
    Driver->ext=buf;
  }
  len=SendDlgItemMessage(IDCDOPTION,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDCDOPTION,buf,len+1);
    memfree(Driver->option);
    Driver->option=buf;
  }
  TMyDialog::CloseWindow(retVal);
}

void ChooseDriverDialog::BrowseClicked()
{
  FileOpenBuf2[0]='\0';
  if (nGetOpenFileName2(Handle,"Driver","exe",
      FileOpenBuf2,512,"Executable (*.exe;*.com)\0*.exe;*.com\0")==IDOK)
    SetDlgItemText(IDCDDRIVER,FileOpenBuf2);
}

class ExtDriverDialog  : public TMyDialog {
  public:
    ExtDriverDialog(TWindow *parent,TResId resID):TMyDialog(parent,resID) {
    }
    ~ExtDriverDialog() {
    }
  protected:
    void SetupWindow() {
      TMyDialog::SetupWindow();
      SetupItem();
    }
    void SetupItem();
    void AddClicked();
    void RemoveClicked();
    void DriverClicked();
    DECLARE_RESPONSE_TABLE(ExtDriverDialog);
};

DEFINE_RESPONSE_TABLE1(ExtDriverDialog,TMyDialog)
  EV_CHILD_NOTIFY(IDEXDADD,BN_CLICKED,AddClicked),
  EV_CHILD_NOTIFY(IDEXDREMOVE,BN_CLICKED,RemoveClicked),
  EV_CHILD_NOTIFY(IDEXDDRIVER,BN_CLICKED,DriverClicked),
  EV_LBN_DBLCLK(IDEXDLIST,DriverClicked),
END_RESPONSE_TABLE;


void ExtDriverDialog::SetupItem()
{
  struct extprinter *fcur;

  SendDlgItemMessage(IDEXDLIST,LB_RESETCONTENT,0,0);
  fcur=menulocal.extprinterroot;
  while (fcur!=NULL) {
    SendDlgItemMessage(IDEXDLIST,LB_INSERTSTRING,-1,(LPARAM)fcur->name);
    fcur=fcur->next;
  }
}

void ExtDriverDialog::AddClicked()
{
  struct extprinter *fcur,*fprev,*fnew;

  fprev=NULL;
  fcur=menulocal.extprinterroot;
  while (fcur!=NULL) {
    fprev=fcur;
    fcur=fcur->next;
  }
  if ((fnew=(struct extprinter *)memalloc(sizeof(struct extprinter)))!=NULL) {
    fnew->next=NULL;
    fnew->name=NULL;
    fnew->driver=NULL;
    fnew->option=NULL;
    fnew->ext=NULL;
    if (fprev==NULL) menulocal.extprinterroot=fnew;
    else fprev->next=fnew;
    if (ChooseDriverDialog(this,DIALOG_CHOOSEDRIVER,fnew).Execute()!=IDOK) {
      if (fprev==NULL) menulocal.extprinterroot=NULL;
      else fprev->next=NULL;
      memfree(fnew);
    }
    SetupItem();
  } else {
    memfree(fnew);
  }
}

void ExtDriverDialog::RemoveClicked()
{
  int j;
  struct extprinter *fcur,*fprev,*fdel;

  j=0;
  fprev=NULL;
  fcur=menulocal.extprinterroot;
  while (fcur!=NULL) {
    if (SendDlgItemMessage(IDEXDLIST,LB_GETSEL,j,0)>0) {
      fdel=fcur;
      if (fprev==NULL) menulocal.extprinterroot=fcur->next;
      else fprev->next=fcur->next;
      fcur=fcur->next;
      memfree(fdel->name);
      memfree(fdel->driver);
      memfree(fdel->option);
      memfree(fdel);
      SetupItem();
      break;
    } else {
      fprev=fcur;
      fcur=fcur->next;
    }
    j++;
  }
}

void ExtDriverDialog::DriverClicked()
{
  int j;
  struct extprinter *fcur;

  j=0;
  fcur=menulocal.extprinterroot;
  while (fcur!=NULL) {
    if (SendDlgItemMessage(IDEXDLIST,LB_GETSEL,j,0)>0) break;
    fcur=fcur->next;
    j++;
  }
  if (fcur!=NULL) {
    ChooseDriverDialog(this,DIALOG_CHOOSEDRIVER,fcur).Execute();
    SetupItem();
  }
}

class ChooseScriptDialog  : public TMyDialog {
  public:
    ChooseScriptDialog(TWindow *parent,TResId resID,struct script *sc)
    :TMyDialog(parent,resID) {
      Script=sc;
    }
    ~ChooseScriptDialog() {
    }
  protected:
    struct script *Script;
    void SetupWindow();
    void BrowseClicked();
    void CloseWindow(int retVal);
    DECLARE_RESPONSE_TABLE(ChooseScriptDialog);
};

DEFINE_RESPONSE_TABLE1(ChooseScriptDialog,TMyDialog)
  EV_CHILD_NOTIFY(IDCSCBROWSE,BN_CLICKED,BrowseClicked),
END_RESPONSE_TABLE;

void ChooseScriptDialog::SetupWindow()
{
  TMyDialog::SetupWindow();
  SetDlgItemText(IDCSCNAME,Script->name);
  SetDlgItemText(IDCSCSCRIPT,Script->script);
  SetDlgItemText(IDCSCOPTION,Script->option);
}

void ChooseScriptDialog::CloseWindow(int retVal)
{
  int len;
  char *buf;

  if (retVal!=IDOK) {
    TMyDialog::CloseWindow(retVal);
    return;
  }
  len=SendDlgItemMessage(IDCSCNAME,WM_GETTEXTLENGTH,0,0);
  if (len==0) {
    MessageBox("Please specify script name.","Error:",MB_ICONEXCLAMATION|MB_OK);
    return;
  }
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDCSCNAME,buf,len+1);
    memfree(Script->name);
    Script->name=buf;
  }
  len=SendDlgItemMessage(IDCSCSCRIPT,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDCSCSCRIPT,buf,len+1);
    changefilename(buf);
    memfree(Script->script);
    Script->script=buf;
  }
  len=SendDlgItemMessage(IDCSCOPTION,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDCSCOPTION,buf,len+1);
    memfree(Script->option);
    Script->option=buf;
  }
  TMyDialog::CloseWindow(retVal);
}

void ChooseScriptDialog::BrowseClicked()
{
  FileOpenBuf2[0]='\0';
  if (nGetOpenFileName2(Handle,"Script","nsc",
      FileOpenBuf2,512,"Executable (*.nsc)\0*.nsc\0")==IDOK) 
    SetDlgItemText(IDCSCSCRIPT,FileOpenBuf2);
}

class ExtScriptDialog  : public TMyDialog {
  public:
    ExtScriptDialog(TWindow *parent,TResId resID):TMyDialog(parent,resID) {
    }
    ~ExtScriptDialog() {
    }
  protected:
    void SetupWindow() {
      TMyDialog::SetupWindow();
      SetupItem();
    }
    void SetupItem();
    void AddClicked();
    void RemoveClicked();
    void ScriptClicked();
    DECLARE_RESPONSE_TABLE(ExtScriptDialog);
};

DEFINE_RESPONSE_TABLE1(ExtScriptDialog,TMyDialog)
  EV_CHILD_NOTIFY(IDEXSCADD,BN_CLICKED,AddClicked),
  EV_CHILD_NOTIFY(IDEXSCREMOVE,BN_CLICKED,RemoveClicked),
  EV_CHILD_NOTIFY(IDEXSCSCRIPT,BN_CLICKED,ScriptClicked),
  EV_LBN_DBLCLK(IDEXSCLIST,ScriptClicked),
END_RESPONSE_TABLE;


void ExtScriptDialog::SetupItem()
{
  struct script *fcur;

  SendDlgItemMessage(IDEXSCLIST,LB_RESETCONTENT,0,0);
  fcur=menulocal.scriptroot;
  while (fcur!=NULL) {
    SendDlgItemMessage(IDEXSCLIST,LB_INSERTSTRING,-1,(LPARAM)fcur->name);
    fcur=fcur->next;
  }
}

void ExtScriptDialog::AddClicked()
{
  struct script *fcur,*fprev,*fnew;

  fprev=NULL;
  fcur=menulocal.scriptroot;
  while (fcur!=NULL) {
    fprev=fcur;
    fcur=fcur->next;
  }
  if ((fnew=(struct script *)memalloc(sizeof(struct script)))!=NULL) {
    fnew->next=NULL;
    fnew->name=NULL;
    fnew->script=NULL;
    fnew->option=NULL;
    if (fprev==NULL) menulocal.scriptroot=fnew;
    else fprev->next=fnew;
    if (ChooseScriptDialog(this,DIALOG_CHOOSESCRIPT,fnew).Execute()!=IDOK) {
      if (fprev==NULL) menulocal.scriptroot=NULL;
      else fprev->next=NULL;
      memfree(fnew);
    }
    SetupItem();
  } else {
    memfree(fnew);
  }
}

void ExtScriptDialog::RemoveClicked()
{
  int j;
  struct script *fcur,*fprev,*fdel;

  j=0;
  fprev=NULL;
  fcur=menulocal.scriptroot;
  while (fcur!=NULL) {
    if (SendDlgItemMessage(IDEXSCLIST,LB_GETSEL,j,0)>0) {
      fdel=fcur;
      if (fprev==NULL) menulocal.scriptroot=fcur->next;
      else fprev->next=fcur->next;
      fcur=fcur->next;
      memfree(fdel->name);
      memfree(fdel->script);
      memfree(fdel->option);
      memfree(fdel);
      SetupItem();
      break;
    } else {
      fprev=fcur;
      fcur=fcur->next;
    }
    j++;
  }
}

void ExtScriptDialog::ScriptClicked()
{
  int j;
  struct script *fcur;

  j=0;
  fcur=menulocal.scriptroot;
  while (fcur!=NULL) {
    if (SendDlgItemMessage(IDEXSCLIST,LB_GETSEL,j,0)>0) break;
    fcur=fcur->next;
    j++;
  }
  if (fcur!=NULL) {
    ChooseScriptDialog(this,DIALOG_CHOOSESCRIPT,fcur).Execute();
    SetupItem();
  }
}

class FontDialog  : public TMyDialog {
  public:
    FontDialog(TWindow *parent,TResId resID):TMyDialog(parent,resID) {
    }
    ~FontDialog() {
    }
  protected:
    void SetupWindow() {
      TMyDialog::SetupWindow();
      SetupItem();
    }
    void SetupItem();
    void AddClicked();
    void RemoveClicked();
    void FontClicked();
    DECLARE_RESPONSE_TABLE(FontDialog);
};

DEFINE_RESPONSE_TABLE1(FontDialog,TMyDialog)
  EV_CHILD_NOTIFY(IDFOADD,BN_CLICKED,AddClicked),
  EV_CHILD_NOTIFY(IDFOREMOVE,BN_CLICKED,RemoveClicked),
  EV_CHILD_NOTIFY(IDFOFONT,BN_CLICKED,FontClicked),
  EV_LBN_DBLCLK(IDFOLIST,FontClicked),
END_RESPONSE_TABLE;


void FontDialog::SetupItem()
{
  struct fontmap *fcur;

  SendDlgItemMessage(IDFOLIST,LB_RESETCONTENT,0,0);
  fcur=mwlocal->fontmaproot;
  while (fcur!=NULL) {
    SendDlgItemMessage(IDFOLIST,LB_INSERTSTRING,-1,(LPARAM)fcur->fontalias);
    fcur=fcur->next;
  }
}

void FontDialog::AddClicked()
{
  int j,len;
  char *buf,*name;
  struct fontmap *fcur,*fprev,*fnew;

  len=SendDlgItemMessage(IDFOALIAS,WM_GETTEXTLENGTH,0,0);
  if (len==0) {
    MessageBox("Please specify a new alias name.","Error:",MB_ICONEXCLAMATION|MB_OK);
    return;
  }
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDFOALIAS,buf,len+1);
    j=0;
    fprev=NULL;
    fcur=mwlocal->fontmaproot;
    while (fcur!=NULL) {
      if (strcmp0(fcur->fontalias,buf)==0) {
        MessageBox("Alias name already exists.","Error:",MB_ICONEXCLAMATION|MB_OK);
        memfree(buf);
        return;
      }
      j++;
      fprev=fcur;
      fcur=fcur->next;
    }
    if (((fnew=(struct fontmap *)memalloc(sizeof(struct fontmap)))!=NULL)
    && ((name=(char *)memalloc(12))!=NULL)) {
      strcpy(name,"Courier New");
      fnew->next=NULL;
      fnew->fontalias=buf;
      fnew->fontname=name;
      fnew->italic=FONT_ROMAN;
      fnew->charset=ANSI_CHARSET;
      if (fprev==NULL) mwlocal->fontmaproot=fnew;
      else fprev->next=fnew;
      SetupItem();
    } else {
      memfree(buf);
      memfree(fnew);
      memfree(name);
    }
  }
}

void FontDialog::RemoveClicked()
{
  int j;
  struct fontmap *fcur,*fprev,*fdel;

  j=0;
  fprev=NULL;
  fcur=mwlocal->fontmaproot;
  while (fcur!=NULL) {
    if (SendDlgItemMessage(IDFOLIST,LB_GETSEL,j,0)>0) {
      fdel=fcur;
      if (fprev==NULL) mwlocal->fontmaproot=fcur->next;
      else fprev->next=fcur->next;
      fcur=fcur->next;
      memfree(fdel->fontalias);
      memfree(fdel->fontname);
      memfree(fdel);
      SetupItem();
      break;
    } else {
      fprev=fcur;
      fcur=fcur->next;
    }
    j++;
  }
}

void FontDialog::FontClicked()
{
  TChooseFontDialog::TData FontData;
  PRINTDLG pd;
  LOGFONT IDFont;
  int len,j;
  struct fontmap *fcur;
  char *name;
  HDC dc;
  int dpi;

  dc=GetDC(Handle);
  dpi=GetDeviceCaps(dc,LOGPIXELSX);
  ReleaseDC(Handle,dc);
  j=0;
  fcur=mwlocal->fontmaproot;
  while (fcur!=NULL) {
    if (SendDlgItemMessage(IDFOLIST,LB_GETSEL,j,0)>0) break;
    fcur=fcur->next;
    j++;
  }
  if (fcur!=NULL) {
    InitPrinter(&pd);
    NGetDefaultPrinter(&pd,TRUE);
    FontData.DC=pd.hDC;
    IDFont.lfHeight=20*dpi/72;
    IDFont.lfWidth=0;
    IDFont.lfEscapement=IDFont.lfOrientation=0;
    IDFont.lfUnderline=0;
    IDFont.lfStrikeOut=0;
    IDFont.lfPitchAndFamily=0;
    IDFont.lfCharSet=fcur->charset;
    IDFont.lfOutPrecision=0;
    IDFont.lfClipPrecision=0;
    IDFont.lfQuality=0;
    if (fcur->italic==FONT_ROMAN) {
      IDFont.lfWeight=400;
      IDFont.lfItalic=FALSE;
    } else if (fcur->italic==FONT_ITALIC) {
      IDFont.lfWeight=400;
      IDFont.lfItalic=TRUE;
    } else if (fcur->italic==FONT_BOLD) {
      IDFont.lfWeight=700;
      IDFont.lfItalic=FALSE;
    } else if (fcur->italic==FONT_BOLDITALIC) {
      IDFont.lfWeight=700;
      IDFont.lfItalic=TRUE;
    } else {
      IDFont.lfWeight=0;
      IDFont.lfItalic=0;
    }
    strcpy(IDFont.lfFaceName,fcur->fontname);
    FontData.LogFont=IDFont;
    FontData.Flags=CF_BOTH | CF_SCALABLEONLY | CF_FORCEFONTEXIST
                  |CF_INITTOLOGFONTSTRUCT;
    FontData.Color=0;
    FontData.Style=0;
    FontData.FontType=SCREEN_FONTTYPE;
    FontData.SizeMin=0;
    FontData.SizeMax=0;
    FontData.PointSize=200;
    if (TChooseFontDialog(this,FontData).Execute()==IDOK) {
      len=strlen(FontData.LogFont.lfFaceName);
      if ((len!=0) && ((name=(char *)memalloc(len+1))!=NULL)) {
        memfree(fcur->fontname);
        strcpy(name,FontData.LogFont.lfFaceName);
        fcur->fontname=name;
        fcur->charset=FontData.LogFont.lfCharSet;
        if (FontData.LogFont.lfItalic) {
          if (FontData.LogFont.lfWeight==400) fcur->italic=FONT_ITALIC;
          else fcur->italic=FONT_BOLDITALIC;
        } else {
          if (FontData.LogFont.lfWeight==400) fcur->italic=FONT_ROMAN;
          else fcur->italic=FONT_BOLD;
        }
        SetupItem();
      }
    }
    DonePrinter(&pd);
  }
}

void TMyWindow::CmOptionFont()
{
  TViewWindow *win;

  if (menulock || globallock) return;
  FontDialog(this,DIALOG_FONT).Execute();
  win=(TViewWindow *)pTViewWindow;
  if (win!=NULL) win->Update(TRUE);
}

void TMyWindow::CmOptionViewer()
{
  TViewWindow *win;
  ViewerDialog *dlg;

  if (menulock || globallock) return;
  dlg=new ViewerDialog(this,DIALOG_VIEWER,menulocal.obj,0);
  if (dlg->Execute()==IDOK) {
    win=(TViewWindow *)pTViewWindow;
    if ((win!=NULL) && (dlg->Clear)) win->ChangeDPI();
  }
  delete dlg;
}

void TMyWindow::CmOptionExtViewer()
{
  if (menulock || globallock) return;
  ExViewerDialog(this,DIALOG_EXVIEWER).Execute();
}

void TMyWindow::CmOptionExtDriver()
{
  if (menulock || globallock) return;
  ExtDriverDialog(this,DIALOG_EXTDRIVER).Execute();
}

void TMyWindow::CmOptionScript()
{
  if (menulock || globallock) return;
  ExtScriptDialog(this,DIALOG_EXTSCRIPT).Execute();
}

void TMyWindow::CmOptionMisc()
{
  if (menulock || globallock) return;
  MiscDialog(this,DIALOG_MISC).Execute();
  SetMenuFont();
  Update();
}

void TMyWindow::CmOptionSaveDefault()
{
  if (menulock || globallock) return;
  DefaultDialog(this,DIALOG_DEFAULT).Execute();
}





