/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 * winprint.cpp
 *
 */

#include <owl\pch.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <io.h>

extern "C" {
#include "ngraph.h"
#include "object.h"
#include "ioutil.h"
#include "shell.h"
#include "nstring.h"
#include "config.h"
#include "mathcode.h"
#include "mathfn.h"
#include "gra.h"
#include "winfopen.h"
#include "owinmenu.h"
#include "winprt.h"
}

#include "winmenu.h"
#include "winmenu.rh"
#include "windialg.h"
#include "wincommn.h"

#include <owl\printer.h>

class TMyPrintout : public TPrintout {
  public:

    TMyPrintout(const char* title,struct objlist *obj,int id,int width,int height);
    void EndPrinting();
    void GetDialogInfo(int& minPage, int& maxPage,
                       int& selFromPage, int& selToPage);
    void PrintPage(int page, TRect& rect, unsigned flags);
    void SetBanding(BOOL b) {Banding = b;}
    bool HasPage(int pageNumber) {return pageNumber == 1;}
  protected:
    int PaperWidth,PaperHeight;
    struct objlist *graobj;
    int graid;
    BOOL Scale;
};

TMyPrintout::TMyPrintout(const char *title,struct objlist *obj,int id,int width,int height):TPrintout(title)
{
  PaperWidth=width;
  PaperHeight=height;
  graobj=obj;
  graid=id;
}

void TMyPrintout::PrintPage(int, TRect& , unsigned)
{
  int prevMode;
  TSize oldVExt,oldWExt;
  struct mwlocal mwsave;
  struct narray *larray;
  int dpi,GC;
  HDC DDC;

  prevMode=DC->SetMapMode(MM_ISOTROPIC);
  dpi=DC->GetDeviceCaps(LOGPIXELSX);
  TSize Ext(nround(PaperWidth/2540.0*dpi),nround(PaperHeight/2540.0*dpi));
  DC->SetWindowExt(Ext,&oldWExt);
  DC->SetViewportExt(Ext,&oldVExt);
  DDC=HDC(*DC);
  getobj(graobj,"open",graid,0,NULL,&GC);
  mwsaveDC(DDC,NgraphApp->Handle,0,0,&mwsave,dpi,FALSE,NULL);
  exeobj(graobj,"draw",graid,0,NULL);
  exeobj(graobj,"flush",graid,0,NULL);
  exeobj(graobj,"close",graid,0,NULL);
  _getobj(menulocal.obj,"_list",menulocal.inst,&larray);
  arrayfree2(larray);
  _putobj(menulocal.obj,"_list",menulocal.inst,NULL);
  mwrestoreDC(&mwsave);
  DC->SetWindowExt(oldWExt);
  DC->SetViewportExt(oldVExt);
  DC->SetMapMode(prevMode);
}

void TMyPrintout::GetDialogInfo(int& minPage, int& maxPage,
                                int& selFromPage, int& selToPage)
{
  minPage = 0;
  maxPage = 0;
  selFromPage = selToPage = 0;
}

void TMyPrintout::EndPrinting()
{
}

void TMyWindow::CmPrintSetup()
{
  int h,w;
  TPrintDialog::TData *tpd;
  DEVMODE *dm;

  if (menulock || globallock) return;
  if (Printer==NULL) Printer=new TPrinter;
  h=menulocal.PaperHeight;
  w=menulocal.PaperWidth;
  tpd=Printer->GetData();
  tpd->PageSetupFlags=tpd->PageSetupFlags | PSD_DISABLEMARGINS;
  dm=(DEVMODE *)tpd->GetDevMode();
  SetDevMode(dm,&h,&w);
  EnableFrameWindow(this,false);
  Printer->Setup(NgraphApp);
  EnableFrameWindow(this,true);
  GetDevMode(dm,&h,&w);
  if ((h!=menulocal.PaperHeight) || (w!=menulocal.PaperWidth)) {
    menulocal.PaperHeight=h;
    menulocal.PaperWidth=w;
    SetPageSettingsToGRA();
    NgraphApp->ChangePage();
    GetPageSettingsFromGRA();
  }
}

void TMyWindow::CmPrintPrint()
{
  struct objlist *graobj;
  int id;
  char *device;
  int GC,GCsave;
  struct narray *larraysave;
  struct narray *drawrable;
  int i,h,w;
  struct savedstdio stdio;
  char *title;
  TMyPrintout *Printout;
  TPrintDialog::TData *tpd;
  DEVMODE far *dm;

  if (menulock || globallock ) return;
  if (SetFileHiden((TWindow *)this)) {
    FileAutoScale();
    AdjustAxis();
    if ((graobj=chkobject("gra"))==NULL) return;
    SetStatusBar("Printing.");
    id=newobj(graobj);
    putobj(graobj,"paper_width",id,&(menulocal.PaperWidth));
    putobj(graobj,"paper_height",id,&(menulocal.PaperHeight));
    putobj(graobj,"left_margin",id,&(menulocal.LeftMargin));
    putobj(graobj,"top_margin",id,&(menulocal.TopMargin));
    putobj(graobj,"zoom",id,&(menulocal.PaperZoom));
    if (arraynum(&(menulocal.drawrable))>0) {
      drawrable=arraynew(sizeof(char *));
      for (i=0;i<arraynum(&(menulocal.drawrable));i++) {
        arrayadd2(drawrable,(char **)arraynget(&(menulocal.drawrable),i));
      }
    } else drawrable=NULL;
    putobj(graobj,"draw_obj",id,drawrable);
    device=(char *)memalloc(10);
    strcpy(device,"menu:0");
    putobj(graobj,"device",id,device);
    _getobj(menulocal.obj,"_list",menulocal.inst,&larraysave);
    _putobj(menulocal.obj,"_list",menulocal.inst,NULL);
    GC=-1;
    _getobj(menulocal.obj,"_GC",menulocal.inst,&GCsave);
    _putobj(menulocal.obj,"_GC",menulocal.inst,&GC);
    h=menulocal.PaperHeight;
    w=menulocal.PaperWidth;
    ignorestdio(&stdio);
    if (NgraphApp->FileName==NULL) title="Ngraph";
    else title=NgraphApp->FileName;
    if (Printer==NULL) Printer=new TPrinter;
    Printout=new TMyPrintout(title,graobj,id,w,h);
    Printout->SetBanding(FALSE);
    tpd=Printer->GetData();
    dm=(DEVMODE far *)tpd->GetDevMode();
    SetDevMode(dm,&h,&w);
    globallock=TRUE;
    EnableFrameWindow(this,false);
    Printer->Print(NgraphApp,*Printout,TRUE);
    EnableFrameWindow(this,true);
    globallock=FALSE;
    GetDevMode(dm,&h,&w);
    delete Printout;
    restorestdio(&stdio);
    _putobj(menulocal.obj,"_list",menulocal.inst,larraysave);
    _putobj(menulocal.obj,"_GC",menulocal.inst,&GCsave);
    delobj(graobj,id);
    ResetStatusBar();
    if ((h!=menulocal.PaperHeight) || (w!=menulocal.PaperWidth)) {
      menulocal.PaperHeight=h;
      menulocal.PaperWidth=w;
      SetPageSettingsToGRA();
      NgraphApp->ChangePage();
      GetPageSettingsFromGRA();
    }
    Update();
  }
}

void TMyWindow::CmPrintViewer()
{
  struct objlist *graobj,*g2wobj;
  int id,g2wid,g2woid;
  char *device,*g2winst;
  int GC,delgra;
  struct narray *drawrable;
  int i;
  struct savedstdio stdio;

  if (menulock || globallock ) return;
  if (SetFileHiden((TWindow *)this)) {
    FileAutoScale();
    AdjustAxis();
    if ((graobj=chkobject("gra"))==NULL) return;
    if ((g2wobj=chkobject("gra2win"))==NULL) return;
    SetStatusBar("Spawning external viewer.");
    g2wid=newobj(g2wobj);
    if (g2wid!=-1) {
      g2winst=chkobjinst(g2wobj,g2wid);
      _getobj(g2wobj,"oid",g2winst,&g2woid);
      putobj(g2wobj,"store_in_memory",g2wid,&(menulocal.exwinmemory));
      putobj(g2wobj,"dpi",g2wid,&(menulocal.exwindpi));
      putobj(g2wobj,"width",g2wid,&(menulocal.exwinwidth));
      putobj(g2wobj,"height",g2wid,&(menulocal.exwinheight));
      id=newobj(graobj);
      putobj(graobj,"paper_width",id,&(menulocal.PaperWidth));
      putobj(graobj,"paper_height",id,&(menulocal.PaperHeight));
      putobj(graobj,"left_margin",id,&(menulocal.LeftMargin));
      putobj(graobj,"top_margin",id,&(menulocal.TopMargin));
      putobj(graobj,"zoom",id,&(menulocal.PaperZoom));
      if (arraynum(&(menulocal.drawrable))>0) {
        drawrable=arraynew(sizeof(char *));
        for (i=0;i<arraynum(&(menulocal.drawrable));i++) {
          arrayadd2(drawrable,(char **)arraynget(&(menulocal.drawrable),i));
        }
      } else drawrable=NULL;
      ignorestdio(&stdio);
      putobj(graobj,"draw_obj",id,drawrable);
      device=(char *)memalloc(20);
      sprintf(device,"gra2win:^%d",g2woid);
      putobj(graobj,"device",id,device);
      getobj(graobj,"open",id,0,NULL,&GC);
      exeobj(graobj,"draw",id,0,NULL);
      exeobj(graobj,"flush",id,0,NULL);
      if (!menulocal.exwinmemory) {
        delgra=TRUE;
        _putobj(g2wobj,"delete_gra",g2winst,&delgra);
      } else {
        exeobj(graobj,"close",id,0,NULL);
        delobj(graobj,id);
      }
      restorestdio(&stdio);
    }
    ResetStatusBar();
  }
}

char OutputFileBuf[512]={'\0'};

class DriverDialog  : public TMyDialog {
  public:
    DriverDialog(TWindow *parent,TResId resID,struct objlist *obj,int id)
    :TMyDialog(parent,resID)
    {
      Obj=obj;
      Id=id;
    }
  protected:
    struct objlist *Obj;
    int Id;
    void SetupWindow() {
      TMyDialog::SetupWindow();
      SetupItem();
    }
    void SetupItem();
    void CloseWindow(int retVal);
    void DriverSelected();
    void BrowseClicked();
    DECLARE_RESPONSE_TABLE(DriverDialog);
};

DEFINE_RESPONSE_TABLE1(DriverDialog,TMyDialog)
  EV_CHILD_NOTIFY(IDDDRIVER,CBN_SELCHANGE,DriverSelected),
  EV_CHILD_NOTIFY(IDDBROWSE,BN_CLICKED,BrowseClicked),
END_RESPONSE_TABLE;

void DriverDialog::SetupItem()
{
  int i;
  struct extprinter *pcur;

  SendDlgItemMessage(IDDDRIVER,CB_RESETCONTENT,0,0);
  pcur=menulocal.extprinterroot;
  i=0;
  while (pcur!=NULL) {
    SendDlgItemMessage(IDDDRIVER,CB_INSERTSTRING,i,(LPARAM)pcur->name);
    pcur=pcur->next;
    i++;
  }
  if (i!=0) {
    SendDlgItemMessage(IDDDRIVER,CB_SETCURSEL,0,0);
    DriverSelected();
  }
}

void DriverDialog::CloseWindow(int retVal)
{
  struct extprinter *pcur;
  int a,i,j,len1,len2;
  char *driver,*option,*buf;

  if (retVal!=IDOK) {
    TMyDialog::CloseWindow(retVal);
    return;
  }
  a=SendDlgItemMessage(IDDDRIVER,CB_GETCURSEL,0,0);
  if (a!=CB_ERR) {
    pcur=menulocal.extprinterroot;
    i=0;
    while (pcur!=NULL) {
      if (i==a) {
        if (pcur->driver!=NULL) {
          if ((driver=(char *)memalloc(strlen(pcur->driver)+1))!=NULL) {
            strcpy(driver,pcur->driver);
            putobj(Obj,"driver",Id,driver);
          }
        }
        break;
      }
      pcur=pcur->next;
      i++;
    }
  }
  len1=SendDlgItemMessage(IDDOPTION,WM_GETTEXTLENGTH,0,0);
  len2=SendDlgItemMessage(IDDFILE,WM_GETTEXTLENGTH,0,0);
  if ((option=(char *)memalloc(len1+len2+9))!=NULL) {
    j=0;
    option[j]='\0';
    if (len2!=0) {
      GetDlgItemText(IDDFILE,option,len2+1);
      if (access(option,04)==0) {
        buf=(char *)memalloc(strlen(option)+60);
        if (buf!=NULL) {
          sprintf(buf,
#ifdef ENGLISH
                   "`%s'\n\nOverwrite existing file?",
#else
                   "`%s'\n\nt@C݂܂B㏑Ă낵łH",
#endif
                   option);
          if (MessageBox(buf,"Driver",MB_ICONQUESTION|MB_YESNO)!=IDYES) {
            memfree(buf);
            memfree(option);
	          TMyDialog::CloseWindow(IDCANCEL);
            return;
          }
          memfree(buf);
        } else {
          if (MessageBox(
#ifdef ENGLISH
                   "Overwrite existing file?",
#else
                   "t@C݂܂B㏑Ă낵łH",
#endif
                   "Driver",MB_ICONQUESTION|MB_YESNO)!=IDNO) {
            memfree(option);
            TMyDialog::CloseWindow(IDCANCEL);
            return;
          }
        }
      }
      option[j++]='-';
      option[j++]='o';
      option[j++]=' ';
      option[j++]='\'';
      option[j++]='"';
      GetDlgItemText(IDDFILE,option+j,len2+1);
      j=strlen(option);
      option[j++]='"';
      option[j++]='\'';
      option[j++]=' ';
      option[j]='\0';
      changefilename(option);
    }
    if (len1!=0) GetDlgItemText(IDDOPTION,option+j,len1+1);
    putobj(Obj,"option",Id,option);
  } else {
    TMyDialog::CloseWindow(IDCANCEL);
    return;
  }
  TMyDialog::CloseWindow(retVal);
}

void DriverDialog::DriverSelected()
{
  struct extprinter *pcur;
  int a,i,j;
  char buf[1024];

  a=SendDlgItemMessage(IDDDRIVER,CB_GETCURSEL,0,0);
  if (a!=CB_ERR) {
    pcur=menulocal.extprinterroot;
    i=0;
    while (pcur!=NULL) {
      if (i==a) {
        SetDlgItemText(IDDFILE,NULL);
        if ((pcur->ext!=NULL) && (pcur->ext[0]!='\0') && (NgraphApp->FileName!=NULL)) {
          strcpy(buf,NgraphApp->FileName);
          if (strchr(buf,'.')!=NULL) {
            for (j=strlen(buf)-1;buf[j]!='.';j--);
            buf[j]='\0';
          }
          strcat(buf,pcur->ext);
          SetDlgItemText(IDDFILE,buf);
        }
        SetDlgItemText(IDDOPTION,pcur->option);
        break;
      }
      pcur=pcur->next;
      i++;
    }
  }
}

void DriverDialog::BrowseClicked()
{
  OutputFileBuf[0]='\0';
  if (nGetSaveFileName(Handle,"External Driver output",NULL,NULL,
      OutputFileBuf,512,"All files (*.*)\0*.*\0",menulocal.changedirectory)==IDOK) {
    SendDlgItemMessage(IDDFILE,WM_SETTEXT,0,(LPARAM)OutputFileBuf);
  }
}

class OutputDataDialog  : public TMyDialog {
  public:
    OutputDataDialog(TWindow *parent,TResId resID);
    int div;
  protected:
    void SetupWindow() {
      TMyDialog::SetupWindow();
      SetupItem();
    }
    void SetupItem();
    void CloseWindow(int retVal);
};

OutputDataDialog::OutputDataDialog(TWindow *parent,TResId resID):TMyDialog(parent,resID)
{
}

void OutputDataDialog::SetupItem()
{
  char buf[256];

  sprintf(buf,"%d",div);
  SetDlgItemText(IDOUTDDIV,buf);
}

void OutputDataDialog::CloseWindow(int retVal)
{
  int len,a;
  char *buf;
  char *endptr;

  if (retVal!=IDOK) {
    TMyDialog::CloseWindow(retVal);
    return;
  }
  len=SendDlgItemMessage(IDOUTDDIV,WM_GETTEXTLENGTH,0,0);
  if ((buf=(char *)memalloc(len+1))!=NULL) {
    GetDlgItemText(IDOUTDDIV,buf,len+1);
    a=strtol(buf,&endptr,10);
    if (endptr[0]=='\0') div=a;
    memfree(buf);
  }
  TMyDialog::CloseWindow(retVal);
}

void TMyWindow::CmPrintDriver()
{
  struct objlist *graobj,*g2wobj;
  int id,g2wid,g2woid;
  char *device,*g2winst;
  int GC,ret;
  DriverDialog *dlgd;
  struct narray *drawrable;
  int i;
  struct savedstdio stdio;

  if (menulock || globallock ) return;
  if (SetFileHiden((TWindow *)this)) {
    FileAutoScale();
    AdjustAxis();
    if ((graobj=chkobject("gra"))==NULL) return;
    if ((g2wobj=chkobject("gra2prn"))==NULL) return;
    g2wid=newobj(g2wobj);
    if (g2wid>=0) {
      dlgd=new DriverDialog(this,DIALOG_DRIVER,g2wobj,g2wid);
      ret=dlgd->Execute();
      if (ret==IDOK) {
        SetStatusBar("Spawning external driver.");
        g2winst=chkobjinst(g2wobj,g2wid);
        _getobj(g2wobj,"oid",g2winst,&g2woid);
        id=newobj(graobj);
        putobj(graobj,"paper_width",id,&(menulocal.PaperWidth));
        putobj(graobj,"paper_height",id,&(menulocal.PaperHeight));
        putobj(graobj,"left_margin",id,&(menulocal.LeftMargin));
        putobj(graobj,"top_margin",id,&(menulocal.TopMargin));
        putobj(graobj,"zoom",id,&(menulocal.PaperZoom));
        if (arraynum(&(menulocal.drawrable))>0) {
          drawrable=arraynew(sizeof(char *));
          for (i=0;i<arraynum(&(menulocal.drawrable));i++) {
            arrayadd2(drawrable,(char **)arraynget(&(menulocal.drawrable),i));
          }
        } else drawrable=NULL;
        putobj(graobj,"draw_obj",id,drawrable);
        device=(char *)memalloc(20);
        sprintf(device,"gra2prn:^%d",g2woid);
        putobj(graobj,"device",id,device);
        SetStatusBar("Printing.");
        ignorestdio(&stdio);
        getobj(graobj,"open",id,0,NULL,&GC);
        exeobj(graobj,"draw",id,0,NULL);
        exeobj(graobj,"flush",id,0,NULL);
        exeobj(graobj,"close",id,0,NULL);
        restorestdio(&stdio);
        delobj(graobj,id);
        ResetStatusBar();
      }
      delobj(g2wobj,g2wid);
      delete dlgd;
    }
  }
}

char PrintFileBuf[512]={'\0'};

void TMyWindow::CmPrintGRAFile()
{
  struct objlist *graobj,*g2wobj;
  int id,g2wid,g2woid;
  char *device,*g2winst;
  int GC;
  char *file,*buf;
  struct narray *drawrable;
  int i;
  struct savedstdio stdio;

  if (menulock || globallock ) return;
  PrintFileBuf[0]='\0';
  EnableFrameWindow(this,false);
  if (nGetSaveFileName(Handle,"GRA file","gra",NULL,
      PrintFileBuf,512,"GRA file (*.gra)\0*.gra\0",menulocal.changedirectory)==IDOK) {
    if (access(PrintFileBuf,04)==0) {
      buf=(char *)memalloc(strlen(PrintFileBuf)+60);
      if (buf!=NULL) {
        sprintf(buf,
#ifdef ENGLISH
                   "`%s'\n\nOverwrite existing file?",
#else
                   "`%s'\n\nt@C݂܂B㏑Ă낵łH",
#endif

                   PrintFileBuf);
        if (MessageBox(buf,"GRA file",MB_ICONQUESTION|MB_YESNO)!=IDYES) {
          memfree(buf);
          EnableFrameWindow(this,true);
          return;
        }
        memfree(buf);
      } else {
        if (MessageBox(
#ifdef ENGLISH
                   "Overwrite existing file?",
#else
                   "t@C݂܂B㏑Ă낵łH",
#endif
                   "GRA file",MB_ICONQUESTION|MB_YESNO)!=IDYES) {
          EnableFrameWindow(this,true);
          return;
        }
      }
    }
    if ((file=(char *)memalloc(strlen(PrintFileBuf)+1))==NULL) {
      EnableFrameWindow(this,true);
      return;
    }
    strcpy(file,PrintFileBuf);
    if (SetFileHiden((TWindow *)this)) {
      FileAutoScale();
      AdjustAxis();
      if ((graobj=chkobject("gra"))==NULL) {
        memfree(file);
        EnableFrameWindow(this,true);
        return;
      }
      if ((g2wobj=chkobject("gra2file"))==NULL) {
        memfree(file);
        EnableFrameWindow(this,true);
        return;
      }
      g2wid=newobj(g2wobj);
      if (g2wid>=0) {
        SetStatusBar("Making GRA file.");
        g2winst=chkobjinst(g2wobj,g2wid);
        _getobj(g2wobj,"oid",g2winst,&g2woid);
        putobj(g2wobj,"file",g2wid,file);
        id=newobj(graobj);
        putobj(graobj,"paper_width",id,&(menulocal.PaperWidth));
        putobj(graobj,"paper_height",id,&(menulocal.PaperHeight));
        putobj(graobj,"left_margin",id,&(menulocal.LeftMargin));
        putobj(graobj,"top_margin",id,&(menulocal.TopMargin));
        putobj(graobj,"zoom",id,&(menulocal.PaperZoom));
        if (arraynum(&(menulocal.drawrable))>0) {
          drawrable=arraynew(sizeof(char *));
          for (i=0;i<arraynum(&(menulocal.drawrable));i++) {
            arrayadd2(drawrable,(char **)arraynget(&(menulocal.drawrable),i));
          }
        } else drawrable=NULL;
        putobj(graobj,"draw_obj",id,drawrable);
        device=(char *)memalloc(20);
        sprintf(device,"gra2file:^%d",g2woid);
        putobj(graobj,"device",id,device);
        ignorestdio(&stdio);
        getobj(graobj,"open",id,0,NULL,&GC);
        exeobj(graobj,"draw",id,0,NULL);
        exeobj(graobj,"flush",id,0,NULL);
        exeobj(graobj,"close",id,0,NULL);
        restorestdio(&stdio);
        delobj(graobj,id);
        delobj(g2wobj,g2wid);
        ResetStatusBar();
      }
    }
  }
  EnableFrameWindow(this,true);
}

void TMyWindow::CmPrintDataFile()
{
  CopyDialog *dlg;
  struct objlist *obj;
  int id;
  int type,div;
  char *buf;
  OutputDataDialog *odlg;
  char *argv[3];

  if (menulock || globallock ) return;
  if ((obj=chkobject("file"))==NULL) return;
  if (chkobjlastinst(obj)==-1) return;
  dlg=new CopyDialog((TWindow *)this,DIALOG_COPY,obj,-1,FileCB);
  if (dlg->Execute()==IDOK) {
    id=dlg->sel;
    if ((id>=0) && (id<=chkobjlastinst(obj))) {
      div=10;
      getobj(obj,"type",id,0,NULL,&type);
      if (type==3) {
        odlg=new OutputDataDialog(this,DIALOG_OUTPUTDATA);
        odlg->div=div;
        if (odlg->Execute()!=IDOK) {
          delete odlg;
          return;
        }
        div=odlg->div;
        delete odlg;
      }
      PrintFileBuf[0]='\0';
      EnableFrameWindow(this,false);
      if (nGetSaveFileName(Handle,"Data file",NULL,NULL,
          PrintFileBuf,512,"All files (*.*)\0*.*\0Data files (*.dat)\0*.dat\0",menulocal.changedirectory)==IDOK) {
        if (access(PrintFileBuf,04)==0) {
          buf=(char *)memalloc(strlen(PrintFileBuf)+60);
          if (buf!=NULL) {
            sprintf(buf,
#ifdef ENGLISH
                   "`%s'\n\nOverwrite existing file?",
#else
                   "`%s'\n\nt@C݂܂B㏑Ă낵łH",
#endif
                   PrintFileBuf);
            if (MessageBox(buf,"Data file",MB_ICONQUESTION|MB_YESNO)!=IDYES) {
              memfree(buf);
              delete dlg;
              EnableFrameWindow(this,true);
              return;
            }
            memfree(buf);
          } else {
            if (MessageBox(
#ifdef ENGLISH
                   "Overwrite existing file?",
#else
                   "t@C݂܂B㏑Ă낵łH",
#endif
                   "Data file",MB_ICONQUESTION|MB_YESNO)!=IDYES) {
              delete dlg;
              EnableFrameWindow(this,true);
              return;
            }
          }
        }
        SetStatusBar("Making data file.");
        changefilename(PrintFileBuf);
        argv[0]=(char *)PrintFileBuf;
        argv[1]=(char *)&div;
        argv[2]=NULL;
        exeobj(obj,"output_file",id,2,argv);
        ResetStatusBar();
      }
      EnableFrameWindow(this,true);
    }
  }
  delete dlg;
}


