/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 * winprt.c
 *
 */

#include <windows.h>
#include <stdio.h>

#include "winprt.h"

extern HINSTANCE hInstance;

#define PAGESIZENUM 12

struct pagesize {
  int width;
  int height;
  short size,orientation;
} pagesize[PAGESIZENUM]={
  {29700,42000,DMPAPER_A3,DMORIENT_PORTRAIT},
  {21000,29700,DMPAPER_A4,DMORIENT_PORTRAIT},
  {29700,21000,DMPAPER_A4,DMORIENT_LANDSCAPE},
  {14800,21000,DMPAPER_A5,DMORIENT_PORTRAIT},
  {21000,14800,DMPAPER_A5,DMORIENT_LANDSCAPE},
  {25700,36400,DMPAPER_B4,DMORIENT_PORTRAIT},
  {18200,25700,DMPAPER_B5,DMORIENT_PORTRAIT},
  {25700,18200,DMPAPER_B5,DMORIENT_LANDSCAPE},
  {21590,27940,DMPAPER_LETTER,DMORIENT_PORTRAIT},
  {27940,21590,DMPAPER_LETTER,DMORIENT_LANDSCAPE},
  {21590,35560,DMPAPER_LEGAL,DMORIENT_PORTRAIT},
  {35560,21590,DMPAPER_LEGAL,DMORIENT_LANDSCAPE},
};

void PrintDlgLock(PRINTDLG *pd)
{
  if (pd->hDevMode!=NULL) pd->hDevMode=GlobalLock(pd->hDevMode);
  if (pd->hDevNames!=NULL) pd->hDevNames=GlobalLock(pd->hDevNames);
}

void PrintDlgUnlock(PRINTDLG *pd)
{
  if (pd->hDevMode!=NULL) GlobalUnlock(pd->hDevMode);
  if (pd->hDevNames!=NULL) GlobalUnlock(pd->hDevNames);
}

void InitPrinter(PRINTDLG *pd)
{
  pd->lStructSize = sizeof(PRINTDLG);
  pd->hDevMode = (HANDLE) NULL;
  pd->hDevNames = (HANDLE) NULL;
}

void DonePrinter(PRINTDLG *pd)
{
  if (pd->hDC!=NULL) DeleteDC(pd->hDC);
  PrintDlgUnlock(pd);
  if (pd->hDevMode!=NULL) {
    GlobalFree(pd->hDevMode);
    pd->hDevMode=NULL;
  }
  if (pd->hDevNames!=NULL) {
    GlobalFree(pd->hDevNames);
    pd->hDevNames=NULL;
  }
}

void SetDevMode(DEVMODE *dm,int *height,int *width)
{
  int i;
  short l,w,orientation;

  if (dm!=NULL) {
    for (i=0;i<PAGESIZENUM;i++) {
      if ((pagesize[i].height==*height) && (pagesize[i].width==*width)) {
        dm->dmFields &= 0xfffffff0;
        dm->dmFields |= DM_ORIENTATION | DM_PAPERSIZE;
        dm->dmOrientation=pagesize[i].orientation;
        dm->dmPaperSize=pagesize[i].size;
        break;
      }
    }
    if (i==PAGESIZENUM) {
      dm->dmFields &= 0xfffffff0;
      dm->dmFields |= DM_ORIENTATION | DM_PAPERSIZE | DM_PAPERLENGTH | DM_PAPERWIDTH;
      if (*height>*width) {
        orientation=DMORIENT_PORTRAIT;
        l=*height/10;
        w=*width/10;
      } else {
        orientation=DMORIENT_LANDSCAPE;
        w=*height/10;
        l=*width/10;
      }
      dm->dmOrientation=orientation;
      dm->dmPaperSize=0;
      dm->dmPaperLength=l;
      dm->dmPaperWidth=w;
    }
  }
}

void GetDevMode(DEVMODE *dm,int *height,int *width)
{
  int i;

  if (dm!=NULL) {
    if ((dm->dmFields & DM_ORIENTATION) && (dm->dmFields & DM_PAPERSIZE)) {
      for (i=0;i<PAGESIZENUM;i++) {
        if ((dm->dmOrientation==pagesize[i].orientation) &&
            (dm->dmPaperSize==pagesize[i].size)) {
          *height=pagesize[i].height;
          *width=pagesize[i].width;
          break;
        }
      }
      if (i==PAGESIZENUM) {
        if ((dm->dmFields & DM_PAPERLENGTH) && (dm->dmFields & DM_PAPERWIDTH)) {
          *height=dm->dmPaperLength*10;
          *width=dm->dmPaperWidth*10;
        }
      }
    } else {
      if ((dm->dmFields & DM_PAPERLENGTH) && (dm->dmFields & DM_PAPERWIDTH)) {
        *height=dm->dmPaperLength*10;
        *width=dm->dmPaperWidth*10;
      }
    }
  }
}

void NGetDefaultPrinter(PRINTDLG *pd,int returndc)
{
  if (pd->hDevMode!=NULL) {
    GlobalUnlock(pd->hDevMode);
    GlobalFree(pd->hDevMode);
    pd->hDevMode=NULL;
  }
  if (pd->hDevNames!=NULL) {
    GlobalUnlock(pd->hDevNames);
    GlobalFree(pd->hDevNames);
    pd->hDevNames=NULL;
  }
  pd->lStructSize = sizeof(PRINTDLG);
  pd->Flags = PD_RETURNDEFAULT | PD_NOSELECTION;
  if (returndc) pd->Flags |= PD_RETURNDC;
  pd->hwndOwner = NULL;
  pd->hDC = (HDC) NULL;
  pd->nFromPage = 1;
  pd->nToPage = 1;
  pd->nMinPage = 0;
  pd->nMaxPage = 0;
  pd->nCopies = 1;
  pd->hInstance = (HANDLE) NULL;
  pd->lCustData = 0L;
  pd->lpfnPrintHook = (LPPRINTHOOKPROC) NULL;
  pd->lpfnSetupHook = (LPSETUPHOOKPROC) NULL;
  pd->lpPrintTemplateName = (LPSTR) NULL;
  pd->lpSetupTemplateName = (LPSTR)  NULL;
  pd->hPrintTemplate = (HANDLE) NULL;
  pd->hSetupTemplate = (HANDLE) NULL;
  PrintDlg(pd);
}

