/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 * winscrip.cpp
 *
 */

#include <owl\pch.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <io.h>

extern "C" {
#include "ngraph.h"
#include "object.h"
#include "ioutil.h"
#include "shell.h"
#include "nstring.h"
#include "winfopen.h"
#include "owinmenu.h"
}

#include "winmenu.h"
#include "winmenu.rh"
#include "windialg.h"
#include "wincommn.h"

class ScriptDialog  : public TMyDialog {
  public:
    ScriptDialog(TWindow *parent,TResId resID)
    :TMyDialog(parent,resID)
    {
    }
    char *execscript;
    char option[256];
  protected:
    void SetupWindow() {
      TMyDialog::SetupWindow();
      SetupItem();
    }
    void SetupItem();
    void CloseWindow(int retVal);
    void ScriptSelected();
    DECLARE_RESPONSE_TABLE(ScriptDialog);
};

DEFINE_RESPONSE_TABLE1(ScriptDialog,TMyDialog)
  EV_LBN_DBLCLK(IDSCSCRIPT,CmOk),
  EV_CHILD_NOTIFY(IDSCSCRIPT,LBN_SELCHANGE,ScriptSelected),
END_RESPONSE_TABLE;

void ScriptDialog::SetupItem()
{
  int i;
  struct script *scur;

  SendDlgItemMessage(IDSCSCRIPT,LB_RESETCONTENT,0,0);
  scur=menulocal.scriptroot;
  i=0;
  while (scur!=NULL) {
    SendDlgItemMessage(IDSCSCRIPT,LB_INSERTSTRING,i,(LPARAM)scur->name);
    scur=scur->next;
    i++;
  }
//  if (i!=0) {
//    scur=menulocal.scriptroot;
//    SendDlgItemMessage(IDSCSCRIPT,LB_SETCURSEL,0,0);
//    SetDlgItemText(IDSCOPTION,scur->option);
//  }
}

void ScriptDialog::CloseWindow(int retVal)
{
  int i,a;
  struct script *pcur;

  if (retVal!=IDOK) {
    TMyDialog::CloseWindow(retVal);
    return;
  }
  GetDlgItemText(IDSCOPTION,option,256);
  execscript=NULL;
  a=SendDlgItemMessage(IDSCSCRIPT,LB_GETCURSEL,0,0);
  if (a!=CB_ERR) {
    pcur=menulocal.scriptroot;
    i=0;
    while (pcur!=NULL) {
      if (i==a) {
        if (pcur->script!=NULL) {
          if ((execscript=(char *)memalloc(strlen(pcur->script)+1))!=NULL) {
            strcpy(execscript,pcur->script);
          }
        }
        break;
      }
	  pcur=pcur->next;
	  i++;
	}
  }
  TMyDialog::CloseWindow(retVal);
}

void ScriptDialog::ScriptSelected()
{
  struct script *scur;
  int a,i;

  a=SendDlgItemMessage(IDSCSCRIPT,LB_GETCURSEL,0,0);
  if (a!=CB_ERR) {
	scur=menulocal.scriptroot;
	i=0;
	while (scur!=NULL) {
	  if (i==a) {
		SetDlgItemText(IDSCOPTION,scur->option);
		break;
	  }
	  scur=scur->next;
	  i++;
	}
  }
}

void TMyWindow::CmScriptExec()
{
  struct objlist *obj;
  char *name;
  int newid,allocnow;
  ScriptDialog *dlg;
  char *option,*s;
  int len;
  char *argv[2];
  struct narray sarray;
  char mes[256];
  struct objlist *robj,*shell;
  char *inst;
  int idn;

  if (menulock || globallock) return;
  if ((shell=chkobject("shell"))==NULL) return;
  dlg=new ScriptDialog(this,DIALOG_SCRIPT);
  if ((dlg->Execute()==IDOK) && (dlg->execscript!=NULL)) {
    name=dlg->execscript;
    newid=newobj(shell);
    if (newid>=0) {
      arrayinit(&sarray,sizeof(char *));
      changefilename(name);
      if (arrayadd(&sarray,&name)==NULL) {
        memfree(name);
        arraydel2(&sarray);
        delete dlg;
        return;
      }
      option=dlg->option;
      while ((s=getitok2(&option,&len," \x09"))!=NULL) {
        if (arrayadd(&sarray,&s)==NULL) {
          memfree(s);
          arraydel2(&sarray);
          delete dlg;
          return;
        }
      }
      if (menulocal.addinconsole) {
        allocnow=nAllocConsole();
      }
      argv[0]=(char *)&sarray;
      argv[1]=NULL;
      sprintf(mes,"Executing `%.128s'.",name);
      SetStatusBar(mes);

      GetApplication()->PumpWaitingMessages();
      menulock=TRUE;
      obj=menulocal.obj;
      inst=menulocal.inst;
      idn=getobjtblpos(obj,"_evloop",&robj);
      registerevloop(chkobjectname(obj),"_evloop",robj,idn,inst,NULL);

      exeobj(shell,"shell",newid,1,argv);

      unregisterevloop(robj,idn,inst);
      menulock=FALSE;
      SetForegroundWindow(menulocal.hWnd);

      ResetStatusBar();
      arraydel2(&sarray);
      if (menulocal.addinconsole) nFreeConsole(allocnow);
      GetPageSettingsFromGRA();
      Update2();
      NgraphApp->Changed=TRUE;
    } else memfree(name);
    delobj(shell,newid);
  }
  delete dlg;
}

