/* 
 * 
 * This file is part of "Ngraph for Windows".
 * 
 * Copyright (C) 2015, Satoshi ISHIZAKA. isizaka@msa.biglobe.ne.jp
 * 
 * "Ngraph for Windows" is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * "Ngraph for Windows" is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

/*
 *
 *  winview.h
 *
 */

class TMyScroller : public TScroller {
  public:
    TMyScroller(TWindow* window,int xUnit,int yUnit,double xRange,double yRange);
};

class EvalDialog  : public TMyDialog {
  public:
    EvalDialog(TWindow *parent,TResId resID,struct objlist *obj,int num,struct narray *iarray);
  protected:
    struct narray *sel;
    struct objlist *Obj;
    int Num;
    void SetupWindow();
    void MaskClicked();
    void MoveClicked();
    void CloseWindow(int retval = IDOK);
    DECLARE_RESPONSE_TABLE(EvalDialog);
};

class TViewWindow : public TMyWindow {
  public:
    TViewWindow(TWindow* parent=0);
    ~TViewWindow();

    void Update(int clear);
    void ChangeDPI();
    void OpenGDC();
    void ReopenGDC();
    void CloseGDC();
    void ChangeScroller();
    void SetupWindow();
    void CloseWindow(int retValue=IDCANCEL);
    void EvSize(UINT sizeType, TSize& size);
    void Draw(int SelectFile);
    void Clear();
    void Clipboard();
    void MakeRuler(HDC dc,struct mwlocal *mwlocal);
    void Focus(struct objlist *legendobj,int id);
    void UnFocus();
    void ButtonPushed();
    TButtonGadget *PointB;
    TButtonGadget *LegendB,*LineB,*CurveB,*RectB,*ArcB,*PolyB,*MarkB,*TextB;
    TButtonGadget *GaussB;
    TButtonGadget *AxisB,*TrimB,*FrameB,*SectionB,*CrossB,*SingleB;
    TButtonGadget *DataB,*EvalB,*ZoomB;
    TButtonGadget *Mode;
  protected:
    int PaintLock;
    HRGN region;
    TPopupMenu PopupMenu,PopupMenu2;
    TBitmap *PointBM;
    TBitmap *LegendBM,*LineBM,*CurveBM,*RectBM,*ArcBM,*PolyBM,*MarkBM,*TextBM;
    TBitmap *GaussBM;
    TBitmap *AxisBM,*TrimBM,*FrameBM,*SectionBM,*CrossBM,*SingleBM;
    TBitmap *DataBM,*EvalBM,*ZoomBM;
    int cx,cy;
    int allclear;
    int MoveData;
    int Capture,MouseX1,MouseY1,MouseX2,MouseY2,MouseDX,MouseDY,MouseMode;
    int RefX1,RefY1,RefX2,RefY2,ChangePoint;
    int ShowRect;
    void ShowFrameRect(HDC dc);
    struct narray *focusobj;
    struct narray *points;
    void ShowPoints(HDC dc);
    int ShowFrame,FrameOfsX,FrameOfsY;
    void ShowFocusFrame(HDC dc);
    int ShowLine,LineX,LineY;
    int ShowCross,CrossX,CrossY;
    void ShowFocusLine(HDC dc,int change);
    void ShowCrossGauge(HDC dc);
    void GetLargeFrame(int *minx,int *miny,int *maxx,int *maxy);
    void GetFocusFrame(int *minx,int *miny,int *maxx,int *maxy,int ofsx,int ofsy);
    void AddInvalidateRect(struct objlist *obj,char *inst);
    void AddList(struct objlist *obj,char *inst);
    void DelList(struct objlist *obj,char *inst);
    void Match(char *objname,int x1,int y1,int x2,int y2,int err);
    void Trimming(int x1,int y1,int x2,int y2);
    void Evaluate(int x1,int y1,int x2,int y2,int err);
    int FileUpdate(int x1,int y1,int x2,int y2,int err);
    void ViewDelete();
    void ViewUpdate();
    void ViewCopy();
    void ViewTop();
    void ViewLast();
    void EvPaint();
    void ViewCross();
    void CheckGrid(int ofs,UINT modKeys,int *x,int *y,double *zoom);
    void EvLButtonDown(UINT modKeys, TPoint& point);
    void EvRButtonDown(UINT modKeys, TPoint& point);
    void EvLButtonUp(UINT modKeys, TPoint& point);
    void EvMouseMove(UINT modKeys, TPoint& point);
    void EvLButtonDblClk(UINT,TPoint& size);
    void EvKeyDown(UINT key,UINT repeatCount,UINT flags);
    void EvKeyUp(UINT key,UINT repeatCount,UINT flags);
    DECLARE_RESPONSE_TABLE(TViewWindow);
};
